/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects.objecttree;

import workbench.gui.dbobjects.objecttree.TreePosition;
import workbench.resource.Settings;
import workbench.util.StringUtil;

public class DbTreeSettings {
    public static final String SETTINGS_PREFIX = "workbench.gui.dbtree.";

    public static String getRowCountFormatString() {
        return StringUtil.trimToNull(Settings.getInstance().getProperty("workbench.gui.dbtree.rowcount.formatstring", null));
    }

    public static String getRowCountGroupSymbol() {
        return Settings.getInstance().getProperty("workbench.gui.dbtree.rowcount.groupsymbol", Settings.getInstance().getDecimalGroupCharacter());
    }

    public static boolean useIntegerFormatterForRowCount() {
        return Settings.getInstance().getBoolProperty("workbench.gui.dbtree.rowcount.global.integer.format", false);
    }

    public static TreePosition getDbTreePosition() {
        String string = Settings.getInstance().getProperty("workbench.gui.dbtree.position", TreePosition.left.name());
        try {
            return TreePosition.valueOf(string);
        }
        catch (Throwable throwable) {
            return TreePosition.left;
        }
    }

    public static boolean useTabConnection() {
        return Settings.getInstance().getBoolProperty("workbench.gui.dbtree.use.tab.connection", true);
    }

    public static void setUseTabConnection(boolean bl) {
        Settings.getInstance().setProperty("workbench.gui.dbtree.use.tab.connection", bl);
    }

    public static void setDbTreePosition(TreePosition treePosition) {
        Settings.getInstance().setProperty("workbench.gui.dbtree.position", treePosition.name());
    }

    public static boolean getFilterWhileTyping() {
        return Settings.getInstance().getBoolProperty("workbench.gui.dbtree.quickfilter", true);
    }

    public static void setFilterWhileTyping(boolean bl) {
        Settings.getInstance().setProperty("workbench.gui.dbtree.quickfilter", bl);
    }

    public static boolean showCountRowsAction() {
        return Settings.getInstance().getBoolProperty("workbench.gui.dbtree.count.rows.visible", false);
    }

    public static void setShowCountRowsAction(boolean bl) {
        Settings.getInstance().setProperty("workbench.gui.dbtree.count.rows.visible", bl);
    }

    public static boolean useColumnListForTableDataDisplay(String string) {
        String string2 = "tabledata.select.use.columns";
        String string3 = Settings.getInstance().getProperty(SETTINGS_PREFIX + string + "." + string2, null);
        if (string3 != null) {
            return StringUtil.stringToBool(string3);
        }
        return Settings.getInstance().getBoolProperty(SETTINGS_PREFIX + string2, true);
    }

    public static boolean autoExpandFilteredNodes() {
        return Settings.getInstance().getBoolProperty("workbench.gui.dbtree..filter.autoexpand", true);
    }

    public static boolean autoLoadSchemasOnFind(String string) {
        boolean bl = Settings.getInstance().getBoolProperty("workbench.gui.dbtree..findobject.autoload", true);
        return Settings.getInstance().getBoolProperty("workbench.gui.dbtree.." + string + ".findobject.autoload", bl);
    }

    public static boolean useNaturalSort() {
        return Settings.getInstance().getBoolProperty("workbench.gui.dbtree..tablelist.naturalsort", true);
    }

    public static boolean useAutocommit(String string) {
        return Settings.getInstance().getBoolProperty("workbench.gui.dbtree.." + string + ".autocommit", true);
    }

    public static boolean applyTypeFilterForGlobalObjects() {
        return Settings.getInstance().getBoolProperty("workbench.gui.dbtree..typefilter.global.enabled", false);
    }
}

