/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects.objecttree.vertica;

import workbench.db.DbObject;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.vertica.VerticaProjectionReader;
import workbench.gui.dbobjects.objecttree.ObjectTreeNode;
import workbench.gui.dbobjects.objecttree.TreeLoader;
import workbench.gui.dbobjects.objecttree.vertica.ProjectionNode;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.storage.DataStore;

public class ProjectionListNode
extends ObjectTreeNode {
    public ProjectionListNode() {
        super(ResourceMgr.getString("TxtDbExplorerProjections"), "projection-list");
        this.setAllowsChildren(true);
    }

    @Override
    public boolean loadChildren(WbConnection wbConnection, TreeLoader treeLoader) {
        if (this.getParent() == null) {
            return false;
        }
        DbObject dbObject = this.getParent().getDbObject();
        if (dbObject instanceof TableIdentifier) {
            this.loadTableProjections(wbConnection, (TableIdentifier)dbObject);
        }
        return true;
    }

    private void loadTableProjections(WbConnection wbConnection, TableIdentifier tableIdentifier) {
        VerticaProjectionReader verticaProjectionReader = new VerticaProjectionReader();
        verticaProjectionReader.setConnection(wbConnection);
        try {
            DataStore dataStore = verticaProjectionReader.getProjectionList(tableIdentifier);
            for (int i = 0; i < dataStore.getRowCount(); ++i) {
                ProjectionNode projectionNode = new ProjectionNode(dataStore.getValueAsString(i, "basename"), tableIdentifier);
                this.add(projectionNode);
            }
            this.setChildrenLoaded(true);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not load projections", exception);
        }
    }
}

