/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dialogs.dataimport;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import workbench.db.importer.TextImportOptions;
import workbench.gui.dialogs.QuoteEscapeSelector;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.QuoteEscapeType;
import workbench.util.StringUtil;

public class TextOptionsPanel
extends JPanel
implements TextImportOptions {
    private JLabel decimalCharLabel;
    private JTextField decimalCharTextField;
    private JCheckBox decode;
    private JTextField delimiter;
    private JLabel delimiterLabel;
    private JComboBox escapeSelect;
    private JCheckBox headerIncluded;
    private JLabel jLabel1;
    private JCheckBox quoteAlways;
    private JTextField quoteChar;
    private JLabel quoteCharLabel;

    public TextOptionsPanel() {
        FontMetrics fontMetrics;
        this.initComponents();
        Font font = this.decimalCharTextField.getFont();
        if (font != null && (fontMetrics = this.decimalCharTextField.getFontMetrics(font)) != null) {
            int n = fontMetrics.charWidth('M');
            int n2 = fontMetrics.getHeight();
            Dimension dimension = new Dimension(n * 3, n2);
            this.decimalCharTextField.setMinimumSize(dimension);
            this.delimiter.setMinimumSize(dimension);
            this.quoteChar.setMinimumSize(dimension);
        }
    }

    public void saveSettings() {
        this.saveSettings("text");
    }

    public void saveSettings(String string) {
        Settings settings = Settings.getInstance();
        settings.setProperty("workbench.import." + string + ".containsheader", this.getContainsHeader());
        settings.setProperty("workbench.import." + string + ".decode", this.getDecode());
        settings.setDelimiter("workbench.import." + string + ".fielddelimiter", this.getTextDelimiter());
        settings.setProperty("workbench.import." + string + ".quotechar", this.getTextQuoteChar());
        settings.setProperty("workbench.import." + string + ".decimalchar", this.getDecimalChar());
        settings.setProperty("workbench.import." + string + ".quote.escape", this.getQuoteEscaping().toString());
        settings.setProperty("workbench.import." + string + ".quotealways", this.getQuoteAlways());
    }

    public void restoreSettings() {
        this.restoreSettings("text");
    }

    public void restoreSettings(String string) {
        Settings settings = Settings.getInstance();
        this.setContainsHeader(settings.getBoolProperty("workbench.import." + string + ".containsheader", true));
        this.setDecode(settings.getBoolProperty("workbench.import." + string + ".decode", false));
        this.setTextQuoteChar(settings.getProperty("workbench.import." + string + ".quotechar", settings.getQuoteChar()));
        this.quoteAlways.setSelected(settings.getBoolProperty("workbench.import." + string + ".quotealways", false));
        this.setTextDelimiter(settings.getDelimiter("workbench.import." + string + ".fielddelimiter", "\\t", true));
        this.setDecimalChar(settings.getProperty("workbench.import." + string + ".decimalchar", "."));
        String string2 = settings.getProperty("workbench.import." + string + ".quote.escape", "none");
        QuoteEscapeType quoteEscapeType = null;
        try {
            quoteEscapeType = QuoteEscapeType.valueOf(string2);
        }
        catch (Exception exception) {
            quoteEscapeType = QuoteEscapeType.none;
        }
        ((QuoteEscapeSelector)this.escapeSelect).setEscapeType(quoteEscapeType);
    }

    @Override
    public boolean getQuoteAlways() {
        return this.quoteAlways.isSelected();
    }

    @Override
    public QuoteEscapeType getQuoteEscaping() {
        return ((QuoteEscapeSelector)this.escapeSelect).getEscapeType();
    }

    @Override
    public boolean getDecode() {
        return this.decode.isSelected();
    }

    @Override
    public void setDecode(boolean bl) {
        this.decode.setSelected(bl);
    }

    @Override
    public boolean getContainsHeader() {
        return this.headerIncluded.isSelected();
    }

    @Override
    public String getTextDelimiter() {
        return this.delimiter.getText();
    }

    @Override
    public String getTextQuoteChar() {
        return this.quoteChar.getText();
    }

    public void disableHeaderSelection() {
        this.headerIncluded.setEnabled(false);
    }

    @Override
    public void setContainsHeader(boolean bl) {
        this.headerIncluded.setSelected(bl);
    }

    @Override
    public void setTextDelimiter(String string) {
        this.delimiter.setText(string);
    }

    @Override
    public void setTextQuoteChar(String string) {
        this.quoteChar.setText(string);
    }

    @Override
    public String getDecimalChar() {
        String string = this.decimalCharTextField.getText();
        if (StringUtil.isBlank(string)) {
            return ".";
        }
        return string.trim();
    }

    @Override
    public void setDecimalChar(String string) {
        this.decimalCharTextField.setText(string);
    }

    @Override
    public String getNullString() {
        return null;
    }

    @Override
    public void setNullString(String string) {
    }

    private void initComponents() {
        this.delimiterLabel = new JLabel();
        this.delimiter = new JTextField();
        this.headerIncluded = new JCheckBox();
        this.quoteCharLabel = new JLabel();
        this.quoteChar = new JTextField();
        this.decode = new JCheckBox();
        this.decimalCharLabel = new JLabel();
        this.decimalCharTextField = new JTextField();
        this.quoteAlways = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.escapeSelect = new QuoteEscapeSelector();
        this.setLayout(new GridBagLayout());
        this.delimiterLabel.setText(ResourceMgr.getString("LblFieldDelimiter"));
        this.delimiterLabel.setToolTipText(ResourceMgr.getString("d_LblFieldDelimiter"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 4, 0, 4);
        this.add((Component)this.delimiterLabel, gridBagConstraints);
        this.delimiter.setPreferredSize(new Dimension(32, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 4, 0, 4);
        this.add((Component)this.delimiter, gridBagConstraints);
        this.headerIncluded.setText(ResourceMgr.getString("LblImportIncludeHeaders"));
        this.headerIncluded.setToolTipText(ResourceMgr.getString("d_LblImportIncludeHeaders"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.headerIncluded, gridBagConstraints);
        this.quoteCharLabel.setText(ResourceMgr.getString("LblQuoteChar"));
        this.quoteCharLabel.setToolTipText(ResourceMgr.getString("d_LblQuoteChar"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 4, 0, 4);
        this.add((Component)this.quoteCharLabel, gridBagConstraints);
        this.quoteChar.setPreferredSize(new Dimension(32, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 4, 0, 4);
        this.add((Component)this.quoteChar, gridBagConstraints);
        this.decode.setText(ResourceMgr.getString("LblImportDecode"));
        this.decode.setToolTipText(ResourceMgr.getString("d_LblImportDecode"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.decode, gridBagConstraints);
        this.decimalCharLabel.setText(ResourceMgr.getString("LblImportDecimalChar"));
        this.decimalCharLabel.setToolTipText(ResourceMgr.getString("d_LblImportDecimalChar"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 4, 0, 4);
        this.add((Component)this.decimalCharLabel, gridBagConstraints);
        this.decimalCharTextField.setToolTipText(ResourceMgr.getDescription("LblImportDecimalChar"));
        this.decimalCharTextField.setMinimumSize(new Dimension(32, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.add((Component)this.decimalCharTextField, gridBagConstraints);
        this.quoteAlways.setText(ResourceMgr.getString("LblExportQuoteAlways"));
        this.quoteAlways.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(9, 4, 0, 0);
        this.add((Component)this.quoteAlways, gridBagConstraints);
        this.jLabel1.setText(ResourceMgr.getString("LblQuoteEsc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 4, 0, 4);
        this.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 4, 0, 4);
        this.add((Component)this.escapeSelect, gridBagConstraints);
    }
}

