/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dialogs.export;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import workbench.gui.dialogs.export.HtmlOptions;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;

public class HtmlOptionsPanel
extends JPanel
implements HtmlOptions {
    private JCheckBox escapeHtml;
    private JCheckBox fullPage;
    private JTextField pageTitle;
    private JLabel pageTitleLabel;

    public HtmlOptionsPanel() {
        this.initComponents();
    }

    public void saveSettings() {
        Settings settings = Settings.getInstance();
        settings.setProperty("workbench.export.html.createfullpage", this.getCreateFullPage());
        settings.setProperty("workbench.export.html.escape", this.getEscapeHtml());
        settings.setProperty("workbench.export.html.pagetitle", this.getPageTitle());
    }

    public void restoreSettings() {
        Settings settings = Settings.getInstance();
        this.setCreateFullPage(settings.getBoolProperty("workbench.export.html.createfullpage"));
        this.setEscapeHtml(settings.getBoolProperty("workbench.export.html.escape"));
        this.setPageTitle(settings.getProperty("workbench.export.html.pagetitle", ""));
    }

    @Override
    public boolean getCreateFullPage() {
        return this.fullPage.isSelected();
    }

    @Override
    public boolean getEscapeHtml() {
        return this.escapeHtml.isSelected();
    }

    @Override
    public String getPageTitle() {
        return this.pageTitle.getText();
    }

    @Override
    public void setCreateFullPage(boolean bl) {
        this.fullPage.setSelected(bl);
    }

    @Override
    public void setEscapeHtml(boolean bl) {
        this.escapeHtml.setSelected(bl);
    }

    @Override
    public void setPageTitle(String string) {
        this.pageTitle.setText(string);
    }

    private void initComponents() {
        this.pageTitleLabel = new JLabel();
        this.pageTitle = new JTextField();
        this.fullPage = new JCheckBox();
        this.escapeHtml = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.pageTitleLabel.setText(ResourceMgr.getString("LblExportHtmlPageTitle"));
        this.pageTitleLabel.setHorizontalTextPosition(10);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.pageTitleLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 0, 4);
        this.add((Component)this.pageTitle, gridBagConstraints);
        this.fullPage.setText(ResourceMgr.getString("LblExportFullHtml"));
        this.fullPage.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 3, 0, 0);
        this.add((Component)this.fullPage, gridBagConstraints);
        this.escapeHtml.setText(ResourceMgr.getString("LblExportEscapeHtml"));
        this.escapeHtml.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 3, 0, 0);
        this.add((Component)this.escapeHtml, gridBagConstraints);
    }
}

