/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.editor;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import workbench.gui.actions.WbAction;
import workbench.gui.editor.JEditTextArea;
import workbench.gui.editor.SyntaxDocument;
import workbench.gui.editor.TextIndenter;
import workbench.gui.editor.actions.DelPrevWord;
import workbench.gui.editor.actions.DeleteChar;
import workbench.gui.editor.actions.DeleteCurrentLine;
import workbench.gui.editor.actions.DeleteWord;
import workbench.gui.editor.actions.DocumentEnd;
import workbench.gui.editor.actions.DocumentHome;
import workbench.gui.editor.actions.DuplicateCurrentLine;
import workbench.gui.editor.actions.EditorAction;
import workbench.gui.editor.actions.LineEnd;
import workbench.gui.editor.actions.LineStart;
import workbench.gui.editor.actions.NextChar;
import workbench.gui.editor.actions.NextLine;
import workbench.gui.editor.actions.NextPage;
import workbench.gui.editor.actions.NextWord;
import workbench.gui.editor.actions.PrevWord;
import workbench.gui.editor.actions.PreviousChar;
import workbench.gui.editor.actions.PreviousLine;
import workbench.gui.editor.actions.PreviousPage;
import workbench.gui.editor.actions.SelectDocumentEnd;
import workbench.gui.editor.actions.SelectDocumentHome;
import workbench.gui.editor.actions.SelectLineEnd;
import workbench.gui.editor.actions.SelectLineStart;
import workbench.gui.editor.actions.SelectNextChar;
import workbench.gui.editor.actions.SelectNextLine;
import workbench.gui.editor.actions.SelectNextPage;
import workbench.gui.editor.actions.SelectNextWord;
import workbench.gui.editor.actions.SelectPrevWord;
import workbench.gui.editor.actions.SelectPreviousChar;
import workbench.gui.editor.actions.SelectPreviousLine;
import workbench.gui.editor.actions.SelectPreviousPage;
import workbench.gui.fontzoom.DecreaseFontSize;
import workbench.gui.fontzoom.IncreaseFontSize;
import workbench.gui.fontzoom.ResetFontSize;
import workbench.resource.GuiSettings;
import workbench.resource.Settings;
import workbench.resource.ShortcutManager;

public class InputHandler
extends KeyAdapter
implements ChangeListener,
PropertyChangeListener {
    public static final String SMART_HOME_END_PROPERTY = "InputHandler.homeEnd";
    private final ActionListener backspaceAction = new Backspace();
    private final ActionListener overWriteAction = new Overwrite();
    private final EditorAction delete = new DeleteChar();
    private final EditorAction deleteWord = new DeleteWord();
    private final EditorAction delPrevWord = new DelPrevWord();
    private final EditorAction documentEnd = new DocumentEnd();
    private final EditorAction selectDocEnd = new SelectDocumentEnd();
    private final EditorAction lineEnd = new LineEnd();
    private final EditorAction selectLineEnd = new SelectLineEnd();
    private final EditorAction lineStart = new LineStart();
    private final EditorAction selectLineStart = new SelectLineStart();
    private final EditorAction documentHome = new DocumentHome();
    private final EditorAction selectDocHome = new SelectDocumentHome();
    private final ActionListener insertBreak = new InsertBreak();
    private final ActionListener insertTab = new InsertTab();
    private final ActionListener shiftTab = new ShiftTab();
    private final EditorAction prevWord = new PrevWord();
    private final EditorAction selectPrevWord = new SelectPrevWord();
    private final EditorAction nextWord = new NextWord();
    private final EditorAction selectNextWord = new SelectNextWord();
    private final EditorAction nextChar = new NextChar();
    private final EditorAction selectNextChar = new SelectNextChar();
    private final EditorAction prevChar = new PreviousChar();
    private final EditorAction selectPrevChar = new SelectPreviousChar();
    private final EditorAction nextPage = new NextPage();
    private final EditorAction prevPage = new PreviousPage();
    private final EditorAction selectPrevPage = new SelectPreviousPage();
    private final EditorAction selectNextPage = new SelectNextPage();
    private final EditorAction nextLine = new NextLine();
    private final EditorAction selectNextLine = new SelectNextLine();
    private final EditorAction selectPrevLine = new SelectPreviousLine();
    private final EditorAction prevLine = new PreviousLine();
    private final WbAction increaseFont = new IncreaseFontSize();
    private final WbAction decreaseFont = new DecreaseFontSize();
    private final WbAction resetFont = new ResetFontSize();
    private final WbAction dupeLine = new DuplicateCurrentLine();
    private final ActionListener INSERT_CHAR = new InsertChar();
    private Map<KeyStroke, ActionListener> bindings;
    private boolean sequenceIsMapped = false;
    private boolean enabled = true;
    private KeyStroke expandKey;

    public InputHandler() {
        this.initKeyBindings();
        ShortcutManager.getInstance().addChangeListener(this);
        Settings.getInstance().addPropertyChangeListener(this, "workbench.editor.expand.macro.key", new String[0]);
    }

    public final void initKeyBindings() {
        this.bindings = new HashMap<KeyStroke, ActionListener>();
        this.addKeyBinding(KeyStroke.getKeyStroke(8, 0), this.backspaceAction);
        this.addKeyBinding(KeyStroke.getKeyStroke(127, 0), this.delete);
        this.addKeyBinding(this.delPrevWord);
        this.addKeyBinding(this.deleteWord);
        this.addKeyBinding(KeyStroke.getKeyStroke(10, 0), this.insertBreak);
        this.addKeyBinding(KeyStroke.getKeyStroke(9, 0), this.insertTab);
        this.addKeyBinding(KeyStroke.getKeyStroke(9, 1), this.shiftTab);
        this.addKeyBinding(KeyStroke.getKeyStroke(155, 0), this.overWriteAction);
        this.addKeyBinding(KeyStroke.getKeyStroke(27, 0), new CancelRectangleSelect());
        this.addKeyBinding(this.lineStart);
        this.addKeyBinding(this.selectLineStart);
        this.addKeyBinding(this.lineEnd);
        this.addKeyBinding(this.selectLineEnd);
        this.addKeyBinding(this.documentHome);
        this.addKeyBinding(this.selectDocHome);
        this.addKeyBinding(this.documentEnd);
        this.addKeyBinding(this.selectDocEnd);
        this.addKeyBinding(this.prevPage);
        this.addKeyBinding(this.selectPrevPage);
        this.addKeyBinding(this.nextPage);
        this.addKeyBinding(this.selectNextPage);
        this.addKeyBinding(this.prevChar);
        this.addKeyBinding(this.selectPrevChar);
        this.addKeyBinding(this.prevWord);
        this.addKeyBinding(this.selectPrevWord);
        this.addKeyBinding(this.nextChar);
        this.addKeyBinding(this.selectNextChar);
        this.addKeyBinding(this.nextWord);
        this.addKeyBinding(this.selectNextWord);
        this.addKeyBinding(this.prevLine);
        this.addKeyBinding(this.selectPrevLine);
        this.addKeyBinding(this.nextLine);
        this.addKeyBinding(this.selectNextLine);
        this.addKeyBinding(this.increaseFont);
        this.addKeyBinding(this.decreaseFont);
        this.addKeyBinding(this.resetFont);
        this.addKeyBinding(new DeleteCurrentLine());
        this.addKeyBinding(this.dupeLine);
        this.expandKey = GuiSettings.getExpansionKey();
    }

    public void addKeyBinding(WbAction wbAction) {
        KeyStroke keyStroke = wbAction.getAccelerator();
        if (keyStroke != null) {
            this.bindings.put(wbAction.getAccelerator(), wbAction);
        }
    }

    public void addKeyBinding(KeyStroke keyStroke, ActionListener actionListener) {
        this.bindings.put(keyStroke, actionListener);
    }

    public void removeKeyBinding(KeyStroke keyStroke) {
        this.bindings.remove(keyStroke);
    }

    public void removeKeyBinding(WbAction wbAction) {
        KeyStroke keyStroke = wbAction.getAccelerator();
        if (keyStroke != null) {
            this.bindings.remove(keyStroke);
        }
        if ((keyStroke = wbAction.getAlternateAccelerator()) != null) {
            this.bindings.remove(keyStroke);
        }
    }

    public void removeAllKeyBindings() {
        this.bindings.clear();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.expandKey = GuiSettings.getExpansionKey();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.initKeyBindings();
    }

    public void dispose() {
        ShortcutManager.getInstance().removeChangeListener(this);
        Settings.getInstance().removePropertyChangeListener(this);
        this.removeAllKeyBindings();
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        EventListener eventListener;
        if (!this.enabled) {
            return;
        }
        int n = keyEvent.getKeyCode();
        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
        if (!keyEvent.isActionKey() && !this.sequenceIsMapped) {
            this.sequenceIsMapped = this.isMapped(keyEvent);
        }
        if (n == 525) {
            keyEvent.consume();
            JEditTextArea jEditTextArea = InputHandler.getTextArea(keyEvent);
            EventQueue.invokeLater(jEditTextArea::showContextMenu);
            return;
        }
        if (this.expandKey != null && this.expandKey.equals(keyStroke) && ((JEditTextArea)(eventListener = InputHandler.getTextArea(keyEvent))).expandWordAtCursor()) {
            this.sequenceIsMapped = true;
            keyEvent.consume();
            return;
        }
        eventListener = this.bindings.get(keyStroke);
        if (eventListener == null && n == 8 && keyEvent.isShiftDown()) {
            eventListener = this.backspaceAction;
        }
        if (eventListener != null) {
            keyEvent.consume();
            this.executeAction((ActionListener)eventListener, keyEvent.getSource(), null);
        }
    }

    void resetStatus() {
        this.sequenceIsMapped = false;
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        KeyStroke keyStroke;
        if (!this.enabled) {
            return;
        }
        if (keyEvent.isConsumed()) {
            return;
        }
        boolean bl = this.sequenceIsMapped;
        this.sequenceIsMapped = false;
        if (bl) {
            return;
        }
        char c = keyEvent.getKeyChar();
        if (c == ' ' && keyEvent.getModifiers() == 2 && this.bindings.get(keyStroke = KeyStroke.getKeyStroke(32, 2)) != null) {
            keyEvent.consume();
            return;
        }
        if (c >= ' ' && c != '\u007f') {
            keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
            ActionListener actionListener = this.bindings.get(keyStroke);
            if (actionListener == null) {
                actionListener = this.INSERT_CHAR;
            }
            keyEvent.consume();
            this.executeAction(actionListener, keyEvent.getSource(), String.valueOf(c));
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.resetStatus();
    }

    public List<KeyStroke> getKeys(JMenu jMenu) {
        if (jMenu == null) {
            return Collections.emptyList();
        }
        ArrayList<KeyStroke> arrayList = new ArrayList<KeyStroke>();
        for (int i = 0; i < jMenu.getItemCount(); ++i) {
            JMenuItem jMenuItem = jMenu.getItem(i);
            arrayList.addAll(this.getKeys(jMenuItem));
            if (!(jMenuItem instanceof JMenu)) continue;
            arrayList.addAll(this.getKeys((JMenu)jMenuItem));
        }
        return arrayList;
    }

    public List<KeyStroke> getKeys(JComponent jComponent) {
        if (jComponent == null) {
            return Collections.emptyList();
        }
        int[] nArray = new int[]{0, 1, 2};
        ArrayList<KeyStroke> arrayList = new ArrayList<KeyStroke>();
        for (int n : nArray) {
            KeyStroke[] keyStrokeArray;
            InputMap inputMap = jComponent.getInputMap(n);
            KeyStroke[] keyStrokeArray2 = keyStrokeArray = inputMap != null ? inputMap.allKeys() : null;
            if (keyStrokeArray == null) continue;
            arrayList.addAll(Arrays.asList(keyStrokeArray));
        }
        return arrayList;
    }

    public boolean isMapped(KeyEvent keyEvent) {
        JMenuBar jMenuBar;
        if (keyEvent == null) {
            return false;
        }
        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
        if (keyStroke.getModifiers() == 0) {
            return false;
        }
        int n = keyStroke.getKeyCode();
        if (n == 18 || n == 17 || n == 157 || n == 525) {
            return false;
        }
        JEditTextArea jEditTextArea = InputHandler.getTextArea(keyEvent);
        ArrayList<KeyStroke> arrayList = new ArrayList<KeyStroke>();
        arrayList.addAll(this.getKeys(jEditTextArea));
        Window window = SwingUtilities.getWindowAncestor(jEditTextArea);
        if (window instanceof JFrame && (jMenuBar = ((JFrame)window).getJMenuBar()) != null && jMenuBar.getComponents() != null) {
            for (Component component : jMenuBar.getComponents()) {
                arrayList.addAll(this.getKeys((JComponent)component));
                if (!(component instanceof JMenu)) continue;
                JMenu jMenu = (JMenu)component;
                arrayList.addAll(this.getKeys(jMenu));
            }
        }
        return arrayList.contains(keyStroke);
    }

    public void executeAction(ActionListener actionListener, Object object, String string) {
        if (!this.enabled) {
            return;
        }
        ActionEvent actionEvent = new ActionEvent(object, 1001, string);
        actionListener.actionPerformed(actionEvent);
    }

    public static JEditTextArea getTextArea(EventObject eventObject) {
        Object object;
        if (eventObject != null && (object = eventObject.getSource()) instanceof Component) {
            Component component = (Component)object;
            while (true) {
                if (component instanceof JEditTextArea) {
                    return (JEditTextArea)component;
                }
                if (component == null) break;
                if (component instanceof JPopupMenu) {
                    component = ((JPopupMenu)component).getInvoker();
                    continue;
                }
                component = component.getParent();
            }
        }
        return null;
    }

    public static class InsertChar
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JEditTextArea jEditTextArea = InputHandler.getTextArea(actionEvent);
            String string = actionEvent.getActionCommand();
            if (jEditTextArea.isEditable()) {
                char c = string.charAt(0);
                if (jEditTextArea.shouldInsert(c)) {
                    jEditTextArea.overwriteSetSelectedText(string);
                    if (string.length() == 1) {
                        jEditTextArea.completeBracket(c);
                    }
                } else {
                    int n = jEditTextArea.getCaretPosition();
                    jEditTextArea.setCaretPosition(n + 1);
                }
            } else {
                jEditTextArea.getToolkit().beep();
            }
        }
    }

    public static class CancelRectangleSelect
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JEditTextArea jEditTextArea = InputHandler.getTextArea(actionEvent);
            if (jEditTextArea.isSelectionRectangular()) {
                jEditTextArea.setCaretPosition(jEditTextArea.getCaretPosition());
            }
        }
    }

    public static class Overwrite
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JEditTextArea jEditTextArea;
            jEditTextArea.setOverwriteEnabled(!(jEditTextArea = InputHandler.getTextArea(actionEvent)).isOverwriteEnabled());
        }
    }

    public static class InsertTab
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            JEditTextArea jEditTextArea = InputHandler.getTextArea(actionEvent);
            if (!jEditTextArea.isEditable()) {
                jEditTextArea.getToolkit().beep();
                return;
            }
            int n2 = jEditTextArea.getSelectionStart();
            if (n2 < (n = jEditTextArea.getSelectionEnd())) {
                TextIndenter textIndenter = new TextIndenter(jEditTextArea);
                textIndenter.indentSelection();
            } else {
                boolean bl = Settings.getInstance().getEditorUseTabCharacter();
                if (bl) {
                    jEditTextArea.overwriteSetSelectedText("\t");
                } else {
                    int n3 = Settings.getInstance().getEditorTabWidth();
                    int n4 = jEditTextArea.getLineStartOffset(jEditTextArea.getCaretLine());
                    int n5 = jEditTextArea.getCaretPosition() - n4;
                    int n6 = n3 - n5 % n3;
                    StringBuilder stringBuilder = new StringBuilder(n6);
                    for (int i = 0; i < n6; ++i) {
                        stringBuilder.append(' ');
                    }
                    jEditTextArea.overwriteSetSelectedText(stringBuilder.toString());
                }
            }
        }
    }

    public static class ShiftTab
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            JEditTextArea jEditTextArea = InputHandler.getTextArea(actionEvent);
            if (!jEditTextArea.isEditable()) {
                jEditTextArea.getToolkit().beep();
                return;
            }
            int n2 = jEditTextArea.getSelectionStart();
            if (n2 < (n = jEditTextArea.getSelectionEnd())) {
                TextIndenter textIndenter = new TextIndenter(jEditTextArea);
                textIndenter.unIndentSelection();
            }
        }
    }

    public static class InsertBreak
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JEditTextArea jEditTextArea = InputHandler.getTextArea(actionEvent);
            if (!jEditTextArea.isEditable()) {
                jEditTextArea.getToolkit().beep();
                return;
            }
            jEditTextArea.setSelectedText("\n");
        }
    }

    public static class Backspace
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JEditTextArea jEditTextArea = InputHandler.getTextArea(actionEvent);
            if (!jEditTextArea.isEditable()) {
                return;
            }
            if (jEditTextArea.getSelectionStart() != jEditTextArea.getSelectionEnd()) {
                if (jEditTextArea.isEmptyRectangleSelection()) {
                    jEditTextArea.doRectangleBackspace();
                } else {
                    jEditTextArea.setSelectedText("");
                }
            } else {
                int n = jEditTextArea.getCaretPosition();
                if (n == 0) {
                    return;
                }
                boolean bl = jEditTextArea.removeClosingBracket(n);
                int n2 = bl ? 2 : 1;
                SyntaxDocument syntaxDocument = jEditTextArea.getDocument();
                try {
                    syntaxDocument.remove(n - 1, n2);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        }
    }
}

