/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import workbench.WbManager;
import workbench.db.QuoteHandler;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.CopyAction;
import workbench.gui.actions.CutAction;
import workbench.gui.actions.PasteAction;
import workbench.gui.actions.ScrollDownAction;
import workbench.gui.actions.ScrollUpAction;
import workbench.gui.actions.SelectAllAction;
import workbench.gui.actions.WbAction;
import workbench.gui.editor.BracketCompleter;
import workbench.gui.editor.ClipboardCleaner;
import workbench.gui.editor.InputHandler;
import workbench.gui.editor.LineScroller;
import workbench.gui.editor.MacroExpander;
import workbench.gui.editor.SyntaxDocument;
import workbench.gui.editor.SyntaxUtilities;
import workbench.gui.editor.TextAreaPainter;
import workbench.gui.editor.TextUtilities;
import workbench.gui.editor.Token;
import workbench.gui.editor.TokenMarker;
import workbench.gui.fontzoom.FontZoomProvider;
import workbench.gui.fontzoom.FontZoomer;
import workbench.gui.macros.MacroClient;
import workbench.gui.menu.TextPopup;
import workbench.interfaces.ClipboardSupport;
import workbench.interfaces.EditorStatusbar;
import workbench.interfaces.TextChangeListener;
import workbench.interfaces.TextSelectionListener;
import workbench.interfaces.Undoable;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.GuiSettings;
import workbench.resource.Settings;
import workbench.util.MemoryWatcher;
import workbench.util.NumberStringCache;
import workbench.util.StringUtil;

public class JEditTextArea
extends JComponent
implements MouseWheelListener,
Undoable,
ClipboardSupport,
FocusListener,
LineScroller,
FontZoomProvider,
PropertyChangeListener {
    protected boolean rightClickMovesCursor = false;
    private Color alternateSelectionColor;
    private Color errorColor = Settings.getInstance().getEditorErrorColor();
    private Color tempColor = Settings.getInstance().getEditorCurrentStmtColor();
    private boolean currentSelectionIsTemporary;
    protected String commentChar;
    private TokenMarker currentTokenMarker;
    private KeyListener keyEventInterceptor;
    private KeyListener keyNotificationListener;
    protected EditorStatusbar statusBar;
    protected static final String CENTER = "center";
    protected static final String RIGHT = "right";
    protected static final String BOTTOM = "bottom";
    protected Timer caretTimer;
    protected final TextAreaPainter painter;
    protected TextPopup popup;
    protected EventListenerList listeners;
    private final MutableCaretEvent caretEvent;
    protected boolean caretBlinks;
    protected boolean caretVisible;
    protected boolean blink;
    protected boolean editable = true;
    protected boolean autoIndent = true;
    protected int firstLine;
    protected int visibleLines;
    protected int electricScroll;
    protected int horizontalOffset;
    private int minHighlightLength;
    private boolean highlightNoWhitespace;
    protected JScrollBar vertical;
    protected JScrollBar horizontal;
    protected InputHandler inputHandler;
    protected SyntaxDocument document;
    private final DocumentHandler documentHandler;
    protected Segment lineSegment;
    protected int selectionStart;
    protected int selectionStartLine;
    protected int selectionEnd;
    protected int selectionEndLine;
    protected boolean biasLeft;
    protected Color currentColor = null;
    protected int bracketPosition;
    protected int bracketLine;
    protected int magicCaret;
    protected boolean overwrite;
    protected boolean rectSelect;
    protected Boolean highlightSelection;
    private long lastModified;
    private int invalidationInterval = 10;
    private final FontZoomer fontZoomer;
    private BracketCompleter bracketCompleter;
    private MacroExpander expander;

    public JEditTextArea() {
        this.enableEvents(8L);
        this.painter = new TextAreaPainter(this);
        this.setBackground(Color.WHITE);
        this.setDoubleBuffered(true);
        this.documentHandler = new DocumentHandler();
        this.listeners = new EventListenerList();
        this.caretEvent = new MutableCaretEvent();
        this.lineSegment = new Segment();
        this.bracketLine = -1;
        this.bracketPosition = -1;
        this.lastModified = 0L;
        this.blink = true;
        this.setLayout(new BorderLayout());
        this.add((Component)this.painter, "Center");
        this.vertical = new JScrollBar(1);
        this.add((Component)this.vertical, "East");
        this.vertical.setVisible(false);
        this.horizontal = new JScrollBar(0);
        this.add((Component)this.horizontal, "South");
        this.horizontal.setVisible(false);
        this.vertical.addAdjustmentListener(new AdjustHandler());
        this.horizontal.addAdjustmentListener(new AdjustHandler());
        this.painter.addComponentListener(new ComponentHandler());
        this.painter.addMouseListener(new MouseHandler());
        this.painter.addMouseMotionListener(new DragHandler());
        this.addMouseWheelListener(this);
        this.addFocusListener(this);
        this.inputHandler = new InputHandler();
        this.setDocument(new SyntaxDocument());
        this.caretVisible = false;
        this.caretBlinks = true;
        this.electricScroll = Settings.getInstance().getElectricScroll();
        this.setTabSize(Settings.getInstance().getEditorTabWidth());
        this.popup = new TextPopup(this);
        boolean bl = Settings.getInstance().getBoolProperty("workbench.editor.extended.cutcopypaste", true);
        CopyAction copyAction = new CopyAction(this);
        PasteAction pasteAction = new PasteAction(this);
        CutAction cutAction = new CutAction(this);
        this.addKeyBinding(copyAction);
        this.addKeyBinding(pasteAction);
        this.addKeyBinding(cutAction);
        this.addKeyBinding(new SelectAllAction(this));
        if (bl) {
            this.inputHandler.addKeyBinding(KeyStroke.getKeyStroke(155, 2), copyAction);
            this.inputHandler.addKeyBinding(KeyStroke.getKeyStroke(155, 1), pasteAction);
            this.inputHandler.addKeyBinding(KeyStroke.getKeyStroke(127, 1), cutAction);
        }
        this.addKeyBinding(new ScrollDownAction(this));
        this.addKeyBinding(new ScrollUpAction(this));
        this.invalidationInterval = Settings.getInstance().getIntProperty("workbench.editor.update.lineinterval", 10);
        this.fontZoomer = new FontZoomer(this.painter);
        this.initWheelZoom();
        Settings.getInstance().addPropertyChangeListener(this, "workbench.editor.occurance.highlight.enable", "workbench.editor.occurance.highlight.minlength", "workbench.editor.occurance.highlight.nowhitespace", "workbench.editor.currentstmt.color", "workbench.editor.color.error", "workbench.gui.fontzoom.mousewheel");
        this.minHighlightLength = Settings.getInstance().getMinLengthForSelectionHighlight();
        this.highlightNoWhitespace = Settings.getInstance().getSelectionHighlightNoWhitespace();
    }

    private void initWheelZoom() {
        if (GuiSettings.getZoomFontWithMouseWheel()) {
            this.addMouseWheelListener(this.fontZoomer);
        } else {
            this.removeMouseWheelListener(this.fontZoomer);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().startsWith("workbench.editor.occurance.highlight")) {
            this.minHighlightLength = Settings.getInstance().getMinLengthForSelectionHighlight();
            this.highlightNoWhitespace = Settings.getInstance().getSelectionHighlightNoWhitespace();
            this.updateOccuranceHilite();
        } else if (propertyChangeEvent.getPropertyName().startsWith("workbench.gui.fontzoom.mousewheel")) {
            this.initWheelZoom();
        } else {
            this.errorColor = Settings.getInstance().getEditorErrorColor();
            this.tempColor = Settings.getInstance().getEditorCurrentStmtColor();
        }
    }

    @Override
    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
        this.painter.setCursor(cursor);
    }

    public int getHScrollBarHeight() {
        if (this.horizontal != null && this.horizontal.isVisible()) {
            return (int)this.horizontal.getPreferredSize().getHeight();
        }
        return 0;
    }

    @Override
    public FontZoomer getFontZoomer() {
        return this.fontZoomer;
    }

    public Point getCursorLocation() {
        int n = this.getCaretLine();
        int n2 = this.getCaretPosition() - this.getLineStartOffset(n);
        FontMetrics fontMetrics = this.painter.getFontMetrics();
        int n3 = (n - this.firstLine + 1) * fontMetrics.getHeight();
        if (n3 <= 0) {
            n3 = 0;
        }
        n3 += 4;
        float f = this.offsetToX(n, n2);
        if (f < 0.0f) {
            f = 0.0f;
        }
        return new Point(Math.round(f += (float)this.getPainter().getGutterWidth()), n3);
    }

    private String fixLinefeed(String string) {
        return StringUtil.makePlainLinefeed(string);
    }

    private void changeCase(boolean bl) {
        String string = this.getSelectedText();
        boolean bl2 = false;
        int n = this.getCaretPosition();
        if (string == null || string.length() == 0) {
            string = this.getText(n, 1);
            bl2 = true;
        }
        string = bl ? string.toLowerCase() : string.toUpperCase();
        if (bl2) {
            this.select(n, n + 1);
            this.setSelectedText(string);
        } else {
            int n2 = this.getSelectionStart();
            int n3 = this.getSelectionEnd();
            this.setSelectedText(string);
            this.select(n2, n3);
        }
    }

    public String getCommentChar() {
        return this.commentChar;
    }

    public void toLowerCase() {
        this.changeCase(true);
    }

    public void toUpperCase() {
        this.changeCase(false);
    }

    public void matchBracket() {
        try {
            int n = this.getBracketPosition() + 1;
            int n2 = this.getBracketLine();
            int n3 = this.getLineStartOffset(n2) + n;
            if (n3 > -1) {
                this.scrollTo(n2, n3);
                this.setCaretPosition(n3);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isRightClickMovesCursor() {
        return this.rightClickMovesCursor;
    }

    public void setRightClickMovesCursor(boolean bl) {
        this.rightClickMovesCursor = bl;
    }

    public JScrollBar getVerticalScrollBar() {
        return this.vertical;
    }

    public JScrollBar getHorizontalBar() {
        return this.horizontal;
    }

    public void notifiyKeyEvents(KeyListener keyListener) {
        this.keyNotificationListener = keyListener;
    }

    public void stopKeyNotification() {
        this.keyNotificationListener = null;
    }

    public final void addKeyBinding(WbAction wbAction) {
        this.inputHandler.addKeyBinding(wbAction);
    }

    public void removeKeyBinding(KeyStroke keyStroke) {
        this.inputHandler.removeKeyBinding(keyStroke);
    }

    public void removeKeyBinding(WbAction wbAction) {
        this.inputHandler.removeKeyBinding(wbAction);
    }

    @Override
    public final boolean isManagingFocus() {
        return true;
    }

    public final TextAreaPainter getPainter() {
        return this.painter;
    }

    public final boolean isCaretBlinkEnabled() {
        return this.caretBlinks;
    }

    protected void stopBlinkTimer() {
        if (this.caretTimer != null) {
            this.caretTimer.stop();
        }
        this.caretTimer = null;
    }

    private void startBlinkTimer() {
        if (this.caretTimer != null) {
            return;
        }
        this.caretTimer = new Timer(750, actionEvent -> this.blinkCaret());
        this.caretTimer.setInitialDelay(750);
        this.caretTimer.start();
    }

    public void setCaretBlinkEnabled(boolean bl) {
        this.caretBlinks = bl;
        if (!bl) {
            this.blink = false;
        }
        if (bl) {
            this.startBlinkTimer();
        } else {
            this.stopBlinkTimer();
        }
        this.painter.invalidateSelectedLines();
    }

    public void dispose() {
        if (this.bracketCompleter != null) {
            this.bracketCompleter.dispose();
        }
        if (this.expander != null) {
            this.expander.dispose();
        }
        Settings.getInstance().removePropertyChangeListener(this);
    }

    public MacroExpander getMacroExpander() {
        return this.expander;
    }

    public void setMacroExpansionEnabled(boolean bl, MacroClient macroClient) {
        if (bl && this.expander == null) {
            this.expander = new MacroExpander(this, macroClient);
        } else if (!bl) {
            if (this.expander != null) {
                this.expander.dispose();
            }
            this.expander = null;
        }
    }

    public boolean expandWordAtCursor() {
        if (this.expander == null) {
            return false;
        }
        return this.expander.expandWordAtCursor();
    }

    public boolean removeClosingBracket(int n) {
        if (this.bracketCompleter == null || this.currentTokenMarker == null) {
            return false;
        }
        String string = this.getText(n - 1, 1);
        if (string == null) {
            return false;
        }
        String string2 = this.bracketCompleter.getCompletionChar(string.charAt(0));
        if (string2 == null) {
            return false;
        }
        String string3 = this.getText(n, 1);
        return StringUtil.equalString(string2, string3);
    }

    public void completeBracket(char c) {
        char c2;
        if (this.bracketCompleter == null || this.currentTokenMarker == null) {
            return;
        }
        if (this.isSelectionRectangular()) {
            return;
        }
        String string = this.bracketCompleter.getCompletionChar(c);
        if (string == null) {
            return;
        }
        int n = this.getCaretLine();
        int n2 = this.getCaretPositionInLine(n);
        this.getLineText(this.getCaretLine(), this.lineSegment);
        if (n2 > 0 && n2 < this.lineSegment.length() && !Character.isWhitespace(c2 = this.lineSegment.charAt(n2))) {
            return;
        }
        if (!this.currentTokenMarker.isStringLiteralAt(n, n2)) {
            int n3 = this.getCaretPosition();
            this.insertText(n3, string);
            this.setCaretPosition(n3);
        }
    }

    public boolean shouldInsert(char c) {
        int n;
        if (this.isSelectionRectangular()) {
            return true;
        }
        if (this.bracketCompleter == null || this.currentTokenMarker == null) {
            return true;
        }
        char c2 = this.bracketCompleter.getOpeningChar(c);
        if (c2 == '\u0000') {
            return true;
        }
        int n2 = this.getCaretLine();
        this.getLineText(n2, this.lineSegment);
        int n3 = this.getCaretPositionInLine(this.getCaretLine());
        if (n3 <= 0 || n3 >= this.lineSegment.length()) {
            return true;
        }
        char c3 = this.lineSegment.charAt(n3);
        if (c3 != c) {
            return true;
        }
        String string = this.bracketCompleter.getCompletionChar(c);
        if (string != null && string.charAt(0) == c && (n = this.currentTokenMarker.isStringLiteralAt(n2, n3)) != 0) {
            return false;
        }
        n = 0;
        for (int i = 0; i < this.lineSegment.length(); ++i) {
            char c4 = this.lineSegment.charAt(i);
            if (c4 == c2) {
                ++n;
                continue;
            }
            if (c4 != c) continue;
            --n;
        }
        return n != 0;
    }

    public void setBracketCompletionEnabled(boolean bl) {
        if (this.bracketCompleter == null && bl) {
            this.bracketCompleter = new BracketCompleter();
        } else if (!bl) {
            if (this.bracketCompleter != null) {
                this.bracketCompleter.dispose();
            }
            this.bracketCompleter = null;
        }
    }

    public final boolean isCaretVisible() {
        return (!this.caretBlinks || this.blink) && this.caretVisible;
    }

    public boolean isTextSelected() {
        int n;
        int n2 = this.getSelectionStart();
        return n2 < (n = this.getSelectionEnd());
    }

    public void setCaretVisible(boolean bl) {
        this.caretVisible = bl;
        this.blink = true;
        this.painter.invalidateSelectedLines();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.inputHandler.resetStatus();
        this.setCaretVisible(true);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.inputHandler.resetStatus();
        this.setCaretVisible(false);
    }

    public final void blinkCaret() {
        if (!this.caretVisible) {
            return;
        }
        if (this.caretBlinks) {
            this.blink = !this.blink;
            this.painter.invalidateSelectedLines();
        } else {
            this.blink = true;
        }
    }

    public final int getElectricScroll() {
        return this.electricScroll;
    }

    public final void setElectricScroll(int n) {
        this.electricScroll = n;
    }

    public void updateScrollBars() {
        int n;
        if (!EventQueue.isDispatchThread()) {
            LogMgr.logDebug(new CallerInfo(){}, "updateScrollbars() not called from within the EDT!", new Exception());
            EventQueue.invokeLater(this::updateScrollBars);
            return;
        }
        if (this.visibleLines > 0) {
            n = this.getLineCount();
            this.vertical.setValues(this.firstLine, this.visibleLines, 0, n);
            this.vertical.setUnitIncrement(1);
            this.vertical.setBlockIncrement(this.visibleLines);
            if (this.visibleLines >= n) {
                this.setFirstLine(0, false);
                this.vertical.setVisible(false);
            } else {
                this.vertical.setVisible(true);
            }
        }
        if ((n = this.painter.getWidth()) > 0) {
            int n2 = this.painter.getFontMetrics().charWidth('M');
            int n3 = this.getDocument().getMaxLineLength();
            int n4 = n2 * n3 + this.painter.getGutterWidth() + n2;
            this.horizontal.setValues(-this.horizontalOffset, n, 0, n4);
            this.horizontal.setUnitIncrement(n2);
            this.horizontal.setBlockIncrement(n / 3);
            if (n >= n4) {
                this.horizontal.setVisible(false);
            } else {
                this.horizontal.setVisible(true);
            }
        }
    }

    public void centerLine(int n) {
        int n2;
        int n3;
        if (this.visibleLines <= 0) {
            this.recalculateVisibleLines();
        }
        if ((n3 = n - this.visibleLines / 2) + this.visibleLines > (n2 = this.getLineCount())) {
            n3 = n2 - this.visibleLines;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        this.firstLine = n3;
        this.updateScrollBars();
        this.validate();
        this.painter.repaint();
    }

    public final int getFirstLine() {
        return this.firstLine < 0 ? 0 : this.firstLine;
    }

    public void setFirstLine(int n) {
        this.setFirstLine(n, true);
    }

    protected void setFirstLine(int n, boolean bl) {
        if (n == this.firstLine) {
            return;
        }
        this.firstLine = n;
        if (bl && this.firstLine != this.vertical.getValue()) {
            this.updateScrollBars();
        }
        this.painter.repaint();
    }

    public final int getVisibleLines() {
        return this.visibleLines;
    }

    final void recalculateVisibleLines() {
        FontMetrics fontMetrics;
        if (this.painter == null) {
            return;
        }
        int n = this.painter.getHeight();
        if (n <= 0) {
            n = this.getHeight();
        }
        if ((fontMetrics = this.painter.getFontMetrics()) == null) {
            return;
        }
        int n2 = fontMetrics.getHeight();
        this.visibleLines = n / n2;
    }

    public final int getHorizontalOffset() {
        return this.horizontalOffset;
    }

    public void setHorizontalOffset(int n) {
        this.setHorizontalOffset(n, true);
    }

    protected void setHorizontalOffset(int n, boolean bl) {
        if (n == this.horizontalOffset) {
            return;
        }
        this.horizontalOffset = n;
        if (bl && n != this.horizontal.getValue()) {
            this.updateScrollBars();
        }
        this.painter.repaint();
    }

    @Override
    public boolean canScrollDown() {
        int n = this.getFirstLine();
        int n2 = n + this.getVisibleLines();
        return n2 < this.getLineCount();
    }

    @Override
    public void scrollDown() {
        if (this.canScrollDown()) {
            this.setOrigin(this.getFirstLine() + 1, this.getHorizontalOffset());
        }
    }

    @Override
    public boolean canScrollUp() {
        return this.getFirstLine() > 0;
    }

    @Override
    public void scrollUp() {
        if (this.canScrollUp()) {
            this.setOrigin(this.getFirstLine() - 1, this.getHorizontalOffset());
        }
    }

    public boolean setOrigin(int n, int n2) {
        boolean bl = false;
        if (n2 != this.horizontalOffset) {
            this.horizontalOffset = n2;
            bl = true;
        }
        if (n != this.firstLine) {
            this.firstLine = n;
            bl = true;
        }
        if (bl) {
            this.updateScrollBars();
            this.painter.repaint();
        }
        return bl;
    }

    public boolean scrollToCaret() {
        int n = this.getCaretLine();
        int n2 = this.getLineStartOffset(n);
        int n3 = Math.max(0, Math.min(this.getLineLength(n) - 1, this.getCaretPosition() - n2));
        return this.scrollTo(n, n3);
    }

    public boolean isLineVisible(int n) {
        if (this.visibleLines == 0) {
            return false;
        }
        return this.firstLine + this.electricScroll <= n && n <= this.firstLine + this.visibleLines - this.electricScroll;
    }

    public boolean scrollTo(int n, int n2) {
        if (this.visibleLines == 0) {
            return false;
        }
        if (this.painter == null) {
            return false;
        }
        int n3 = this.firstLine;
        int n4 = this.horizontalOffset;
        int n5 = this.getLineCount();
        if (n < this.firstLine + this.electricScroll) {
            n3 = Math.max(0, n - this.electricScroll);
        } else if (n + this.electricScroll >= this.firstLine + this.visibleLines) {
            n3 = n - this.visibleLines + this.electricScroll + 1;
            if (n3 + this.visibleLines >= n5) {
                n3 = n5 - this.visibleLines;
            }
            if (n3 < 0) {
                n3 = 0;
            }
        }
        int n6 = this.offsetToX(n, n2);
        int n7 = this.painter.getFontMetrics().charWidth('w');
        int n8 = this.painter.getWidth();
        if (n6 < 0) {
            n4 = Math.min(0, this.horizontalOffset - n6 + n7 + 5);
        } else if (n6 + n7 >= n8) {
            n4 = this.horizontalOffset + (n8 - n6) - n7 - 5;
            n4 -= this.painter.getGutterWidth();
        }
        return this.setOrigin(n3, n4);
    }

    public int lineToY(int n) {
        FontMetrics fontMetrics = this.painter.getFontMetrics();
        return (n - this.firstLine) * fontMetrics.getHeight() - fontMetrics.getDescent();
    }

    public int yToLine(int n) {
        FontMetrics fontMetrics = this.painter.getFontMetrics();
        int n2 = fontMetrics.getHeight();
        return Math.max(0, Math.min(this.getLineCount() - 1, n / n2 + this.firstLine));
    }

    public final int offsetToX(int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)this.painter.getGraphics();
        if (graphics2D == null) {
            graphics2D = (Graphics2D)this.getGraphics();
        }
        if (graphics2D == null) {
            return 0;
        }
        return this.offsetToX(graphics2D, n, n2);
    }

    public final int offsetToX(Graphics2D graphics2D, int n, int n2) {
        TokenMarker tokenMarker = this.getTokenMarker();
        Token token = null;
        if (tokenMarker != null) {
            this.getLineText(n, this.lineSegment);
            token = tokenMarker.markTokens(this.lineSegment, n);
        }
        return this.offsetToX(graphics2D, n, n2, token);
    }

    public final int offsetToX(Graphics2D graphics2D, int n, int n2, Token token) {
        this.getLineText(n, this.lineSegment);
        int n3 = this.lineSegment.offset;
        float f = this.horizontalOffset;
        if (token == null) {
            this.lineSegment.count = n2;
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            return Math.round(f + SyntaxUtilities.getTabbedTextWidth(this.lineSegment, graphics2D, fontMetrics, f, this.painter, 0));
        }
        while (token != null) {
            float f2;
            FontMetrics fontMetrics = this.painter.getStyleFontMetrics(token.id);
            int n4 = token.length;
            if (n2 + n3 < this.lineSegment.offset + n4) {
                this.lineSegment.count = n2 - (this.lineSegment.offset - n3);
                f2 = SyntaxUtilities.getTabbedTextWidth(this.lineSegment, graphics2D, fontMetrics, f, this.painter, 0);
                f += (float)Math.round(f2);
                break;
            }
            this.lineSegment.count = n4;
            f2 = SyntaxUtilities.getTabbedTextWidth(this.lineSegment, graphics2D, fontMetrics, f, this.painter, 0);
            f += (float)Math.round(f2);
            this.lineSegment.offset += n4;
            token = token.next;
        }
        return Math.round(f);
    }

    public int xToOffset(int n, int n2) {
        TokenMarker tokenMarker = this.getTokenMarker();
        this.getLineText(n, this.lineSegment);
        char[] cArray = this.lineSegment.array;
        int n3 = this.lineSegment.offset;
        int n4 = this.lineSegment.count;
        float f = this.horizontalOffset;
        Graphics graphics = this.painter.getGraphics();
        if (tokenMarker == null) {
            FontMetrics fontMetrics = this.painter.getFontMetrics();
            for (int i = 0; i < n4; ++i) {
                int n5 = i + n3;
                char c = cArray[n5];
                double d = c == '\t' ? (double)(this.painter.nextTabStop(f, i) - f) : fontMetrics.getStringBounds(cArray, n5, n5 + 1, graphics).getBounds2D().getWidth();
                if ((double)f + d / 2.0 > (double)n2) {
                    return i;
                }
                f = (float)((double)f + d);
            }
            return n4;
        }
        Token token = tokenMarker.markTokens(this.lineSegment, n);
        int n6 = 0;
        while (token != null) {
            FontMetrics fontMetrics = this.painter.getStyleFontMetrics(token.id);
            int n7 = token.length;
            for (int i = 0; i < n7; ++i) {
                int n8 = n3 + n6 + i;
                char c = cArray[n8];
                double d = c == '\t' ? (double)(this.painter.nextTabStop(f, n6 + i) - f) : fontMetrics.getStringBounds(cArray, n8, n8 + 1, graphics).getBounds2D().getWidth();
                if ((double)f + d / 2.0 > (double)n2) {
                    return n6 + i;
                }
                f = (float)((double)f + d);
            }
            n6 += n7;
            token = token.next;
        }
        return n6;
    }

    public int xyToOffset(int n, int n2) {
        int n3 = this.yToLine(n2);
        int n4 = this.getLineStartOffset(n3);
        return n4 + this.xToOffset(n3, n);
    }

    public final SyntaxDocument getDocument() {
        return this.document;
    }

    protected void clearCurrentDocument() {
        if (this.document != null) {
            this.document.removeDocumentListener(this.documentHandler);
            this.document.reset();
        }
    }

    public final void setDocument(SyntaxDocument syntaxDocument) {
        if (this.document == syntaxDocument) {
            return;
        }
        this.clearCurrentDocument();
        this.document = syntaxDocument;
        this.document.tokenizeLines();
        this.setCaretPosition(0);
        if (this.document != null) {
            this.painter.calculateTabSize();
            if (this.currentTokenMarker != null) {
                this.document.setTokenMarker(this.currentTokenMarker);
            }
            this.document.addDocumentListener(this.documentHandler);
            EventQueue.invokeLater(() -> {
                this.updateScrollBars();
                this.validate();
                this.painter.repaint();
            });
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.painter.setFont(font);
    }

    public final TokenMarker getTokenMarker() {
        return this.document.getTokenMarker();
    }

    public final void setTokenMarker(TokenMarker tokenMarker) {
        this.currentTokenMarker = tokenMarker;
        this.document.setTokenMarker(tokenMarker);
    }

    public final int getDocumentLength() {
        if (this.document == null) {
            return 0;
        }
        return this.document.getLength();
    }

    public final int getLineCount() {
        if (this.document == null) {
            return 0;
        }
        if (this.document.getDefaultRootElement() == null) {
            return 0;
        }
        return this.document.getDefaultRootElement().getElementCount();
    }

    public final int getLineOfOffset(int n) {
        return this.document.getDefaultRootElement().getElementIndex(n);
    }

    public final int getColumnOfOffset(int n) {
        int n2 = this.getLineOfOffset(n);
        int n3 = this.getLineStartOffset(n2);
        return n - n3;
    }

    public int getCaretPositionInLine(int n) {
        int n2 = this.getCaretPosition();
        int n3 = this.getLineStartOffset(n);
        return n2 - n3;
    }

    public int getLineStartOffset(int n) {
        Element element = this.document.getDefaultRootElement().getElement(n);
        if (element == null) {
            return -1;
        }
        return element.getStartOffset();
    }

    public int getLineEndOffset(int n) {
        Element element = this.document.getDefaultRootElement().getElement(n);
        if (element == null) {
            return -1;
        }
        return element.getEndOffset();
    }

    public int getLineLength(int n) {
        Element element = this.document.getDefaultRootElement().getElement(n);
        if (element == null) {
            return -1;
        }
        return element.getEndOffset() - element.getStartOffset() - 1;
    }

    public String getText() {
        int n = this.document.getLength();
        if (n < 0) {
            return null;
        }
        try {
            return this.document.getText(0, this.document.getLength());
        }
        catch (BadLocationException badLocationException) {
            LogMgr.logError(new CallerInfo(){}, "Error setting text", badLocationException);
            return null;
        }
    }

    public final void setTabSize(int n) {
        this.document.putProperty("tabSize", n);
    }

    public int getTabSize() {
        Integer n = (Integer)this.document.getProperty("tabSize");
        if (n != null) {
            return n;
        }
        return 4;
    }

    public void appendLine(String string) {
        if (MemoryWatcher.isMemoryLow(true)) {
            WbManager.getInstance().showLowMemoryError();
            return;
        }
        try {
            this.document.beginCompoundEdit();
            this.document.insertString(this.document.getLength(), this.fixLinefeed(string), null);
        }
        catch (BadLocationException badLocationException) {
            LogMgr.logError(new CallerInfo(){}, "Error setting text", badLocationException);
        }
        finally {
            this.document.endCompoundEdit();
        }
    }

    public void reset() {
        this.setDocument(new SyntaxDocument());
        this.resetModified();
    }

    public void setText(String string) {
        try {
            this.setCaretPosition(0);
            this.document.beginCompoundEdit();
            if (this.document.getLength() > 0) {
                this.document.remove(0, this.document.getLength());
            }
            if (string != null && string.length() > 0) {
                String string2 = this.fixLinefeed(string);
                this.document.insertString(0, string2, null);
            }
        }
        catch (BadLocationException badLocationException) {
            LogMgr.logError(new CallerInfo(){}, "Error setting text", badLocationException);
        }
        finally {
            this.document.endCompoundEdit();
            this.document.tokenizeLines();
        }
        if (this.isVisible()) {
            EventQueue.invokeLater(() -> {
                this.updateScrollBars();
                this.validate();
            });
        }
    }

    public boolean isReallyVisible() {
        Container container;
        boolean bl = this.isVisible();
        boolean bl2 = bl = bl && container != null;
        for (container = this.getParent(); container != null; container = container.getParent()) {
            bl = bl && container.isVisible();
        }
        return bl;
    }

    public final String getText(int n, int n2) {
        try {
            return this.document.getText(n, n2);
        }
        catch (BadLocationException badLocationException) {
            LogMgr.logError(new CallerInfo(){}, "Error setting text", badLocationException);
            return null;
        }
    }

    public final void getText(int n, int n2, Segment segment) {
        if (n2 < 0) {
            return;
        }
        try {
            this.document.getText(n, n2, segment);
        }
        catch (BadLocationException badLocationException) {
            LogMgr.logError(new CallerInfo(){}, "Error setting text", badLocationException);
            segment.offset = 0;
            segment.count = 0;
        }
    }

    public String getWordAtCursor() {
        return this.getWordAtCursor(Settings.getInstance().getEditorNoWordSep());
    }

    public String getWordAtCursor(String string) {
        int n;
        int n2;
        int n3 = this.getCaretLine();
        String string2 = this.getLineText(n3);
        int n4 = TextUtilities.findWordStart(string2, n2 = this.getCaretPositionInLine(n3), string);
        if (n4 < (n = TextUtilities.findWordEnd(string2, n2, string)) && n4 >= 0) {
            return string2.substring(n4, n);
        }
        return null;
    }

    public String getWordLeftOfCursor(String string) {
        int n = this.getCaretLine();
        String string2 = this.getLineText(n);
        int n2 = this.getCaretPositionInLine(n);
        return StringUtil.getWordLeftOfCursor(string2, n2, string);
    }

    public void selectWordAtCursor(String string) {
        int n;
        int n2 = this.getCaretLine();
        String string2 = this.getLineText(n2);
        int n3 = this.getCaretPosition();
        int n4 = n3 - (n = this.getLineStartOffset(n2));
        if (n4 <= 0) {
            return;
        }
        if (Character.isWhitespace(string2.charAt(n4 - 1))) {
            return;
        }
        int n5 = StringUtil.findWordBoundary(string2, n4 - 1, string);
        if (n5 == 0) {
            this.select(n + n5, n3);
        } else if (n5 > 0) {
            this.select(n + n5 + 1, n3);
        }
    }

    public final String getLineText(int n) {
        Element element = this.document.getDefaultRootElement().getElement(n);
        int n2 = element != null ? element.getStartOffset() : -1;
        int n3 = element != null ? element.getEndOffset() : -1;
        return this.getText(n2, n3 - n2 - 1);
    }

    public final void getLineText(int n, Segment segment) {
        Element element = this.document.getDefaultRootElement().getElement(n);
        int n2 = element != null ? element.getStartOffset() : -1;
        int n3 = element != null ? element.getEndOffset() : -1;
        this.getText(n2, n3 - n2 - 1, segment);
    }

    public final int getSelectionStart() {
        return this.selectionStart;
    }

    public int getSelectionStart(int n) {
        if (n == this.selectionStartLine) {
            return this.selectionStart;
        }
        if (this.rectSelect) {
            Element element = this.document.getDefaultRootElement();
            int n2 = this.selectionStart - element.getElement(this.selectionStartLine).getStartOffset();
            Element element2 = element.getElement(n);
            int n3 = element2.getStartOffset();
            int n4 = element2.getEndOffset() - 1;
            return Math.min(n4, n3 + n2);
        }
        return this.getLineStartOffset(n);
    }

    public final int getSelectionStartLine() {
        return this.selectionStartLine;
    }

    public final void setSelectionStart(int n) {
        this.select(n, this.selectionEnd);
    }

    public final int getSelectionEnd() {
        return this.selectionEnd;
    }

    public int getSelectionEnd(int n) {
        if (n == this.selectionEndLine) {
            return this.selectionEnd;
        }
        if (this.rectSelect) {
            Element element = this.document.getDefaultRootElement();
            int n2 = this.selectionEnd - element.getElement(this.selectionEndLine).getStartOffset();
            Element element2 = element.getElement(n);
            int n3 = element2.getStartOffset();
            int n4 = element2.getEndOffset() - 1;
            return Math.min(n4, n3 + n2);
        }
        return this.getLineEndOffset(n) - 1;
    }

    public final int getSelectionEndLine() {
        return this.selectionEndLine;
    }

    public final void setSelectionEnd(int n) {
        this.select(this.selectionStart, n);
    }

    public final int getCaretPosition() {
        return this.biasLeft ? this.selectionStart : this.selectionEnd;
    }

    public final int getCaretLine() {
        return this.biasLeft ? this.selectionStartLine : this.selectionEndLine;
    }

    public final int getMarkPosition() {
        return this.biasLeft ? this.selectionEnd : this.selectionStart;
    }

    public final int getMarkLine() {
        return this.biasLeft ? this.selectionEndLine : this.selectionStartLine;
    }

    public final void setCaretPosition(int n) {
        this.select(n, n);
    }

    @Override
    public final void selectAll() {
        this.select(0, this.getDocumentLength());
    }

    public final void selectNone() {
        this.select(this.getCaretPosition(), this.getCaretPosition());
    }

    public void clearUndoBuffer() {
        this.document.clearUndoBuffer();
    }

    @Override
    public void undo() {
        this.document.undo();
        int n = this.document.getPositionOfLastChange();
        if (n > -1) {
            this.setCaretPosition(n);
            this.scrollToCaret();
        }
    }

    @Override
    public void redo() {
        this.document.redo();
        int n = this.document.getPositionOfLastChange();
        if (n > -1) {
            this.setCaretPosition(n);
            this.scrollToCaret();
        }
    }

    public boolean currentSelectionIsTemporary() {
        return this.currentSelectionIsTemporary;
    }

    public void selectError(int n, int n2) {
        this.selectCommand(n, n2, this.errorColor);
    }

    public void selectStatementTemporary(int n, int n2) {
        this.selectCommand(n, n2, this.tempColor);
    }

    private void selectCommand(int n, int n2, Color color) {
        if (n >= n2) {
            return;
        }
        int n3 = n2 - n;
        String string = this.getText(n, n3);
        if (string == null || string.length() == 0) {
            return;
        }
        n3 = string.length();
        int n4 = 0;
        char c = string.charAt(n4);
        while (Character.isWhitespace(c) && n4 < n3) {
            c = string.charAt(++n4);
        }
        int n5 = n + n4;
        int n6 = n3 - 1;
        n4 = 0;
        c = string.charAt(n6 - n4);
        while (Character.isWhitespace(c) && n4 < n6) {
            c = string.charAt(n6 - ++n4);
        }
        int n7 = n2 - n4;
        this.select(n5, n7, color);
    }

    public void select(int n, int n2) {
        this.select(n, n2, null);
    }

    private void select(int n, int n2, Color color) {
        boolean bl;
        int n3;
        int n4;
        if (this.document == null) {
            return;
        }
        if (this.painter == null) {
            return;
        }
        if (n <= n2) {
            n4 = n;
            n3 = n2;
            bl = false;
        } else {
            n4 = n2;
            n3 = n;
            bl = true;
        }
        if (n4 < 0 || n3 > this.getDocumentLength()) {
            throw new IllegalArgumentException("Bounds out of range: " + n4 + "," + n3);
        }
        if (n4 != this.selectionStart || n3 != this.selectionEnd || bl != this.biasLeft) {
            this.alternateSelectionColor = color;
            this.currentSelectionIsTemporary = color != null;
            int n5 = this.getLineOfOffset(n4);
            int n6 = this.getLineOfOffset(n3);
            if (this.painter.isBracketHighlightEnabled()) {
                if (this.bracketLine != -1) {
                    this.painter.invalidateLine(this.bracketLine);
                }
                this.updateBracketHighlight(n2);
                if (this.bracketLine != -1) {
                    this.painter.invalidateLine(this.bracketLine);
                }
            }
            this.painter.invalidateLineRange(this.selectionStartLine, this.selectionEndLine);
            this.painter.invalidateLineRange(n5, n6);
            this.selectionStart = n4;
            this.selectionEnd = n3;
            this.selectionStartLine = n5;
            this.selectionEndLine = n6;
            this.biasLeft = bl;
            this.fireCaretEvent();
        }
        this.updateOccuranceHilite();
        this.blink = true;
        if (this.caretTimer != null) {
            this.caretTimer.restart();
        }
        if (this.selectionStart == this.selectionEnd) {
            this.rectSelect = false;
        }
        this.magicCaret = -1;
        this.scrollToCaret();
        this.fireSelectionEvent();
    }

    public boolean isGlobalSelectionHighlight() {
        return this.highlightSelection == null;
    }

    public void setHighlightSelection(boolean bl) {
        this.highlightSelection = bl;
        this.updateOccuranceHilite();
    }

    public boolean isSelectionHighlightEnabled() {
        if (this.highlightSelection == null) {
            return Settings.getInstance().getHighlightCurrentSelection();
        }
        return this.highlightSelection;
    }

    private void updateOccuranceHilite() {
        String string = null;
        boolean bl = this.isSelectionHighlightEnabled();
        if (bl && this.selectionStartLine == this.selectionEndLine && this.selectionEnd - this.selectionStart >= this.minHighlightLength) {
            int n;
            string = this.getSelectedText();
            if (this.highlightNoWhitespace && !this.getQuoteHandler().isQuoted(string) && (n = StringUtil.findFirstWhiteSpace(string, '\u0000')) > -1) {
                string = null;
            }
        }
        this.painter.setHighlightValue(string);
    }

    protected QuoteHandler getQuoteHandler() {
        return QuoteHandler.STANDARD_HANDLER;
    }

    public Color getAlternateSelectionColor() {
        return this.alternateSelectionColor;
    }

    public int getSelectionLength() {
        return this.selectionEnd - this.selectionStart;
    }

    public final String getSelectedText() {
        if (this.selectionStart == this.selectionEnd) {
            return null;
        }
        if (this.rectSelect) {
            Element element = this.document.getDefaultRootElement();
            int n = this.selectionStart - element.getElement(this.selectionStartLine).getStartOffset();
            int n2 = this.selectionEnd - element.getElement(this.selectionEndLine).getStartOffset();
            if (n2 < n) {
                int n3 = n2;
                n2 = n;
                n = n3;
            }
            StringBuilder stringBuilder = new StringBuilder();
            Segment segment = new Segment();
            for (int i = this.selectionStartLine; i <= this.selectionEndLine; ++i) {
                Element element2 = element.getElement(i);
                int n4 = element2.getStartOffset();
                int n5 = element2.getEndOffset() - 1;
                n4 = Math.min(n4 + n, n5);
                int n6 = Math.min(n2 - n, n5 - n4);
                this.getText(n4, n6, segment);
                stringBuilder.append(segment.array, segment.offset, segment.count);
                if (i == this.selectionEndLine) continue;
                stringBuilder.append('\n');
            }
            return stringBuilder.toString();
        }
        return this.getText(this.selectionStart, this.selectionEnd - this.selectionStart);
    }

    public boolean isEmptyRectangleSelection() {
        int n;
        if (!this.rectSelect) {
            return false;
        }
        Element element = this.document.getDefaultRootElement();
        int n2 = this.selectionStart - element.getElement(this.selectionStartLine).getStartOffset();
        int n3 = this.selectionEnd - element.getElement(this.selectionEndLine).getStartOffset();
        if (n3 < n2) {
            int n4 = n3;
            n3 = n2;
            n2 = n4;
        }
        Element element2 = element.getElement(this.selectionStartLine);
        int n5 = element2.getStartOffset();
        int n6 = element2.getEndOffset() - 1;
        int n7 = Math.min(n6, n5 + n2);
        return n7 == (n = this.getCaretPositionInLine(this.getCaretLine()));
    }

    public void doRectangleDeleteChar() {
        ++this.selectionStart;
        this.setSelectedText("");
    }

    public void doRectangleBackspace() {
        --this.selectionStart;
        this.setSelectedText("");
    }

    public void replaceText(int n, int n2, int n3, String string) {
        if (!this.editable) {
            return;
        }
        try {
            this.document.beginCompoundEdit();
            int n4 = this.getLineStartOffset(n);
            this.document.remove(n4 + n2, n3 - n2);
            this.document.insertString(n4 + n2, string, null);
            int n5 = n4 + n2 + string.length();
            int n6 = this.getLineOfOffset(n5);
            this.painter.invalidateLineRange(n, n6);
            this.setCaretPosition(n5);
            this.updateScrollBars();
        }
        catch (BadLocationException badLocationException) {
            LogMgr.logError(new CallerInfo(){}, "Error setting text", badLocationException);
            throw new InternalError("Cannot replace selection");
        }
        finally {
            this.document.endCompoundEdit();
        }
    }

    public void replaceText(int n, int n2, String string) {
        try {
            this.document.beginCompoundEdit();
            this.document.remove(n, n2 - n);
            this.document.insertString(n, this.fixLinefeed(string), null);
        }
        catch (BadLocationException badLocationException) {
            LogMgr.logError(new CallerInfo(){}, "Error setting text", badLocationException);
            throw new InternalError("Cannot replace selection");
        }
        finally {
            this.document.endCompoundEdit();
        }
        this.updateScrollBars();
        this.setCaretPosition(n);
        int n3 = this.getLineOfOffset(this.selectionStart);
        int n4 = this.getLineOfOffset(this.selectionStart + string.length());
        this.painter.invalidateLineRange(n3, n4);
    }

    public void setSelectedText(String string) {
        if (!this.editable) {
            return;
        }
        try {
            string = this.fixLinefeed(string);
            this.document.beginCompoundEdit();
            if (this.rectSelect) {
                int n;
                Element element = this.document.getDefaultRootElement();
                int n2 = this.selectionStart - element.getElement(this.selectionStartLine).getStartOffset();
                int n3 = this.selectionEnd - element.getElement(this.selectionEndLine).getStartOffset();
                if (n3 < n2) {
                    n = n3;
                    n3 = n2;
                    n2 = n;
                }
                n = this.selectionStartLine;
                int n4 = this.selectionEndLine;
                String[] stringArray = string.split("\n");
                int n5 = 0;
                for (int i = n; i <= n4; ++i) {
                    Element element2 = element.getElement(i);
                    int n6 = element2.getStartOffset();
                    int n7 = element2.getEndOffset() - 1;
                    int n8 = Math.min(n7, n6 + n2);
                    this.document.remove(n8, Math.min(n7 - n8, n3 - n2));
                    if (StringUtil.isNonEmpty(string)) {
                        if (stringArray.length == 1) {
                            this.document.insertString(n8, string, null);
                        } else if (n5 < stringArray.length) {
                            this.document.insertString(n8, stringArray[n5], null);
                        }
                    }
                    ++n5;
                }
            } else {
                String string2;
                String string3;
                int n;
                this.document.remove(this.selectionStart, this.selectionEnd - this.selectionStart);
                if (string != null) {
                    this.document.insertString(this.selectionStart, string, null);
                }
                if (this.autoIndent && (n = this.getCaretLine()) > 0 && string.equals("\n") && (string3 = StringUtil.getStartingWhiteSpace(string2 = this.getLineText(n - 1))) != null && string3.length() > 0) {
                    this.document.insertString(this.selectionEnd, string3, null);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            LogMgr.logError(new CallerInfo(){}, "Error setting text", badLocationException);
            throw new InternalError("Cannot replace selection");
        }
        finally {
            this.document.endCompoundEdit();
        }
        if (this.rectSelect) {
            if (StringUtil.isNonEmpty(string)) {
                ++this.selectionStart;
                if (this.overwrite) {
                    ++this.selectionEnd;
                } else if (this.selectionStart > this.selectionEnd) {
                    ++this.selectionEnd;
                }
            }
        } else {
            this.setCaretPosition(this.selectionEnd);
        }
        int n = this.getLineOfOffset(this.selectionStart);
        int n9 = this.getLineOfOffset(this.selectionStart + string.length());
        this.painter.invalidateLineRange(n, n9);
        this.updateScrollBars();
    }

    public void insertText(String string) {
        this.insertText(this.getCaretPosition(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertText(int n, String string) {
        if (string == null) {
            string = "";
        }
        if (MemoryWatcher.isMemoryLow(true)) {
            WbManager.getInstance().showLowMemoryError();
            return;
        }
        try {
            this.document.beginCompoundEdit();
            this.document.insertString(n, this.fixLinefeed(string), null);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error setting text", exception);
        }
        finally {
            this.document.endCompoundEdit();
        }
    }

    public void setAutoIndent(boolean bl) {
        this.autoIndent = bl;
    }

    public boolean getAutoIndent() {
        return this.autoIndent;
    }

    public final boolean isEditable() {
        return this.editable;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.inputHandler.setEnabled(bl);
    }

    public void setEditable(boolean bl) {
        if (this.editable == bl) {
            return;
        }
        this.editable = bl;
        if (this.popup != null) {
            this.popup.getCutAction().setEnabled(bl);
            this.popup.getClearAction().setEnabled(bl);
            this.popup.getPasteAction().setEnabled(bl);
        }
    }

    public final JPopupMenu getRightClickPopup() {
        return this.popup;
    }

    public final void setRightClickPopup(TextPopup textPopup) {
        this.popup = textPopup;
    }

    public final int getMagicCaretPosition() {
        return this.magicCaret;
    }

    public final void setMagicCaretPosition(int n) {
        this.magicCaret = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void overwriteSetSelectedText(String string) {
        if (!this.overwrite || this.selectionStart != this.selectionEnd) {
            this.setSelectedText(string);
            return;
        }
        int n = this.getCaretPosition();
        int n2 = this.getLineEndOffset(this.getCaretLine());
        if (n2 - n <= string.length()) {
            this.setSelectedText(string);
            return;
        }
        this.document.beginCompoundEdit();
        try {
            string = this.fixLinefeed(string);
            this.document.remove(n, string.length());
            this.document.insertString(n, string, null);
        }
        catch (BadLocationException badLocationException) {
            LogMgr.logError(new CallerInfo(){}, "Error setting text", badLocationException);
        }
        finally {
            this.document.endCompoundEdit();
        }
        this.updateScrollBars();
    }

    public final boolean isOverwriteEnabled() {
        return this.overwrite;
    }

    public final void setOverwriteEnabled(boolean bl) {
        this.overwrite = bl;
        this.painter.invalidateSelectedLines();
    }

    public final boolean isSelectionRectangular() {
        return this.rectSelect;
    }

    public final void setSelectionRectangular(boolean bl) {
        this.rectSelect = bl;
        this.painter.invalidateSelectedLines();
    }

    public final int getBracketPosition() {
        return this.bracketPosition;
    }

    public final int getBracketLine() {
        return this.bracketLine;
    }

    public final void addSelectionListener(TextSelectionListener textSelectionListener) {
        this.removeSelectionListener(textSelectionListener);
        this.listeners.add(TextSelectionListener.class, textSelectionListener);
    }

    public final void removeSelectionListener(TextSelectionListener textSelectionListener) {
        this.listeners.remove(TextSelectionListener.class, textSelectionListener);
    }

    public final void addTextChangeListener(TextChangeListener textChangeListener) {
        this.removeTextChangeListener(textChangeListener);
        this.listeners.add(TextChangeListener.class, textChangeListener);
    }

    public final void removeTextChangeListener(TextChangeListener textChangeListener) {
        this.listeners.remove(TextChangeListener.class, textChangeListener);
    }

    @Override
    public void cut() {
        if (this.editable) {
            this.copy();
            this.setSelectedText("");
        }
    }

    @Override
    public void clear() {
        if (this.editable) {
            this.setSelectedText("");
        }
    }

    @Override
    public void copy() {
        if (this.selectionStart != this.selectionEnd) {
            Clipboard clipboard = this.getToolkit().getSystemClipboard();
            String string = this.getSelectedText();
            clipboard.setContents(new StringSelection(string), null);
        }
    }

    @Override
    public void paste() {
        if (this.editable) {
            if (MemoryWatcher.isMemoryLow(true)) {
                WbManager.getInstance().showLowMemoryError();
                return;
            }
            try {
                Clipboard clipboard = this.getToolkit().getSystemClipboard();
                Transferable transferable = clipboard.getContents(this);
                LogMgr.logTrace(new CallerInfo(){}, "Received flavors: " + WbSwingUtilities.getFlavors(transferable));
                Object object = transferable.getTransferData(DataFlavor.stringFlavor);
                if (object != null) {
                    String string = object.toString();
                    if (GuiSettings.cleanupClipboardContent()) {
                        ClipboardCleaner clipboardCleaner = new ClipboardCleaner();
                        string = clipboardCleaner.cleanupText(string);
                    }
                    this.setSelectedText(string);
                }
            }
            catch (Throwable throwable) {
                LogMgr.logError(new CallerInfo(){}, "Could not get string data from clipboard", throwable);
            }
        }
    }

    public void setKeyEventInterceptor(KeyListener keyListener) {
        this.keyEventInterceptor = keyListener;
    }

    public void removeKeyEventInterceptor() {
        this.keyEventInterceptor = null;
    }

    private void forwardKeyEvent(KeyListener keyListener, KeyEvent keyEvent) {
        if (keyListener == null) {
            return;
        }
        switch (keyEvent.getID()) {
            case 400: {
                keyListener.keyTyped(keyEvent);
                break;
            }
            case 401: {
                keyListener.keyPressed(keyEvent);
                break;
            }
            case 402: {
                keyListener.keyReleased(keyEvent);
            }
        }
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return;
        }
        if (this.inputHandler == null) {
            return;
        }
        if (this.keyEventInterceptor != null) {
            this.forwardKeyEvent(this.keyEventInterceptor, keyEvent);
            return;
        }
        int n = NumberStringCache.getNumberString(this.getLineCount()).length();
        switch (keyEvent.getID()) {
            case 400: {
                this.inputHandler.keyTyped(keyEvent);
                break;
            }
            case 401: {
                this.inputHandler.keyPressed(keyEvent);
                break;
            }
            case 402: {
                this.inputHandler.keyReleased(keyEvent);
            }
        }
        if (this.keyNotificationListener != null) {
            this.forwardKeyEvent(this.keyNotificationListener, keyEvent);
        }
        if (!keyEvent.isConsumed()) {
            super.processKeyEvent(keyEvent);
        }
        int n2 = NumberStringCache.getNumberString(this.getLineCount()).length();
        boolean bl = false;
        if (this.getFirstLine() < 0) {
            this.updateScrollBars();
            bl = true;
        }
        boolean bl2 = bl = bl || n != n2;
        if (bl) {
            this.invalidate();
            this.repaint();
        }
    }

    protected void fireTextStatusChanged(boolean bl) {
        Object[] objectArray = this.listeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; --i) {
            if (objectArray[i] != TextChangeListener.class) continue;
            ((TextChangeListener)objectArray[i + 1]).textStatusChanged(bl);
        }
    }

    protected void fireSelectionEvent() {
        Object[] objectArray = this.listeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; --i) {
            if (objectArray[i] != TextSelectionListener.class) continue;
            ((TextSelectionListener)objectArray[i + 1]).selectionChanged(this.getSelectionStart(), this.getSelectionEnd());
        }
    }

    public void setStatusBar(EditorStatusbar editorStatusbar) {
        this.statusBar = editorStatusbar;
        this.updateStatusBar();
    }

    private void updateStatusBar() {
        if (this.statusBar != null) {
            int n = this.getCaretLine();
            this.statusBar.setEditorLocation(n + 1, this.getCaretPositionInLine(n) + 1);
        }
    }

    protected void fireCaretEvent() {
        Object[] objectArray = this.listeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; --i) {
            if (objectArray[i] != CaretListener.class) continue;
            ((CaretListener)objectArray[i + 1]).caretUpdate(this.caretEvent);
        }
        this.updateStatusBar();
    }

    public void invalidateBracketLine() {
        this.updateBracketHighlight(this.getCaretPosition());
    }

    protected void updateBracketHighlight(int n) {
        if (n == 0 || !Settings.getInstance().isBracketHighlightEnabled()) {
            this.bracketPosition = -1;
            this.bracketLine = -1;
            return;
        }
        try {
            boolean bl = Settings.getInstance().getBracketHighlightLeft();
            int n2 = bl ? -1 : 0;
            int n3 = TextUtilities.findMatchingBracket(this.document, n + n2);
            if (n3 != -1) {
                this.bracketLine = this.getLineOfOffset(n3);
                this.bracketPosition = n3 - this.getLineStartOffset(this.bracketLine);
                return;
            }
        }
        catch (BadLocationException badLocationException) {
            LogMgr.logError(new CallerInfo(){}, "Error setting text", badLocationException);
        }
        this.bracketLine = -1;
        this.bracketPosition = -1;
    }

    protected void documentChanged(DocumentEvent documentEvent) {
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(this.document.getDefaultRootElement());
        int n = elementChange == null ? 0 : elementChange.getChildrenAdded().length - elementChange.getChildrenRemoved().length;
        int n2 = this.getLineOfOffset(documentEvent.getOffset());
        this.invalidateLines(n2);
        if (n == 0) {
            this.painter.invalidateLine(n2);
        } else {
            this.painter.invalidateLineRange(n2, (this.firstLine < 0 ? 0 : this.firstLine) + this.visibleLines);
        }
        boolean bl = this.isModified();
        this.setModified();
        if (!bl) {
            this.fireTextStatusChanged(true);
        }
        this.updateScrollBars();
    }

    private void invalidateLines(int n) {
        TokenMarker tokenMarker = this.getTokenMarker();
        if (tokenMarker == null) {
            return;
        }
        int n2 = n - this.invalidationInterval;
        int n3 = n + this.invalidationInterval;
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 > tokenMarker.getLineCount()) {
            n3 = tokenMarker.getLineCount() - 1;
        }
        this.document.tokenizeLines(n2, n3);
        int n4 = n2 < this.getFirstLine() ? this.getFirstLine() : n2;
        int n5 = n3 > n4 + this.getVisibleLines() ? n4 + this.getVisibleLines() : n3;
        this.painter.invalidateLineRange(n4, n5);
    }

    public void showContextMenu() {
        Point point = this.getCursorLocation();
        this.popup.show(this.painter, point.x, point.y);
    }

    public long getLastModifiedTime() {
        return this.lastModified;
    }

    public boolean isModifiedAfter(long l) {
        return this.lastModified > 0L && this.lastModified > l;
    }

    public void setModified() {
        this.lastModified = System.currentTimeMillis();
    }

    public boolean isModified() {
        return this.lastModified > 0L;
    }

    public void resetModified() {
        boolean bl = this.isModified();
        this.lastModified = 0L;
        if (bl) {
            this.fireTextStatusChanged(false);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (mouseWheelEvent.getScrollType() != 0) {
            return;
        }
        if (WbAction.isCtrlPressed(mouseWheelEvent.getModifiers())) {
            return;
        }
        int n = GuiSettings.getWheelScrollLines();
        if (n > 0) {
            if (mouseWheelEvent.getUnitsToScroll() < 0) {
                n = -n;
            }
        } else {
            n = mouseWheelEvent.getUnitsToScroll();
        }
        this.vertical.setValue(this.vertical.getValue() + n);
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            JEditTextArea.this.requestFocus();
            JEditTextArea.this.setCaretVisible(true);
            int n = mouseEvent.getX() - JEditTextArea.this.painter.getGutterWidth();
            int n2 = JEditTextArea.this.yToLine(mouseEvent.getY());
            int n3 = JEditTextArea.this.xToOffset(n2, n);
            int n4 = JEditTextArea.this.getLineStartOffset(n2) + n3;
            if ((mouseEvent.getModifiers() & 4) != 0 && JEditTextArea.this.popup != null) {
                if (JEditTextArea.this.rightClickMovesCursor && !JEditTextArea.this.isTextSelected()) {
                    JEditTextArea.this.setCaretPosition(n4);
                }
                JEditTextArea.this.popup.show(JEditTextArea.this.painter, n, mouseEvent.getY());
                return;
            }
            switch (mouseEvent.getClickCount()) {
                case 1: {
                    this.doSingleClick(mouseEvent, n2, n3, n4);
                    break;
                }
                case 2: {
                    try {
                        this.doDoubleClick(mouseEvent, n2, n3, n4);
                    }
                    catch (BadLocationException badLocationException) {
                        LogMgr.logError(new CallerInfo(){}, "Error setting text", badLocationException);
                    }
                    break;
                }
                case 3: {
                    this.doTripleClick(mouseEvent, n2, n3, n4);
                }
            }
        }

        protected void doSingleClick(MouseEvent mouseEvent, int n, int n2, int n3) {
            if ((mouseEvent.getModifiers() & 1) != 0) {
                JEditTextArea.this.rectSelect = (mouseEvent.getModifiers() & Settings.getInstance().getRectSelectionModifier()) != 0;
                JEditTextArea.this.select(JEditTextArea.this.getMarkPosition(), n3);
            } else {
                JEditTextArea.this.setCaretPosition(n3);
            }
        }

        protected void doDoubleClick(MouseEvent mouseEvent, int n, int n2, int n3) throws BadLocationException {
            int n4;
            int n5;
            if (JEditTextArea.this.getLineLength(n) == 0) {
                return;
            }
            try {
                int n6 = TextUtilities.findMatchingBracket(JEditTextArea.this.document, Math.max(0, n3 - 1));
                if (n6 != -1) {
                    int n7 = JEditTextArea.this.getMarkPosition();
                    if (n6 > n7) {
                        ++n6;
                        --n7;
                    }
                    JEditTextArea.this.select(n7, n6);
                    return;
                }
            }
            catch (BadLocationException badLocationException) {
                LogMgr.logError(new CallerInfo(){}, "Error", badLocationException);
            }
            String string = JEditTextArea.this.getLineText(n);
            char c = string.charAt(Math.max(0, n2 - 1));
            String string2 = Settings.getInstance().getEditorNoWordSep();
            if (string2 == null) {
                string2 = "";
            }
            boolean bl = !Character.isLetterOrDigit(c) && string2.indexOf(c) == -1;
            int n8 = 0;
            for (n5 = n2 - 1; n5 >= 0; --n5) {
                c = string.charAt(n5);
                if (!(bl ^ (!Character.isLetterOrDigit(c) && string2.indexOf(c) == -1))) continue;
                n8 = n5 + 1;
                break;
            }
            n5 = string.length();
            for (n4 = n2; n4 < string.length(); ++n4) {
                c = string.charAt(n4);
                if (!(bl ^ (!Character.isLetterOrDigit(c) && string2.indexOf(c) == -1))) continue;
                n5 = n4;
                break;
            }
            n4 = JEditTextArea.this.getLineStartOffset(n);
            JEditTextArea.this.select(n4 + n8, n4 + n5);
        }

        protected void doTripleClick(MouseEvent mouseEvent, int n, int n2, int n3) {
            JEditTextArea.this.select(JEditTextArea.this.getLineStartOffset(n), JEditTextArea.this.getLineEndOffset(n) - 1);
        }
    }

    private class DragHandler
    implements MouseMotionListener {
        private DragHandler() {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (JEditTextArea.this.popup != null && JEditTextArea.this.popup.isVisible()) {
                return;
            }
            JEditTextArea.this.setSelectionRectangular((mouseEvent.getModifiers() & Settings.getInstance().getRectSelectionModifier()) != 0);
            int n = mouseEvent.getX() - JEditTextArea.this.painter.getGutterWidth();
            int n2 = mouseEvent.getY();
            JEditTextArea.this.select(JEditTextArea.this.getMarkPosition(), JEditTextArea.this.xyToOffset(n, n2));
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }

    private class DocumentHandler
    implements DocumentListener {
        private DocumentHandler() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            JEditTextArea.this.documentChanged(documentEvent);
            int n = documentEvent.getOffset();
            int n2 = documentEvent.getLength();
            int n3 = JEditTextArea.this.selectionStart > n || JEditTextArea.this.selectionStart == JEditTextArea.this.selectionEnd && JEditTextArea.this.selectionStart == n ? JEditTextArea.this.selectionStart + n2 : JEditTextArea.this.selectionStart;
            int n4 = JEditTextArea.this.selectionEnd >= n ? JEditTextArea.this.selectionEnd + n2 : JEditTextArea.this.selectionEnd;
            JEditTextArea.this.select(n3, n4);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            JEditTextArea.this.documentChanged(documentEvent);
            int n = documentEvent.getOffset();
            int n2 = documentEvent.getLength();
            int n3 = JEditTextArea.this.selectionStart > n ? (JEditTextArea.this.selectionStart > n + n2 ? JEditTextArea.this.selectionStart - n2 : n) : JEditTextArea.this.selectionStart;
            int n4 = JEditTextArea.this.selectionEnd > n ? (JEditTextArea.this.selectionEnd > n + n2 ? JEditTextArea.this.selectionEnd - n2 : n) : JEditTextArea.this.selectionEnd;
            JEditTextArea.this.select(n3, n4);
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }

    private class ComponentHandler
    extends ComponentAdapter {
        private ComponentHandler() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            if (componentEvent.getID() == 101) {
                JEditTextArea.this.recalculateVisibleLines();
                JEditTextArea.this.updateScrollBars();
                JEditTextArea.this.invalidate();
            }
        }
    }

    private class AdjustHandler
    implements AdjustmentListener {
        private AdjustHandler() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            if (adjustmentEvent.getAdjustable() == JEditTextArea.this.vertical) {
                JEditTextArea.this.setFirstLine(JEditTextArea.this.vertical.getValue(), false);
            } else if (adjustmentEvent.getAdjustable() == JEditTextArea.this.horizontal) {
                JEditTextArea.this.setHorizontalOffset(-JEditTextArea.this.horizontal.getValue(), false);
            }
        }
    }

    private class MutableCaretEvent
    extends CaretEvent {
        MutableCaretEvent() {
            super(JEditTextArea.this);
        }

        @Override
        public int getDot() {
            return JEditTextArea.this.getCaretPosition();
        }

        @Override
        public int getMark() {
            return JEditTextArea.this.getMarkPosition();
        }
    }
}

