/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.editor;

import java.awt.Container;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.FindAction;
import workbench.gui.actions.FindNextAction;
import workbench.gui.actions.FindPreviousAction;
import workbench.gui.actions.ReplaceAction;
import workbench.gui.actions.WbAction;
import workbench.gui.components.ReplacePanel;
import workbench.gui.components.SearchCriteriaPanel;
import workbench.gui.editor.SearchResult;
import workbench.interfaces.Replaceable;
import workbench.interfaces.Searchable;
import workbench.interfaces.TextContainer;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.util.ExceptionUtil;
import workbench.util.StringUtil;

public class SearchAndReplace
implements Replaceable,
Searchable {
    private String lastSearchExpression;
    private String lastSearchCriteria;
    private Pattern lastSearchPattern;
    private int lastSearchPos;
    private ReplacePanel replacePanel;
    private TextContainer editor;
    private Container parent;
    private FindAction findAction;
    private FindPreviousAction findPreviousAction;
    private FindNextAction findNextAction;
    private ReplaceAction replaceAction;
    private boolean wrapSearch;
    private boolean showNotifications = true;

    public SearchAndReplace(Container container, TextContainer textContainer) {
        this.editor = textContainer;
        this.parent = container;
        this.findAction = new FindAction(this);
        this.findPreviousAction = new FindPreviousAction(this);
        this.findPreviousAction.setEnabled(false);
        this.findAction.setEnabled(true);
        this.findNextAction = new FindNextAction(this);
        this.findNextAction.setEnabled(false);
        this.replaceAction = new ReplaceAction(this);
        this.replaceAction.setEnabled(true);
    }

    public void setShowNotifications(boolean bl) {
        this.showNotifications = bl;
    }

    public boolean getWrapSearch() {
        return this.wrapSearch;
    }

    @Override
    public void setWrapSearch(boolean bl) {
        this.wrapSearch = bl;
    }

    public ReplaceAction getReplaceAction() {
        return this.replaceAction;
    }

    public FindPreviousAction getFindPreviousAction() {
        return this.findPreviousAction;
    }

    public FindNextAction getFindNextAction() {
        return this.findNextAction;
    }

    public FindAction getFindAction() {
        return this.findAction;
    }

    private String getText() {
        return this.editor.getText();
    }

    private String getSelectedText() {
        return this.editor.getSelectedText();
    }

    private int getCaretPosition() {
        return this.editor.getCaretPosition();
    }

    @Override
    public int find() {
        boolean bl = true;
        String string = this.getSelectedText();
        if (string != null && string.indexOf(10) > -1) {
            string = null;
        }
        if (string == null) {
            string = this.lastSearchCriteria;
        }
        SearchCriteriaPanel searchCriteriaPanel = new SearchCriteriaPanel(string);
        int n = -1;
        while (bl) {
            boolean bl2 = searchCriteriaPanel.showFindDialog(this.parent);
            if (!bl2) {
                return -1;
            }
            String string2 = searchCriteriaPanel.getCriteria();
            boolean bl3 = searchCriteriaPanel.getIgnoreCase();
            boolean bl4 = searchCriteriaPanel.getWholeWordOnly();
            boolean bl5 = searchCriteriaPanel.getUseRegex();
            this.setWrapSearch(searchCriteriaPanel.getWrapSearch());
            try {
                this.lastSearchCriteria = string2;
                this.findNextAction.setEnabled(false);
                this.findPreviousAction.setEnabled(false);
                n = this.findText(string2, bl3, bl4, bl5);
                bl = false;
                this.findNextAction.setEnabled(n > -1 || this.wrapSearch);
                this.findPreviousAction.setEnabled(n > -1);
            }
            catch (Exception exception) {
                n = -1;
                WbSwingUtilities.showErrorMessage(this.parent, ExceptionUtil.getDisplay(exception));
                bl = true;
            }
        }
        return n;
    }

    @Override
    public int findPrevious() {
        if (this.lastSearchPattern == null) {
            return -1;
        }
        if (this.lastSearchPos == -1) {
            return -1;
        }
        Matcher matcher = this.lastSearchPattern.matcher(this.getText());
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        while (matcher.find(n)) {
            int n4 = matcher.start();
            if (n4 >= this.lastSearchPos) {
                if (n2 == -1) {
                    n2 = n4;
                    n3 = matcher.end();
                    Toolkit.getDefaultToolkit().beep();
                }
                this.lastSearchPos = n2;
                this.editor.select(this.lastSearchPos, n3);
                return n2;
            }
            n2 = n4;
            n3 = matcher.end();
            n = matcher.end() + 1;
        }
        return -1;
    }

    @Override
    public int findNext() {
        boolean bl;
        if (this.lastSearchPattern == null) {
            return -1;
        }
        if (this.lastSearchPos == -1 && !this.wrapSearch) {
            return -1;
        }
        Matcher matcher = this.lastSearchPattern.matcher(this.getText());
        int n = this.getCaretPosition() + 1;
        if (this.wrapSearch && this.lastSearchPos == -1) {
            n = 0;
        }
        if (!(bl = matcher.find(n)) && this.wrapSearch) {
            bl = matcher.find(0);
        }
        if (bl) {
            this.lastSearchPos = matcher.start();
            int n2 = matcher.end();
            this.editor.select(this.lastSearchPos, n2);
        } else if (this.showNotifications) {
            this.lastSearchPos = -1;
            Toolkit.getDefaultToolkit().beep();
            String string = ResourceMgr.getString("MsgEditorCriteriaNotFound");
            string = StringUtil.replace(string, "%value%", this.lastSearchExpression);
            WbSwingUtilities.showMessage(this.parent, string);
        }
        this.findNextAction.setEnabled(this.lastSearchPos > -1);
        return this.lastSearchPos;
    }

    @Override
    public int findFirst(String string, boolean bl, boolean bl2, boolean bl3) {
        this.lastSearchPos = this.findText(string, bl, bl2, bl3);
        this.findNextAction.setEnabled(this.lastSearchPos > -1);
        return this.lastSearchPos;
    }

    @Override
    public void replace() {
        if (this.replacePanel == null) {
            this.replacePanel = new ReplacePanel(this);
        }
        this.replacePanel.showReplaceDialog(this.parent, this.editor.getSelectedText());
    }

    @Override
    public boolean replaceNext(String string, boolean bl) {
        try {
            int n = this.findNext();
            if (n > -1) {
                String string2 = this.getSelectedText();
                Matcher matcher = this.lastSearchPattern.matcher(string2);
                String string3 = matcher.replaceAll(SearchAndReplace.fixSpecialReplacementChars(string, bl));
                this.editor.setSelectedText(string3);
            }
            return n > -1;
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error replacing value", exception);
            WbSwingUtilities.showErrorMessage(exception.getMessage());
            return false;
        }
    }

    @Override
    public boolean isTextSelected() {
        int n = this.editor.getSelectionStart();
        int n2 = this.editor.getSelectionEnd();
        return n > -1 && n2 > n;
    }

    public static String fixSpecialReplacementChars(String string, boolean bl) {
        if (!bl) {
            return StringUtil.quoteRegexMeta(string);
        }
        String string2 = string.replaceAll("\\\\n", "\n");
        string2 = string2.replaceAll("\\\\r", "\r");
        string2 = string2.replaceAll("\\\\t", "\t");
        return string2;
    }

    @Override
    public List<SearchResult> findAll(String string, boolean bl, boolean bl2, boolean bl3, int n) {
        String string2 = SearchAndReplace.getSearchExpression(string, bl, bl2, bl3);
        ArrayList<SearchResult> arrayList = new ArrayList<SearchResult>();
        Pattern pattern = Pattern.compile(string2, 8);
        Matcher matcher = pattern.matcher(this.getText());
        int n2 = 0;
        int n3 = -1;
        while (matcher.find(n2)) {
            int n4 = matcher.start();
            int n5 = matcher.end();
            int n6 = this.editor.getLineOfOffset(n4);
            if (n6 != n3) {
                String string3 = this.getLineContext(n6, n);
                SearchResult searchResult = new SearchResult(string3, n4, n5 - n4, n6, -1);
                arrayList.add(searchResult);
            }
            n3 = n6;
            n2 = n5;
        }
        return arrayList;
    }

    private String getLineContext(int n, int n2) {
        if (n < 0) {
            return null;
        }
        if (n2 <= 0) {
            return this.editor.getLineText(n);
        }
        int n3 = Math.max(0, n - n2);
        int n4 = Math.min(this.editor.getLineCount() - 1, n + n2);
        StringBuilder stringBuilder = new StringBuilder(n2 * 80);
        for (int i = n3; i <= n4; ++i) {
            if (i > n3) {
                stringBuilder.append('\n');
            }
            stringBuilder.append(this.editor.getLineText(i));
        }
        return stringBuilder.toString();
    }

    @Override
    public void replaceAll(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        String string3 = null;
        if (bl) {
            string3 = this.getSelectedText();
            if (string3 == null) {
                return;
            }
        } else {
            string3 = this.getText();
        }
        int n = this.getCaretPosition();
        int n2 = this.editor.getSelectionStart();
        int n3 = this.editor.getSelectionEnd();
        int n4 = -1;
        String string4 = SearchAndReplace.getSearchExpression(string, bl2, bl3, bl4);
        string2 = SearchAndReplace.fixSpecialReplacementChars(string2, bl4);
        Pattern pattern = Pattern.compile(string4, 8);
        Matcher matcher = pattern.matcher(string3);
        String string5 = matcher.replaceAll(string2);
        if (bl) {
            this.editor.setSelectedText(string5);
            n4 = this.getText().length();
            int n5 = string5.length() - string3.length();
            if (n2 < (n3 += n5)) {
                this.editor.select(n2, n3);
            } else if (n < n4) {
                this.editor.setCaretPosition(n);
            }
        } else {
            this.editor.setText(string5);
            n4 = this.getText().length();
            if (n < n4) {
                this.editor.setCaretPosition(n);
            } else {
                this.editor.setCaretPosition(0);
            }
        }
    }

    @Override
    public boolean replaceCurrent(String string, boolean bl) {
        if (this.searchPatternMatchesSelectedText()) {
            try {
                Matcher matcher = this.lastSearchPattern.matcher(this.getSelectedText());
                String string2 = matcher.replaceAll(SearchAndReplace.fixSpecialReplacementChars(string, bl));
                this.editor.setSelectedText(string2);
                return true;
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Error replacing value", exception);
                WbSwingUtilities.showErrorMessage(exception.getMessage());
                return false;
            }
        }
        return this.replaceNext(string, bl);
    }

    public int findText(String string, boolean bl) {
        return this.findText(string, bl, false, true);
    }

    public static String getSearchExpression(String string, boolean bl, boolean bl2, boolean bl3) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + 10);
        if (bl) {
            stringBuilder.append("(?i)");
        }
        if (!bl3) {
            stringBuilder.append('(');
            stringBuilder.append(StringUtil.quoteRegexMeta(string));
            stringBuilder.append(')');
        } else {
            stringBuilder.append(string);
        }
        if (bl2) {
            char c = string.charAt(0);
            if ("\\[](){}.*+?$^|".indexOf(c) == -1) {
                if (bl) {
                    stringBuilder.insert("(?i)".length(), "\\b");
                } else {
                    stringBuilder.insert(0, "\\b");
                }
            }
            if ("\\[](){}.*+?$^|".indexOf(c = string.charAt(string.length() - 1)) == -1) {
                stringBuilder.append("\\b");
            }
        }
        return stringBuilder.toString();
    }

    public boolean isCurrentSearchCriteria(String string, boolean bl, boolean bl2, boolean bl3) {
        if (this.lastSearchExpression == null) {
            return false;
        }
        if (string == null) {
            return false;
        }
        String string2 = SearchAndReplace.getSearchExpression(string, bl, bl2, bl3);
        return string2.equals(this.lastSearchExpression);
    }

    public int findText(String string, boolean bl, boolean bl2, boolean bl3) {
        int n;
        String string2 = SearchAndReplace.getSearchExpression(string, bl, bl2, bl3);
        int n2 = -1;
        this.lastSearchPattern = Pattern.compile(string2, 8);
        this.lastSearchExpression = string;
        Matcher matcher = this.lastSearchPattern.matcher(this.getText());
        int n3 = n = this.isTextSelected() ? this.editor.getSelectionStart() : this.getCaretPosition();
        if (matcher.find(n)) {
            this.lastSearchPos = matcher.start();
            n2 = matcher.end();
            this.editor.select(this.lastSearchPos, n2);
        } else {
            this.lastSearchPos = -1;
            int n4 = -1;
            if (this.wrapSearch) {
                n4 = this.findNext();
            }
            if (n4 < 0 && this.showNotifications) {
                Toolkit.getDefaultToolkit().beep();
                String string3 = ResourceMgr.getString("MsgEditorCriteriaNotFound");
                string3 = StringUtil.replace(string3, "%value%", string);
                WbSwingUtilities.showMessage(this.parent, string3);
            }
        }
        return this.lastSearchPos;
    }

    public boolean searchPatternMatchesSelectedText() {
        if (this.lastSearchPattern == null) {
            return false;
        }
        Matcher matcher = this.lastSearchPattern.matcher(this.getSelectedText());
        return matcher.matches();
    }

    public void dispose() {
        WbAction.dispose(this.findAction, this.findPreviousAction, this.findNextAction, this.replaceAction);
    }
}

