/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.editor;

import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import workbench.gui.editor.TokenMarker;
import workbench.gui.editor.WbCompoundEdit;
import workbench.resource.Settings;

public class SyntaxDocument
extends PlainDocument
implements UndoableEditListener {
    private UndoManager undoManager = new UndoManager();
    protected TokenMarker tokenMarker;
    private WbCompoundEdit undoItem = new WbCompoundEdit();
    private boolean undoSuspended;
    private int maxLineLength;
    private int longestLine;
    private int maxCompoundEditDelay = Settings.getInstance().getIntProperty("workbench.gui.editor.compoundedit.delay", 150);
    private int lastChangePosition = -1;

    public SyntaxDocument() {
        this.addUndoableEditListener(this);
        this.initDefaultProperties();
    }

    public SyntaxDocument(AbstractDocument.Content content) {
        super(content);
        this.addUndoableEditListener(this);
        this.initDefaultProperties();
    }

    public DocumentEvent createChangedEvent() {
        AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(this, 0, this.getLength(), DocumentEvent.EventType.CHANGE);
        return defaultDocumentEvent;
    }

    protected final void initDefaultProperties() {
        this.putProperty("filterNewlines", Boolean.FALSE);
        this.putProperty("tabSize", Settings.getInstance().getEditorTabWidth());
    }

    public TokenMarker getTokenMarker() {
        return this.tokenMarker;
    }

    public void setTokenMarker(TokenMarker tokenMarker) {
        if (this.tokenMarker != null) {
            this.tokenMarker.reset();
        }
        this.tokenMarker = tokenMarker;
        if (tokenMarker == null) {
            return;
        }
        this.tokenMarker.insertLines(0, this.getDefaultRootElement().getElementCount());
        this.tokenizeLines();
    }

    public void reset() {
        this.clearUndoBuffer();
        this.lastChangePosition = 0;
        try {
            this.suspendUndo();
            this.remove(0, this.getLength());
        }
        catch (Throwable throwable) {
        }
        finally {
            this.resumeUndo();
        }
        if (this.tokenMarker != null) {
            this.tokenMarker.reset();
        }
    }

    public void suspendUndo() {
        this.undoSuspended = true;
    }

    public void resumeUndo() {
        this.undoSuspended = false;
    }

    public void clearUndoBuffer() {
        this.undoManager.discardAllEdits();
        this.undoItem.reset();
    }

    public void redo() {
        this.endCompoundEdit();
        if (!this.undoManager.canRedo()) {
            return;
        }
        try {
            this.undoManager.redo();
        }
        catch (CannotRedoException cannotRedoException) {
            cannotRedoException.printStackTrace();
        }
    }

    public void undo() {
        this.endCompoundEdit();
        if (!this.undoManager.canUndo()) {
            return;
        }
        try {
            this.undoManager.undo();
        }
        catch (CannotUndoException cannotUndoException) {
            cannotUndoException.printStackTrace();
        }
    }

    public void tokenizeLines() {
        if (this.tokenMarker == null) {
            return;
        }
        this.maxLineLength = 0;
        this.longestLine = -1;
        this.tokenizeLines(0, this.getDefaultRootElement().getElementCount());
    }

    public void tokenizeLines(int n, int n2) {
        if (this.tokenMarker == null) {
            return;
        }
        Segment segment = new Segment();
        Element element = this.getDefaultRootElement();
        n2 += n;
        try {
            Element element2;
            for (int i = n; i < n2 && (element2 = element.getElement(i)) != null; ++i) {
                int n3 = element2.getStartOffset();
                this.getText(n3, element2.getEndOffset() - n3 - 1, segment);
                if (segment.count > this.maxLineLength) {
                    this.maxLineLength = segment.count;
                    this.longestLine = i;
                }
                this.tokenMarker.markTokens(segment, i);
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    private void calcMaxLineLength() {
        Segment segment = new Segment();
        Element element = this.getDefaultRootElement();
        int n = this.getDefaultRootElement().getElementCount();
        this.maxLineLength = 0;
        this.longestLine = -1;
        try {
            for (int i = 0; i < n; ++i) {
                Element element2 = element.getElement(i);
                int n2 = element2.getStartOffset();
                this.getText(n2, element2.getEndOffset() - n2 - 1, segment);
                if (segment.count <= this.maxLineLength) continue;
                this.maxLineLength = segment.count;
                this.longestLine = i;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public int getMaxLineLength() {
        if (this.maxLineLength <= 0 && this.getLength() > 0) {
            this.calcMaxLineLength();
        }
        return this.maxLineLength;
    }

    @Override
    public synchronized void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        if (this.undoSuspended) {
            return;
        }
        this.undoItem.addEdit(undoableEditEvent.getEdit());
    }

    public synchronized void beginCompoundEdit() {
        if (this.undoSuspended) {
            return;
        }
        long l = this.undoItem.getDurationSinceLastEdit();
        if (l > (long)this.maxCompoundEditDelay && this.undoItem.getSize() > 0) {
            this.endCompoundEdit();
        }
    }

    public synchronized void endCompoundEdit() {
        if (this.undoSuspended) {
            return;
        }
        long l = this.undoItem.getDurationSinceLastEdit();
        if (l > (long)this.maxCompoundEditDelay && this.undoItem.getSize() > 0) {
            this.undoItem.finished();
            this.undoManager.addEdit(this.undoItem);
            this.undoItem = new WbCompoundEdit();
        }
    }

    public int getPositionOfLastChange() {
        return this.lastChangePosition;
    }

    @Override
    protected void fireInsertUpdate(DocumentEvent documentEvent) {
        DocumentEvent.ElementChange elementChange;
        if (this.tokenMarker != null && (elementChange = documentEvent.getChange(this.getDefaultRootElement())) != null) {
            int n = elementChange.getIndex() + 1;
            int n2 = elementChange.getChildrenAdded().length - elementChange.getChildrenRemoved().length;
            this.tokenMarker.insertLines(n, n2);
            if (this.longestLine >= n - 1 && this.longestLine <= n + n2) {
                this.longestLine = -1;
                this.maxLineLength = 0;
            }
        }
        this.lastChangePosition = documentEvent.getOffset();
        super.fireInsertUpdate(documentEvent);
    }

    @Override
    protected void fireRemoveUpdate(DocumentEvent documentEvent) {
        DocumentEvent.ElementChange elementChange;
        if (this.tokenMarker != null && (elementChange = documentEvent.getChange(this.getDefaultRootElement())) != null) {
            int n = elementChange.getIndex() + 1;
            int n2 = elementChange.getChildrenRemoved().length - elementChange.getChildrenAdded().length;
            this.tokenMarker.deleteLines(n, n2);
            if (this.longestLine >= n - 1 && this.longestLine <= n + n2) {
                this.longestLine = -1;
                this.maxLineLength = 0;
            }
        }
        this.lastChangePosition = documentEvent.getOffset();
        super.fireRemoveUpdate(documentEvent);
    }
}

