/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.profiles;

public class ProfileKey {
    private String name;
    private String group;

    public ProfileKey(String string) {
        if (string == null) {
            throw new NullPointerException("Name cannot be null!");
        }
        this.setName(string);
    }

    public ProfileKey(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("Name cannot be null!");
        }
        if (string2 != null) {
            this.group = string2.trim();
            this.name = string.trim();
        } else {
            this.setName(string);
        }
    }

    private void setName(String string) {
        if (string == null) {
            return;
        }
        String string2 = string.trim();
        if (string2.length() > 0 && string2.charAt(0) == '{') {
            int n = string2.indexOf(125);
            if (n < 0) {
                throw new IllegalArgumentException("Missing closing } to define group name");
            }
            int n2 = string2.indexOf(47, n + 1);
            if (n2 < 0) {
                n2 = n;
            }
            this.name = string2.substring(n2 + 1).trim();
            this.group = string2.substring(1, n).trim();
        } else if (string2.length() > 0 && string2.indexOf(47) > -1) {
            int n = string2.indexOf(47);
            this.name = string2.substring(n + 1).trim();
            this.group = string2.substring(0, n).trim();
        } else {
            this.name = string2;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getGroup() {
        return this.group;
    }

    public String toString() {
        if (this.group == null) {
            return this.name;
        }
        return "{" + this.group + "}/" + this.name;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof ProfileKey) {
            ProfileKey profileKey = (ProfileKey)object;
            if (profileKey.getName() == null) {
                return false;
            }
            if (this.name.equals(profileKey.getName())) {
                if (profileKey.getGroup() == null || this.group == null) {
                    return true;
                }
                return this.getGroup().equals(profileKey.getGroup());
            }
        }
        return false;
    }
}

