/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.renderer;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import workbench.db.ColumnIdentifier;
import workbench.gui.components.SortArrowIcon;
import workbench.gui.components.WbTable;
import workbench.resource.GuiSettings;
import workbench.resource.Settings;
import workbench.storage.DataStore;
import workbench.storage.ResultInfo;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class SortHeaderRenderer
implements TableCellRenderer,
PropertyChangeListener {
    private final JLabel displayLabel = new JLabel();
    private boolean showFullTypeInfo;
    private boolean showBoldHeader;
    private boolean showDatatype;
    private boolean underlinePK;
    private boolean showRemarks;
    private boolean showColumnTable;
    private boolean showTableAsPrefix;
    private boolean showTableInComment;

    public SortHeaderRenderer() {
        this.readSettings();
        Settings.getInstance().addPropertyChangeListener(this, "workbench.gui.table.header.bold", "workbench.gui.table.header.typeinfo.full");
    }

    public void setUnderlinePK(boolean bl) {
        this.underlinePK = bl;
    }

    private void readSettings() {
        this.showBoldHeader = GuiSettings.showTableHeaderInBold();
        this.showFullTypeInfo = Settings.getInstance().getBoolProperty("workbench.gui.table.header.typeinfo.full", false);
        this.showColumnTable = GuiSettings.showTableNameInColumnHeader();
        this.showTableAsPrefix = GuiSettings.showTableNameAsColumnPrefix();
        this.showTableInComment = GuiSettings.showTableNameInColumnTooltip();
    }

    public void setShowRemarks(boolean bl) {
        this.showRemarks = bl;
    }

    public boolean getShowColumnTable() {
        return this.showColumnTable;
    }

    public boolean getShowTableAsColumnPrefix() {
        return this.showTableAsPrefix && this.showColumnTable;
    }

    public boolean getShowRemarks() {
        return this.showRemarks;
    }

    public void setShowDatatype(boolean bl) {
        this.showDatatype = bl;
    }

    public boolean getShowDataType() {
        return this.showDatatype;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.readSettings();
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Object object2;
        int n3;
        Serializable serializable;
        Serializable serializable2;
        TableCellRenderer tableCellRenderer = jTable.getTableHeader().getDefaultRenderer();
        JComponent jComponent = (JComponent)tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        String string = object == null ? "" : object.toString();
        JLabel jLabel = null;
        if (jComponent instanceof JLabel) {
            jLabel = (JLabel)jComponent;
        } else {
            this.displayLabel.setFont(jComponent.getFont());
            this.displayLabel.setBorder(jComponent.getBorder());
            this.displayLabel.setForeground(jComponent.getForeground());
            this.displayLabel.setBackground(jComponent.getBackground());
            this.displayLabel.setText(string);
            this.displayLabel.setOpaque(jComponent.isOpaque());
            jLabel = this.displayLabel;
        }
        jLabel.setVerticalAlignment(1);
        jLabel.setHorizontalTextPosition(2);
        jLabel.setHorizontalAlignment(2);
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n4 = 1111;
        String string5 = string;
        if (this.showBoldHeader) {
            string5 = "<b>" + string + "</b>";
        }
        String string6 = null;
        if (jTable instanceof WbTable) {
            serializable2 = (WbTable)jTable;
            bl3 = ((WbTable)serializable2).isViewColumnSorted(n2);
            if (bl3) {
                bl4 = ((WbTable)serializable2).isViewColumnSortAscending(n2);
                bl5 = ((WbTable)serializable2).isPrimarySortColumn(n2);
            }
            if ((serializable = ((WbTable)serializable2).getDataStoreTableModel()) != null && (n3 = jTable.convertColumnIndexToModel(n2) - serializable.getRealColumnStart()) >= 0) {
                ColumnIdentifier columnIdentifier;
                object2 = serializable.getDataStore();
                ResultInfo resultInfo = object2 == null ? null : ((DataStore)object2).getResultInfo();
                ColumnIdentifier columnIdentifier2 = columnIdentifier = resultInfo == null ? null : resultInfo.getColumn(n3);
                if (columnIdentifier != null) {
                    string2 = columnIdentifier.getDbmsType();
                    n4 = columnIdentifier.getDataType();
                    string3 = SqlUtil.getTypeName(n4);
                    string4 = columnIdentifier.getComment();
                    string6 = columnIdentifier.getSourceTableName();
                    if (this.showColumnTable && this.showTableAsPrefix && string6 != null) {
                        string5 = string6 + "." + columnIdentifier.getColumnName();
                        if (this.showBoldHeader) {
                            string5 = "<b>" + string5 + "</b>";
                        }
                    }
                    if (this.underlinePK && columnIdentifier.isPkColumn()) {
                        string5 = "<u>" + string5 + "</u>";
                    }
                    if (this.showColumnTable && !this.showTableAsPrefix && string6 != null) {
                        string5 = string5 + "<br><i>" + string6 + "</i>";
                    }
                    if (this.showDatatype && string2 != null) {
                        string5 = string5 + "<br>" + string2;
                    }
                    if (this.showRemarks && StringUtil.isNonEmpty(string4)) {
                        string5 = string5 + "<p style=\"word-wrap: break-word\">" + string4 + "</p>";
                    }
                }
            }
        }
        jLabel.setText("<html>" + string5 + "</html>");
        jLabel.invalidate();
        jLabel.setVerticalAlignment(1);
        if (bl3) {
            serializable2 = jLabel.getFont();
            serializable = jLabel.getFontMetrics((Font)serializable2);
            n3 = SortHeaderRenderer.getArrowSize((FontMetrics)serializable, bl5);
            object2 = SortArrowIcon.getIcon(bl4 ? SortArrowIcon.Direction.UP : SortArrowIcon.Direction.DOWN, n3);
            jLabel.setIconTextGap(((SortArrowIcon)object2).getIconWidth() / 2);
            jLabel.setIcon((Icon)object2);
        } else {
            jLabel.setIconTextGap(0);
            jLabel.setIcon(null);
        }
        if (string2 == null) {
            jLabel.setToolTipText(string);
        } else {
            serializable2 = new StringBuilder(string.length() + 20);
            ((StringBuilder)serializable2).append("<html><code>");
            if (this.showBoldHeader) {
                ((StringBuilder)serializable2).append("<b>");
            }
            if (this.showTableInComment && string6 != null) {
                ((StringBuilder)serializable2).append(string6);
                ((StringBuilder)serializable2).append('.');
            }
            ((StringBuilder)serializable2).append(string);
            if (this.showBoldHeader) {
                ((StringBuilder)serializable2).append("</b>");
            }
            ((StringBuilder)serializable2).append("</code><br>");
            ((StringBuilder)serializable2).append(string2);
            if (StringUtil.isNonBlank(string4)) {
                ((StringBuilder)serializable2).append("<br>\"<i>");
                ((StringBuilder)serializable2).append(string4);
                ((StringBuilder)serializable2).append("</i>\"");
            }
            if (this.showFullTypeInfo) {
                ((StringBuilder)serializable2).append("<br><tt>");
                ((StringBuilder)serializable2).append(jTable.getColumnClass(n2).getName());
                ((StringBuilder)serializable2).append("<br>");
                ((StringBuilder)serializable2).append(n4);
                ((StringBuilder)serializable2).append('/');
                ((StringBuilder)serializable2).append(string3);
                ((StringBuilder)serializable2).append("</tt>");
            }
            ((StringBuilder)serializable2).append("</html>");
            jLabel.setToolTipText(((StringBuilder)serializable2).toString());
        }
        return jLabel;
    }

    public static int getArrowSize(FontMetrics fontMetrics, boolean bl) {
        if (fontMetrics == null) {
            return bl ? 16 : 8;
        }
        int n = fontMetrics.getHeight();
        if (bl) {
            return (int)((double)n * 0.6);
        }
        return (int)((double)n * 0.5);
    }
}

