/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.settings;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import workbench.interfaces.Restoreable;
import workbench.resource.GuiSettings;
import workbench.resource.ResourceMgr;

public class BookmarkOptionsPanel
extends JPanel
implements Restoreable,
ActionListener {
    private JCheckBox rememberColWidths;
    private JCheckBox rememberSort;
    private JCheckBox useParamNames;
    private JCheckBox useProcs;
    private JCheckBox useResultForBookmark;

    public BookmarkOptionsPanel() {
        this.initComponents();
    }

    @Override
    public void restoreSettings() {
        this.useResultForBookmark.setSelected(GuiSettings.getUseResultTagForBookmarks());
        this.useProcs.setSelected(GuiSettings.getParseProceduresForBookmarks());
        this.rememberColWidths.setSelected(GuiSettings.getSaveBookmarkColWidths());
        this.rememberSort.setSelected(GuiSettings.getSaveBookmarkSort());
        this.useParamNames.setSelected(GuiSettings.getProcBookmarksIncludeParmName());
    }

    @Override
    public void saveSettings() {
        GuiSettings.setUseResultTagForBookmarks(this.useResultForBookmark.isSelected());
        GuiSettings.setSaveBookmarksColWidths(this.rememberColWidths.isSelected());
        GuiSettings.setSaveBookmarksSort(this.rememberSort.isSelected());
        GuiSettings.setParseProceduresForBookmarks(this.useProcs.isSelected());
        GuiSettings.setProcBookmarksIncludeParmName(this.useParamNames.isSelected());
    }

    private void initComponents() {
        this.useResultForBookmark = new JCheckBox();
        this.rememberColWidths = new JCheckBox();
        this.rememberSort = new JCheckBox();
        this.useProcs = new JCheckBox();
        this.useParamNames = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.useResultForBookmark.setText(ResourceMgr.getString("LblBookmarkResultName"));
        this.useResultForBookmark.setToolTipText(ResourceMgr.getString("d_LblBookmarkResultName"));
        this.useResultForBookmark.setBorder(null);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.useResultForBookmark, gridBagConstraints);
        this.rememberColWidths.setText(ResourceMgr.getString("MnuTxtBookmarksSaveWidths"));
        this.rememberColWidths.setToolTipText(ResourceMgr.getString("d_MnuTxtBookmarksSaveWidths"));
        this.rememberColWidths.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.rememberColWidths, gridBagConstraints);
        this.rememberSort.setText(ResourceMgr.getString("MnuTxtRememberSort"));
        this.rememberSort.setToolTipText(ResourceMgr.getString("d_MnuTxtRememberSort"));
        this.rememberSort.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.rememberSort, gridBagConstraints);
        this.useProcs.setText(ResourceMgr.getString("LblBookmarkProcs"));
        this.useProcs.setToolTipText(ResourceMgr.getString("d_MnuTxtRememberSort"));
        this.useProcs.setBorder(null);
        this.useProcs.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.useProcs, gridBagConstraints);
        this.useParamNames.setText(ResourceMgr.getString("LblBookmarkProcsParams"));
        this.useParamNames.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(10, 18, 0, 0);
        this.add((Component)this.useParamNames, gridBagConstraints);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.useProcs) {
            this.useProcsActionPerformed(actionEvent);
        }
    }

    private void useProcsActionPerformed(ActionEvent actionEvent) {
        this.useParamNames.setEnabled(this.useProcs.isSelected());
    }
}

