/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.settings;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import workbench.gui.dbobjects.objecttree.DbTreeSettings;
import workbench.gui.dbobjects.objecttree.TreePosition;
import workbench.interfaces.Restoreable;
import workbench.resource.ResourceMgr;

public class DbTreeOptionsPanel
extends JPanel
implements Restoreable,
ActionListener {
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JCheckBox searchAsYouType;
    private JComboBox<String> treePosition;
    private JCheckBox useTabConnection;

    public DbTreeOptionsPanel() {
        this.initComponents();
        String[] stringArray = new String[]{ResourceMgr.getString("TxtTabLeft"), ResourceMgr.getString("TxtTabRight")};
        this.treePosition.setModel(new DefaultComboBoxModel<String>(stringArray));
    }

    @Override
    public void restoreSettings() {
        this.useTabConnection.setSelected(DbTreeSettings.useTabConnection());
        this.searchAsYouType.setSelected(DbTreeSettings.getFilterWhileTyping());
        TreePosition treePosition = DbTreeSettings.getDbTreePosition();
        switch (treePosition) {
            case left: {
                this.treePosition.setSelectedIndex(0);
                break;
            }
            case right: {
                this.treePosition.setSelectedIndex(1);
            }
        }
    }

    @Override
    public void saveSettings() {
        DbTreeSettings.setUseTabConnection(this.useTabConnection.isSelected());
        DbTreeSettings.setFilterWhileTyping(this.searchAsYouType.isSelected());
        int n = this.treePosition.getSelectedIndex();
        switch (n) {
            case 0: {
                DbTreeSettings.setDbTreePosition(TreePosition.left);
                break;
            }
            case 1: {
                DbTreeSettings.setDbTreePosition(TreePosition.right);
            }
        }
    }

    private void initComponents() {
        this.useTabConnection = new JCheckBox();
        this.searchAsYouType = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.treePosition = new JComboBox();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.useTabConnection.setText(ResourceMgr.getString("LblTreeUseTabConnection"));
        this.useTabConnection.setToolTipText(ResourceMgr.getString("LblTreeUseTabConnection"));
        this.useTabConnection.setBorder(null);
        this.useTabConnection.addActionListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.useTabConnection, gridBagConstraints);
        this.searchAsYouType.setText(ResourceMgr.getString("LblTreeQuickFilter"));
        this.searchAsYouType.setToolTipText(ResourceMgr.getString("d_LblTreeQuickFilter"));
        this.searchAsYouType.setBorder(null);
        this.searchAsYouType.setHorizontalAlignment(2);
        this.searchAsYouType.setHorizontalTextPosition(4);
        this.searchAsYouType.setIconTextGap(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.add((Component)this.searchAsYouType, gridBagConstraints);
        this.jLabel1.setText(ResourceMgr.getString("LblTreePosition"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 8);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.treePosition.setModel(new DefaultComboBoxModel<String>(new String[]{"Left", "Right"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        this.add(this.treePosition, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.useTabConnection) {
            this.useTabConnectionActionPerformed(actionEvent);
        }
    }

    private void useTabConnectionActionPerformed(ActionEvent actionEvent) {
    }
}

