/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.settings;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import workbench.gui.actions.DeleteListEntryAction;
import workbench.gui.actions.NewListEntryAction;
import workbench.gui.components.DividerBorder;
import workbench.gui.components.WbToolbar;
import workbench.gui.settings.ToolDefinitionPanel;
import workbench.interfaces.FileActions;
import workbench.interfaces.Restoreable;
import workbench.resource.Settings;
import workbench.util.ToolDefinition;

public class ExternalToolsPanel
extends JPanel
implements Restoreable,
ListSelectionListener,
FileActions,
PropertyChangeListener {
    private JList toolList;
    private ToolDefinitionPanel definitionPanel;
    private WbToolbar toolbar;
    private DefaultListModel tools;

    public ExternalToolsPanel() {
        this.setLayout(new BorderLayout());
        this.toolList = new JList();
        this.toolList.setSelectionMode(0);
        this.toolList.setBorder(new EmptyBorder(2, 1, 2, 1));
        JScrollPane jScrollPane = new JScrollPane(this.toolList);
        this.toolbar = new WbToolbar();
        this.toolbar.add(new NewListEntryAction(this));
        this.toolbar.add(new DeleteListEntryAction(this));
        this.toolbar.setBorder(DividerBorder.BOTTOM_DIVIDER);
        this.definitionPanel = new ToolDefinitionPanel();
        this.add((Component)this.toolbar, "North");
        this.add((Component)jScrollPane, "West");
        this.add((Component)this.definitionPanel, "Center");
    }

    @Override
    public void saveSettings() {
        ArrayList<ToolDefinition> arrayList = new ArrayList<ToolDefinition>();
        Enumeration enumeration = this.tools.elements();
        while (enumeration.hasMoreElements()) {
            arrayList.add((ToolDefinition)enumeration.nextElement());
        }
        Settings.getInstance().setExternalTools(arrayList);
    }

    @Override
    public void restoreSettings() {
        this.tools = new DefaultListModel();
        List<ToolDefinition> list = Settings.getInstance().getAllExternalTools();
        for (ToolDefinition toolDefinition : list) {
            this.tools.addElement(toolDefinition);
        }
        this.toolList.setModel(this.tools);
        this.toolList.addListSelectionListener(this);
        this.toolList.setSelectedIndex(0);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        ToolDefinition toolDefinition = (ToolDefinition)this.toolList.getSelectedValue();
        this.definitionPanel.setDefinition(toolDefinition);
    }

    @Override
    public void saveItem() throws Exception {
    }

    @Override
    public void deleteItem() throws Exception {
        int n = this.toolList.getSelectedIndex();
        if (n > -1) {
            this.tools.remove(n);
        }
        if (this.toolList.getModel().getSize() == 0) {
            this.definitionPanel.setDefinition(null);
        }
        this.toolList.repaint();
    }

    @Override
    public void newItem(boolean bl) {
        try {
            ToolDefinition toolDefinition = new ToolDefinition("path_to_program", "commandline parameters", "New Tool");
            this.tools.addElement(toolDefinition);
            this.toolList.setSelectedIndex(this.tools.size() - 1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("name")) {
            this.toolList.repaint();
        }
    }
}

