/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.settings;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.DeleteListEntryAction;
import workbench.gui.actions.NewListEntryAction;
import workbench.gui.actions.WbAction;
import workbench.gui.components.ClassFinderGUI;
import workbench.gui.components.DividerBorder;
import workbench.gui.components.WbToolbar;
import workbench.gui.lnf.LnFDefinition;
import workbench.gui.lnf.LnFManager;
import workbench.gui.settings.LnFDefinitionPanel;
import workbench.interfaces.FileActions;
import workbench.interfaces.Restoreable;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.util.ClassFinder;
import workbench.util.ClassInfo;
import workbench.util.ClasspathUtil;
import workbench.util.WbThread;

public class LnFOptionsPanel
extends JPanel
implements Restoreable,
ListSelectionListener,
FileActions,
PropertyChangeListener {
    private JList lnfList;
    private LnFDefinitionPanel definitionPanel;
    protected LnFManager manager = new LnFManager();
    private WbToolbar toolbar;
    private DeleteListEntryAction deleteEntry = null;

    public LnFOptionsPanel() {
        this.setLayout(new BorderLayout());
        this.lnfList = new JList();
        this.lnfList.setSelectionMode(0);
        this.lnfList.setBorder(new EmptyBorder(2, 1, 2, 1));
        this.lnfList.setMinimumSize(new Dimension(100, 100));
        JScrollPane jScrollPane = new JScrollPane(this.lnfList);
        WbAction wbAction = new WbAction(){

            @Override
            public void executeAction(ActionEvent actionEvent) {
                WbThread wbThread = new WbThread("LnF Searcher"){

                    @Override
                    public void run() {
                        LnFOptionsPanel.this.startLnFSearch();
                    }
                };
                wbThread.start();
            }
        };
        wbAction.setIcon("find-lnf");
        this.deleteEntry = new DeleteListEntryAction(this);
        this.toolbar = new WbToolbar();
        this.toolbar.add(new NewListEntryAction(this));
        this.toolbar.add(wbAction);
        this.toolbar.addSeparator();
        this.toolbar.add(this.deleteEntry);
        this.toolbar.setBorder(DividerBorder.BOTTOM_DIVIDER);
        this.definitionPanel = new LnFDefinitionPanel();
        this.definitionPanel.setPropertyListener(this);
        this.add((Component)jScrollPane, "West");
        this.add((Component)this.toolbar, "North");
        this.add((Component)this.definitionPanel, "Center");
        LnfList lnfList = new LnfList();
        this.lnfList.setModel(lnfList);
        this.lnfList.addListSelectionListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startLnFSearch() {
        try {
            WbSwingUtilities.showWaitCursor(this);
            this.definitionPanel.setStatusMessage(ResourceMgr.getString("TxtSearchingLnF"));
            ClasspathUtil classpathUtil = new ClasspathUtil();
            ClassFinder classFinder = new ClassFinder(LookAndFeel.class);
            List<File> list = classpathUtil.getExtLibs();
            List<ClassInfo> list2 = classFinder.findImplementingClasses(list);
            if (LogMgr.isDebugEnabled()) {
                String string = list2.stream().map(classInfo -> classInfo.toString()).collect(Collectors.joining(","));
                LogMgr.logDebug(new CallerInfo(){}, "Found Look and Feel implementations: " + string);
            }
            WbSwingUtilities.showDefaultCursor(this);
            this.definitionPanel.setStatusMessage("");
            this.addItemFromClasspath(list2);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not read Look and Feel implementations", exception);
        }
        finally {
            this.definitionPanel.setStatusMessage("");
            WbSwingUtilities.showDefaultCursor(this);
        }
    }

    private void addItemFromClasspath(List<ClassInfo> list) {
        List list2;
        List list3 = list.stream().filter(classInfo -> !this.manager.isRegistered(classInfo.getClassName())).collect(Collectors.toList());
        if (LogMgr.isDebugEnabled()) {
            list2 = list3.stream().map(classInfo -> classInfo.toString()).collect(Collectors.joining(","));
            LogMgr.logDebug(new CallerInfo(){}, "Found new Look And Feel implementations: " + (String)((Object)list2));
        }
        if (list3.isEmpty()) {
            WbSwingUtilities.showMessageKey(this, "MsgNoLaF");
        } else {
            list2 = list3.stream().map(classInfo -> classInfo.getClassName()).collect(Collectors.toList());
            String string = ClassFinderGUI.selectEntry(list2, null, "TxtSelectLnF", SwingUtilities.getWindowAncestor(this));
            if (string != null) {
                WbSwingUtilities.invokeLater(() -> {
                    int n = list2.indexOf(string);
                    this.createNewItem((ClassInfo)list3.get(n));
                });
            }
        }
    }

    @Override
    public void saveSettings() {
        this.manager.saveLookAndFeelDefinitions();
    }

    @Override
    public void restoreSettings() {
        LnFDefinition lnFDefinition = this.manager.getCurrentLnF();
        this.lnfList.setSelectedValue(lnFDefinition, true);
        this.definitionPanel.setCurrentLookAndFeeld(lnFDefinition);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        LnFDefinition lnFDefinition = (LnFDefinition)this.lnfList.getSelectedValue();
        this.definitionPanel.setDefinition(lnFDefinition);
        if (lnFDefinition != null) {
            this.deleteEntry.setEnabled(!lnFDefinition.isBuiltIn());
        }
    }

    @Override
    public void saveItem() throws Exception {
    }

    @Override
    public void deleteItem() throws Exception {
        LnFDefinition lnFDefinition = (LnFDefinition)this.lnfList.getSelectedValue();
        int n = this.lnfList.getSelectedIndex();
        if (lnFDefinition != null) {
            this.manager.removeDefinition(lnFDefinition);
        }
        if (this.lnfList.getModel().getSize() == 0) {
            this.definitionPanel.setDefinition(null);
        }
        if (n >= this.lnfList.getModel().getSize()) {
            n = this.lnfList.getModel().getSize() - 1;
        }
        this.lnfList.setSelectedIndex(n);
        this.valueChanged(null);
        this.lnfList.repaint();
    }

    private void createNewItem(ClassInfo classInfo) {
        String string = classInfo.getClassName();
        List<String> list = Collections.singletonList(classInfo.getJarFile().getAbsolutePath());
        LnFDefinition lnFDefinition = new LnFDefinition(string.substring(string.lastIndexOf(46) + 1), string, list);
        int n = this.manager.addDefinition(lnFDefinition);
        this.lnfList.setSelectedIndex(n);
        this.definitionPanel.setDefinition(lnFDefinition);
        this.lnfList.updateUI();
    }

    @Override
    public void newItem(boolean bl) {
        try {
            int n;
            LnFDefinition lnFDefinition = null;
            if (bl) {
                n = this.lnfList.getSelectedIndex();
                LnFDefinition lnFDefinition2 = this.manager.getAvailableLookAndFeels().get(n);
                lnFDefinition = lnFDefinition2.createCopy();
            } else {
                String string = ResourceMgr.getString("TxtLnFSample");
                lnFDefinition = new LnFDefinition(string);
            }
            n = this.manager.addDefinition(lnFDefinition);
            this.lnfList.setSelectedIndex(n);
            this.definitionPanel.setDefinition(lnFDefinition);
            this.lnfList.updateUI();
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error creating new item", exception);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("name")) {
            this.lnfList.repaint();
        }
    }

    private class LnfList
    extends AbstractListModel {
        private LnfList() {
        }

        @Override
        public Object getElementAt(int n) {
            return LnFOptionsPanel.this.manager.getAvailableLookAndFeels().get(n);
        }

        @Override
        public int getSize() {
            return LnFOptionsPanel.this.manager.getAvailableLookAndFeels().size();
        }
    }
}

