/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.settings;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;

public class PlacementChooser
extends JComboBox {
    public static final String PLACEMENT_PROPERTY = "workbench.gui.dbobjects.tabletabs";

    public PlacementChooser() {
        String[] stringArray = new String[]{ResourceMgr.getString("TxtTabTop"), ResourceMgr.getString("TxtTabBottom"), ResourceMgr.getString("TxtTabLeft"), ResourceMgr.getString("TxtTabRight")};
        this.setModel(new DefaultComboBoxModel<String>(stringArray));
    }

    public void showPlacement() {
        String string = PlacementChooser.getPlacementSettingValue();
        if ("top".equals(string)) {
            this.setSelectedIndex(0);
        } else if ("bottom".equals(string)) {
            this.setSelectedIndex(1);
        }
        if ("left".equals(string)) {
            this.setSelectedIndex(2);
        }
        if ("right".equals(string)) {
            this.setSelectedIndex(3);
        }
    }

    private static String getPlacementSettingValue() {
        return Settings.getInstance().getProperty(PLACEMENT_PROPERTY, "top");
    }

    public static int getPlacementLocation() {
        String string = PlacementChooser.getPlacementSettingValue();
        int n = 1;
        if (string.equalsIgnoreCase("top")) {
            n = 1;
        } else if (string.equalsIgnoreCase("left")) {
            n = 2;
        } else if (string.equalsIgnoreCase("right")) {
            n = 4;
        } else if (string.equalsIgnoreCase("bottom")) {
            n = 3;
        }
        return n;
    }

    public void saveSelection() {
        String string = this.getPlacement();
        Settings.getInstance().setProperty(PLACEMENT_PROPERTY, string);
    }

    private String getPlacement() {
        int n = this.getSelectedIndex();
        switch (n) {
            case 0: {
                return "top";
            }
            case 1: {
                return "bottom";
            }
            case 2: {
                return "left";
            }
            case 3: {
                return "right";
            }
        }
        return "top";
    }
}

