/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.settings;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import workbench.gui.components.TextFieldWidthAdjuster;
import workbench.gui.help.HelpManager;
import workbench.gui.settings.DbDelimiter;
import workbench.interfaces.Restoreable;
import workbench.resource.ErrorPromptType;
import workbench.resource.GuiSettings;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;

public class SqlExecOptionsPanel
extends JPanel
implements Restoreable,
ActionListener,
ItemListener {
    private JCheckBox allowEditDuringExec;
    private JLabel altDelimLabel;
    private JTextField alternateDelimiter;
    private JCheckBox alwaysAllowExecSel;
    private JCheckBox autoAdvance;
    private JComboBox cbxDbName;
    private JCheckBox emptyLineDelimiter;
    private JCheckBox hiliteCurrent;
    private JCheckBox hiliteError;
    private JLabel jLabel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JCheckBox jumpToError;
    private JCheckBox keepHilite;
    private JComboBox promptType;
    private JCheckBox showScriptEndTime;
    private JCheckBox showScriptProgress;
    private JCheckBox showStmtEndTime;
    private JCheckBox useCurrentLineStmt;

    public SqlExecOptionsPanel() {
        this.initComponents();
        TextFieldWidthAdjuster textFieldWidthAdjuster = new TextFieldWidthAdjuster();
        textFieldWidthAdjuster.adjustAllFields(this);
    }

    @Override
    public void restoreSettings() {
        String[] stringArray = new String[]{ResourceMgr.getString("LblErrPromptSimplePrompt"), ResourceMgr.getString("LblErrPromptPromptWithErroressage"), ResourceMgr.getString("LblErrPromptPromptWithRetry")};
        this.promptType.setModel(new DefaultComboBoxModel<String>(stringArray));
        DbDelimiter[] dbDelimiterArray = DbDelimiter.getMapping();
        this.cbxDbName.setModel(new DefaultComboBoxModel<DbDelimiter>(dbDelimiterArray));
        DbDelimiter dbDelimiter = (DbDelimiter)this.cbxDbName.getSelectedItem();
        this.alternateDelimiter.setText(dbDelimiter.getDelimiter());
        String string = this.altDelimLabel.getText();
        this.altDelimLabel.setText("<html><u>" + string + "</u></html>");
        this.altDelimLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                HelpManager.showHelpFile("understand-alternate-delim");
            }
        });
        this.useCurrentLineStmt.setSelected(GuiSettings.getUseStatementInCurrentLine());
        this.keepHilite.setSelected(GuiSettings.getKeepCurrentSqlHighlight());
        this.hiliteCurrent.setSelected(Settings.getInstance().getHighlightCurrentStatement());
        this.alwaysAllowExecSel.setSelected(!GuiSettings.getExecuteOnlySelected());
        this.allowEditDuringExec.setSelected(!GuiSettings.getDisableEditorDuringExecution());
        this.emptyLineDelimiter.setSelected(Settings.getInstance().getEmptyLineIsDelimiter());
        this.hiliteError.setSelected(GuiSettings.getHighlightErrorStatement());
        this.jumpToError.setSelected(GuiSettings.jumpToError());
        this.showStmtEndTime.setSelected(GuiSettings.showScriptStmtFinishTime());
        this.showScriptEndTime.setSelected(GuiSettings.showScriptFinishTime());
        this.showScriptProgress.setSelected(GuiSettings.showScriptProgress());
        ErrorPromptType errorPromptType = GuiSettings.getErrorPromptType();
        this.promptType.setSelectedIndex(this.promptTypeToIndex(errorPromptType));
        this.setTypeTooltip();
    }

    @Override
    public void saveSettings() {
        int n;
        Settings settings = Settings.getInstance();
        DbDelimiter dbDelimiter = (DbDelimiter)this.cbxDbName.getSelectedItem();
        dbDelimiter.setDelimiter(this.alternateDelimiter.getText());
        DbDelimiter dbDelimiter2 = (DbDelimiter)this.cbxDbName.getItemAt(0);
        settings.setAlternateDelimiter(dbDelimiter2.getDelimiter());
        for (n = 1; n < this.cbxDbName.getItemCount(); ++n) {
            DbDelimiter dbDelimiter3 = (DbDelimiter)this.cbxDbName.getItemAt(n);
            settings.setDbDelimiter(dbDelimiter3.getDbid(), dbDelimiter3.getDelimiter());
        }
        settings.setAutoJumpNextStatement(this.autoAdvance.isSelected());
        settings.setProperty("workbench.editor.highlightcurrent", this.hiliteCurrent.isSelected());
        settings.setEmptyLineIsDelimiter(this.emptyLineDelimiter.isSelected());
        GuiSettings.setKeepCurrentSqlHighlight(this.keepHilite.isSelected());
        GuiSettings.setExecuteOnlySelected(!this.alwaysAllowExecSel.isSelected());
        GuiSettings.setDisableEditorDuringExecution(!this.allowEditDuringExec.isSelected());
        GuiSettings.setHighlightErrorStatement(this.hiliteError.isSelected());
        GuiSettings.setUseStatementInCurrentLine(this.useCurrentLineStmt.isSelected());
        n = this.promptType.getSelectedIndex();
        GuiSettings.setErrorPromptType(this.indexToPromptType(n));
        GuiSettings.setJumpToError(this.jumpToError.isSelected());
        GuiSettings.setShowScriptFinishTime(this.showScriptEndTime.isSelected());
        GuiSettings.setShowScriptStmtFinishTime(this.showStmtEndTime.isSelected());
        GuiSettings.setShowScriptProgress(this.showScriptProgress.isSelected());
    }

    private void setTypeTooltip() {
        int n = this.promptType.getSelectedIndex();
        ErrorPromptType errorPromptType = this.indexToPromptType(n);
        String string = "LblErrPrompt" + errorPromptType.name();
        String string2 = ResourceMgr.getDescription(string);
        this.promptType.setToolTipText(string2);
    }

    private ErrorPromptType indexToPromptType(int n) {
        switch (n) {
            case 0: {
                return ErrorPromptType.SimplePrompt;
            }
            case 2: {
                return ErrorPromptType.PromptWithRetry;
            }
        }
        return ErrorPromptType.PromptWithErroressage;
    }

    private int promptTypeToIndex(ErrorPromptType errorPromptType) {
        switch (errorPromptType) {
            case SimplePrompt: {
                return 0;
            }
            case PromptWithErroressage: {
                return 1;
            }
            case PromptWithRetry: {
                return 2;
            }
        }
        return 1;
    }

    private void initComponents() {
        this.altDelimLabel = new JLabel();
        this.jPanel2 = new JPanel();
        this.hiliteCurrent = new JCheckBox();
        this.keepHilite = new JCheckBox();
        this.allowEditDuringExec = new JCheckBox();
        this.alwaysAllowExecSel = new JCheckBox();
        this.autoAdvance = new JCheckBox();
        this.emptyLineDelimiter = new JCheckBox();
        this.hiliteError = new JCheckBox();
        this.useCurrentLineStmt = new JCheckBox();
        this.jumpToError = new JCheckBox();
        this.showStmtEndTime = new JCheckBox();
        this.showScriptEndTime = new JCheckBox();
        this.showScriptProgress = new JCheckBox();
        this.jPanel3 = new JPanel();
        this.alternateDelimiter = new JTextField();
        this.cbxDbName = new JComboBox();
        this.jLabel1 = new JLabel();
        this.promptType = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.altDelimLabel.setText(ResourceMgr.getString("LblAltDelimit"));
        this.altDelimLabel.setToolTipText(ResourceMgr.getString("d_LblAltDelimit"));
        this.altDelimLabel.setCursor(new Cursor(12));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.altDelimLabel, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.hiliteCurrent.setText(ResourceMgr.getString("MnuTxtHighlightCurrent"));
        this.hiliteCurrent.setToolTipText(ResourceMgr.getString("d_MnuTxtHighlightCurrent"));
        this.hiliteCurrent.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.hiliteCurrent, gridBagConstraints);
        this.keepHilite.setText(ResourceMgr.getString("LblKeepHilite"));
        this.keepHilite.setToolTipText(ResourceMgr.getString("d_LblKeepHilite"));
        this.keepHilite.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        this.jPanel2.add((Component)this.keepHilite, gridBagConstraints);
        this.allowEditDuringExec.setText(ResourceMgr.getString("LblAllowEditExecSQL"));
        this.allowEditDuringExec.setToolTipText(ResourceMgr.getString("d_LblAllowEditExecSQL"));
        this.allowEditDuringExec.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(7, 15, 0, 0);
        this.jPanel2.add((Component)this.allowEditDuringExec, gridBagConstraints);
        this.alwaysAllowExecSel.setText(ResourceMgr.getString("LblExecSelOnly"));
        this.alwaysAllowExecSel.setToolTipText(ResourceMgr.getString("d_LblExecSelOnly"));
        this.alwaysAllowExecSel.setBorder(null);
        this.alwaysAllowExecSel.setHorizontalAlignment(2);
        this.alwaysAllowExecSel.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 0, 0, 0);
        this.jPanel2.add((Component)this.alwaysAllowExecSel, gridBagConstraints);
        this.autoAdvance.setSelected(Settings.getInstance().getAutoJumpNextStatement());
        this.autoAdvance.setText(ResourceMgr.getString("LblAutoAdvance"));
        this.autoAdvance.setToolTipText(ResourceMgr.getString("d_LblAutoAdvance"));
        this.autoAdvance.setBorder(null);
        this.autoAdvance.setHorizontalAlignment(2);
        this.autoAdvance.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 15, 0, 0);
        this.jPanel2.add((Component)this.autoAdvance, gridBagConstraints);
        this.emptyLineDelimiter.setText(ResourceMgr.getString("LblEmptyLineDelimiter"));
        this.emptyLineDelimiter.setToolTipText(ResourceMgr.getString("d_LblEmptyLineDelimiter"));
        this.emptyLineDelimiter.setBorder(null);
        this.emptyLineDelimiter.setHorizontalAlignment(2);
        this.emptyLineDelimiter.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 15, 0, 0);
        this.jPanel2.add((Component)this.emptyLineDelimiter, gridBagConstraints);
        this.hiliteError.setText(ResourceMgr.getString("LblHiliteErr"));
        this.hiliteError.setToolTipText(ResourceMgr.getString("d_LblHiliteErr"));
        this.hiliteError.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(7, 0, 0, 0);
        this.jPanel2.add((Component)this.hiliteError, gridBagConstraints);
        this.useCurrentLineStmt.setText(ResourceMgr.getString("LblUseStmtInCurLine"));
        this.useCurrentLineStmt.setToolTipText(ResourceMgr.getString("d_LblUseStmtInCurLine"));
        this.useCurrentLineStmt.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(7, 15, 0, 0);
        this.jPanel2.add((Component)this.useCurrentLineStmt, gridBagConstraints);
        this.jumpToError.setText(ResourceMgr.getString("LblJumpToError"));
        this.jumpToError.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(7, 0, 0, 0);
        this.jPanel2.add((Component)this.jumpToError, gridBagConstraints);
        this.showStmtEndTime.setText(ResourceMgr.getString("LblShowStmtEndTime"));
        this.showStmtEndTime.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 0, 0, 0);
        this.jPanel2.add((Component)this.showStmtEndTime, gridBagConstraints);
        this.showScriptEndTime.setText(ResourceMgr.getString("LblShowScriptEndTime"));
        this.showScriptEndTime.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 0, 0, 0);
        this.jPanel2.add((Component)this.showScriptEndTime, gridBagConstraints);
        this.showScriptProgress.setText(ResourceMgr.getString("LblShowScriptProgress"));
        this.showScriptProgress.setToolTipText(ResourceMgr.getString("d_LblShowScriptProgress"));
        this.showScriptProgress.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(7, 15, 0, 0);
        this.jPanel2.add((Component)this.showScriptProgress, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(13, 0, 0, 0);
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.alternateDelimiter.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 7, 0, 15);
        this.jPanel3.add((Component)this.alternateDelimiter, gridBagConstraints);
        this.cbxDbName.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbxDbName.addItemListener(this);
        this.cbxDbName.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.jPanel3.add((Component)this.cbxDbName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 11, 0, 0);
        this.add((Component)this.jPanel3, gridBagConstraints);
        this.jLabel1.setText(ResourceMgr.getString("LblErrPromptType"));
        this.jLabel1.setToolTipText(ResourceMgr.getString("d_LblErrPromptType"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.promptType.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.promptType.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(1, 11, 0, 0);
        this.add((Component)this.promptType, gridBagConstraints);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.cbxDbName) {
            this.cbxDbNameActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.promptType) {
            this.promptTypeActionPerformed(actionEvent);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.cbxDbName) {
            this.cbxDbNameItemStateChanged(itemEvent);
        }
    }

    private void cbxDbNameActionPerformed(ActionEvent actionEvent) {
        DbDelimiter dbDelimiter = (DbDelimiter)this.cbxDbName.getSelectedItem();
        this.alternateDelimiter.setText(dbDelimiter.getDelimiter());
    }

    private void cbxDbNameItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 2) {
            DbDelimiter dbDelimiter = (DbDelimiter)itemEvent.getItem();
            dbDelimiter.setDelimiter(this.alternateDelimiter.getText());
        }
    }

    private void promptTypeActionPerformed(ActionEvent actionEvent) {
        this.setTypeTooltip();
    }
}

