/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.sql;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.Timer;
import workbench.db.KeepAliveDaemon;
import workbench.gui.PanelReloader;
import workbench.gui.components.CompoundIcon;
import workbench.gui.sql.DwPanel;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.IconMgr;
import workbench.util.StringUtil;

public class AutomaticRefreshMgr
implements ActionListener {
    private List<PanelEntry> panels = new ArrayList<PanelEntry>();

    public synchronized void removeRefresh(DwPanel dwPanel) {
        if (dwPanel == null) {
            return;
        }
        int n = dwPanel.getId();
        int n2 = this.getIndexForId(n);
        this.removePanel(n2);
    }

    public synchronized void clear() {
        for (PanelEntry panelEntry : this.panels) {
            this.disposePanel(panelEntry);
        }
        this.panels.clear();
    }

    public int getRefreshPeriod(DwPanel dwPanel) {
        if (dwPanel == null) {
            return -1;
        }
        int n = this.getIndexForId(dwPanel.getId());
        if (n < 0) {
            return -1;
        }
        PanelEntry panelEntry = this.panels.get(n);
        if (panelEntry == null || panelEntry.panel.get() == null || panelEntry.timer == null) {
            return -1;
        }
        return panelEntry.timer.getDelay();
    }

    public synchronized boolean isRegistered(DwPanel dwPanel) {
        if (dwPanel == null) {
            return false;
        }
        int n = this.getIndexForId(dwPanel.getId());
        return n > -1;
    }

    public synchronized void addRefresh(PanelReloader panelReloader, DwPanel dwPanel, int n) {
        if (dwPanel == null) {
            return;
        }
        if (n < 5) {
            return;
        }
        this.removeRefresh(dwPanel);
        Timer timer = new Timer(n, this);
        int n2 = dwPanel.getId();
        timer.setActionCommand(Integer.toString(n2));
        timer.setRepeats(true);
        timer.setCoalesce(true);
        PanelEntry panelEntry = new PanelEntry(n2);
        panelEntry.panel = new WeakReference<DwPanel>(dwPanel);
        panelEntry.timer = timer;
        panelEntry.reloader = panelReloader;
        this.panels.add(panelEntry);
        timer.start();
        LogMgr.logDebug(new CallerInfo(){}, "Registered panel: " + dwPanel.getName() + ", id=" + n2 + ", interval=" + KeepAliveDaemon.getTimeDisplay(n));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        int n = StringUtil.getIntValue(string, -1);
        PanelEntry panelEntry = this.findEntry(n);
        if (panelEntry == null) {
            return;
        }
        if (panelEntry.reloader == null) {
            return;
        }
        DwPanel dwPanel = (DwPanel)panelEntry.panel.get();
        if (dwPanel == null) {
            LogMgr.logWarning(new CallerInfo(){}, "Panel with id=" + n + " is no longer valid");
            int n2 = this.getIndexForId(n);
            this.removePanel(n2);
        } else {
            LogMgr.logDebug(new CallerInfo(){}, "Refreshing panel id=" + n);
            panelEntry.reloader.startReloadPanel(dwPanel);
        }
    }

    public Icon getTabIcon(Icon icon, DwPanel dwPanel) {
        CompoundIcon compoundIcon;
        ImageIcon imageIcon = IconMgr.getInstance().getLabelIcon("auto_refresh");
        int n = imageIcon.getIconWidth() / 5;
        if (this.isRegistered(dwPanel)) {
            if (icon == null || icon == imageIcon) {
                return imageIcon;
            }
            if (icon instanceof CompoundIcon) {
                CompoundIcon compoundIcon2 = (CompoundIcon)icon;
                if (compoundIcon2.contains(imageIcon)) {
                    return compoundIcon2;
                }
                return new CompoundIcon(CompoundIcon.Axis.X_AXIS, n, compoundIcon2, (Icon)imageIcon);
            }
            return new CompoundIcon(CompoundIcon.Axis.X_AXIS, n, icon, imageIcon);
        }
        if (icon == null || icon == imageIcon) {
            return null;
        }
        if (icon instanceof CompoundIcon && (compoundIcon = (CompoundIcon)icon).contains(imageIcon)) {
            return compoundIcon.getIcon(0);
        }
        return icon;
    }

    public static int parseInterval(String string) {
        if (StringUtil.isBlank(string)) {
            return 0;
        }
        int n = StringUtil.getIntValue(string, Integer.MIN_VALUE);
        n = n > 0 ? (n *= 1000) : (int)KeepAliveDaemon.parseTimeInterval(string);
        return n;
    }

    private synchronized void removePanel(int n) {
        if (n < 0 || n >= this.panels.size()) {
            return;
        }
        PanelEntry panelEntry = this.panels.get(n);
        this.disposePanel(panelEntry);
        this.panels.remove(n);
    }

    private void disposePanel(PanelEntry panelEntry) {
        if (panelEntry == null) {
            return;
        }
        if (panelEntry.timer != null) {
            panelEntry.timer.stop();
            panelEntry.timer.removeActionListener(this);
        }
        panelEntry.timer = null;
        panelEntry.panel = null;
        LogMgr.logDebug(new CallerInfo(){}, "Un-Registered panel with id:" + panelEntry.panelId);
    }

    private PanelEntry findEntry(int n) {
        int n2 = this.getIndexForId(n);
        if (n2 < 0) {
            return null;
        }
        PanelEntry panelEntry = this.panels.get(n2);
        return panelEntry;
    }

    private int getIndexForId(int n) {
        for (int i = 0; i < this.panels.size(); ++i) {
            PanelEntry panelEntry = this.panels.get(i);
            if (panelEntry == null || panelEntry.panelId != n) continue;
            return i;
        }
        return -1;
    }

    private static class PanelEntry {
        WeakReference<DwPanel> panel;
        Timer timer;
        final int panelId;
        int numRepeats;
        PanelReloader reloader;

        PanelEntry(int n) {
            this.panelId = n;
        }
    }
}

