/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.sql;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.StringWriter;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import workbench.console.DataStorePrinter;
import workbench.console.TextPrinter;
import workbench.gui.components.WbButton;
import workbench.gui.sql.RecordFormPanel;
import workbench.resource.IconMgr;
import workbench.resource.ResourceMgr;
import workbench.storage.DataStore;
import workbench.storage.RowData;
import workbench.util.StringUtil;

public class FormNavigation
extends JPanel
implements ActionListener,
AdjustmentListener {
    private RecordFormPanel display;
    private JTextField currentRow = new JTextField(4);
    private JScrollBar scrollBar;
    private JButton copyButton;

    public FormNavigation(RecordFormPanel recordFormPanel) {
        super(new BorderLayout());
        this.display = recordFormPanel;
        int n = IconMgr.getInstance().getSizeForLabel();
        this.setBorder(new EmptyBorder(n, 0, n, 0));
        this.scrollBar = new JScrollBar(0, this.display.getCurrentRow(), 1, 0, this.display.getRowCount());
        this.scrollBar.setBlockIncrement(10);
        this.scrollBar.addAdjustmentListener(this);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        jPanel.add((Component)new JLabel(ResourceMgr.getString("TxtRow")), gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.currentRow, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)new JLabel(ResourceMgr.getString("TxtOf") + " " + this.display.getRowCount()), gridBagConstraints);
        this.copyButton = new WbButton(ResourceMgr.getString("MnuTxtCopy"));
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)this.copyButton, gridBagConstraints);
        this.copyButton.addActionListener(this);
        this.add((Component)jPanel, "South");
        this.add((Component)this.scrollBar, "North");
        this.currentRow.addActionListener(this);
        this.updateStatus();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this) {
            int n = StringUtil.getIntValue(this.currentRow.getText(), -1);
            if (n > 0 && n <= this.display.getRowCount() && this.changeRow(n - 1)) {
                try {
                    this.scrollBar.setValueIsAdjusting(true);
                    this.scrollBar.setValue(this.display.getCurrentRow());
                }
                finally {
                    this.scrollBar.setValueIsAdjusting(false);
                }
            }
            this.updateStatus();
        }
        if (actionEvent.getSource() == this.copyButton) {
            this.copyToClipboard();
        }
    }

    private void copyToClipboard() {
        DataStore dataStore = this.display.getDataStore();
        DataStorePrinter dataStorePrinter = new DataStorePrinter(dataStore);
        StringWriter stringWriter = new StringWriter();
        TextPrinter textPrinter = TextPrinter.createPrinter(stringWriter);
        RowData rowData = dataStore.getRow(this.display.getCurrentRow());
        dataStorePrinter.printAsRecord(textPrinter, rowData, this.display.getCurrentRow());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(stringWriter.toString());
        clipboard.setContents(stringSelection, stringSelection);
    }

    private boolean changeRow(int n) {
        if (this.display.validateInput()) {
            this.display.showRecord(n);
            return true;
        }
        return false;
    }

    private void updateStatus() {
        this.currentRow.setText(Integer.toString(this.display.getCurrentRow() + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        int n = adjustmentEvent.getValue();
        int n2 = this.display.getCurrentRow();
        if (this.changeRow(n)) {
            this.updateStatus();
        } else {
            try {
                this.scrollBar.setValueIsAdjusting(true);
                this.scrollBar.setValue(n2);
            }
            finally {
                this.scrollBar.setValueIsAdjusting(false);
            }
        }
    }
}

