/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.sql;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import workbench.gui.actions.ClearStatementHistoryAction;
import workbench.gui.actions.FirstStatementAction;
import workbench.gui.actions.LastStatementAction;
import workbench.gui.actions.NextStatementAction;
import workbench.gui.actions.PrevStatementAction;
import workbench.gui.actions.WbAction;
import workbench.gui.sql.EditorPanel;
import workbench.gui.sql.SqlHistoryEntry;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.util.EncodingUtil;
import workbench.util.StringUtil;

public class SqlHistory {
    private static final String LIST_DELIMITER = "----------- WbStatement -----------";
    private final List<SqlHistoryEntry> history;
    private int currentEntry;
    private int maxSize;
    private boolean changed;
    private EditorPanel editor;
    private NextStatementAction nextStmtAction;
    private PrevStatementAction prevStmtAction;
    private FirstStatementAction firstStmtAction;
    private LastStatementAction lastStmtAction;
    private ClearStatementHistoryAction clearAction;
    private static final String KEY_POS = "##sqlwb.pos=";
    private static final String KEY_START = "##sqlwb.selStart=";
    private static final String KEY_END = "##sqlwb.selEnd=";

    public SqlHistory(EditorPanel editorPanel, int n) {
        this.maxSize = n;
        this.history = new ArrayList<SqlHistoryEntry>(n + 2);
        this.editor = editorPanel;
        this.firstStmtAction = new FirstStatementAction(this);
        this.firstStmtAction.setEnabled(false);
        this.prevStmtAction = new PrevStatementAction(this);
        this.prevStmtAction.setEnabled(false);
        this.nextStmtAction = new NextStatementAction(this);
        this.nextStmtAction.setEnabled(false);
        this.lastStmtAction = new LastStatementAction(this);
        this.lastStmtAction.setEnabled(false);
        this.clearAction = new ClearStatementHistoryAction(this);
        this.clearAction.setEnabled(false);
    }

    public synchronized void setEnabled(boolean bl) {
        this.nextStmtAction.setEnabled(bl);
        this.prevStmtAction.setEnabled(bl);
        this.firstStmtAction.setEnabled(bl);
        this.lastStmtAction.setEnabled(bl);
    }

    public WbAction getShowFirstStatementAction() {
        return this.firstStmtAction;
    }

    public WbAction getShowLastStatementAction() {
        return this.lastStmtAction;
    }

    public WbAction getShowNextStatementAction() {
        return this.nextStmtAction;
    }

    public WbAction getShowPreviousStatementAction() {
        return this.prevStmtAction;
    }

    public WbAction getClearHistoryAction() {
        return this.clearAction;
    }

    public synchronized void replaceHistory(List<SqlHistoryEntry> list) {
        this.clear();
        this.history.addAll(list);
        this.showLastStatement();
    }

    public synchronized void addContent(EditorPanel editorPanel) {
        boolean bl = Settings.getInstance().getStoreFilesInHistory();
        if (!bl && editorPanel.hasFileLoaded()) {
            return;
        }
        int n = Settings.getInstance().getIntProperty("workbench.sql.history.maxtextlength", 0xA00000);
        if (editorPanel.getDocumentLength() > n) {
            return;
        }
        String string = editorPanel.getText();
        if (string == null || string.length() == 0) {
            return;
        }
        try {
            SqlHistoryEntry sqlHistoryEntry = null;
            sqlHistoryEntry = editorPanel.currentSelectionIsTemporary() ? new SqlHistoryEntry(string, editorPanel.getCaretPosition(), 0, 0) : new SqlHistoryEntry(string, editorPanel.getCaretPosition(), editorPanel.getSelectionStart(), editorPanel.getSelectionEnd());
            SqlHistoryEntry sqlHistoryEntry2 = this.getTopEntry();
            if (sqlHistoryEntry2 != null && sqlHistoryEntry2.equals(sqlHistoryEntry)) {
                return;
            }
            this.addEntry(sqlHistoryEntry);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not add entry", exception);
        }
        this.checkActions();
    }

    public void addEntry(SqlHistoryEntry sqlHistoryEntry) {
        this.history.add(sqlHistoryEntry);
        if (this.history.size() > this.maxSize) {
            this.history.remove(0);
        }
        this.currentEntry = this.history.size() - 1;
        this.changed = true;
    }

    public boolean hasNext() {
        return this.currentEntry < this.history.size() - 1;
    }

    public boolean hasPrevious() {
        return this.currentEntry > 0;
    }

    public void clear() {
        this.currentEntry = 0;
        this.history.clear();
        this.changed = false;
        this.checkActions();
    }

    public void dispose() {
        this.clear();
        WbAction.dispose(this.nextStmtAction, this.prevStmtAction, this.firstStmtAction, this.lastStmtAction, this.clearAction);
    }

    public void showLastStatement() {
        if (this.history.isEmpty()) {
            return;
        }
        if (!this.editor.isEditable()) {
            return;
        }
        this.currentEntry = this.history.size() - 1;
        SqlHistoryEntry sqlHistoryEntry = this.history.get(this.currentEntry);
        sqlHistoryEntry.applyTo(this.editor);
        this.checkActions();
    }

    public void showFirstStatement() {
        if (this.history.isEmpty()) {
            return;
        }
        if (!this.editor.isEditable()) {
            return;
        }
        this.currentEntry = 0;
        SqlHistoryEntry sqlHistoryEntry = this.history.get(this.currentEntry);
        sqlHistoryEntry.applyTo(this.editor);
        this.checkActions();
    }

    public void showCurrent() {
        if (this.currentEntry >= this.history.size()) {
            return;
        }
        if (!this.editor.isEditable()) {
            return;
        }
        SqlHistoryEntry sqlHistoryEntry = this.history.get(this.currentEntry);
        sqlHistoryEntry.applyTo(this.editor, true);
        this.checkActions();
    }

    public void showPreviousStatement() {
        if (!this.hasPrevious()) {
            return;
        }
        if (!this.editor.isEditable()) {
            return;
        }
        SqlHistoryEntry sqlHistoryEntry = this.getPreviousEntry();
        sqlHistoryEntry.applyTo(this.editor);
        this.checkActions();
    }

    public void showNextStatement() {
        if (!this.hasNext()) {
            return;
        }
        SqlHistoryEntry sqlHistoryEntry = this.getNextEntry();
        sqlHistoryEntry.applyTo(this.editor);
        this.checkActions();
    }

    public SqlHistoryEntry getTopEntry() {
        if (this.history.size() < 1) {
            return null;
        }
        SqlHistoryEntry sqlHistoryEntry = this.history.get(this.history.size() - 1);
        return sqlHistoryEntry;
    }

    private SqlHistoryEntry getPreviousEntry() {
        if (this.currentEntry <= 0) {
            return null;
        }
        --this.currentEntry;
        SqlHistoryEntry sqlHistoryEntry = this.history.get(this.currentEntry);
        return sqlHistoryEntry;
    }

    private SqlHistoryEntry getNextEntry() {
        if (this.currentEntry >= this.history.size() - 1) {
            return null;
        }
        ++this.currentEntry;
        SqlHistoryEntry sqlHistoryEntry = this.history.get(this.currentEntry);
        return sqlHistoryEntry;
    }

    public void writeToStream(OutputStream outputStream) {
        String string = "\n";
        try {
            Writer writer = EncodingUtil.createWriter(outputStream, "UTF-8");
            int n = this.history.size();
            for (int i = 0; i < n; ++i) {
                SqlHistoryEntry sqlHistoryEntry = this.history.get(i);
                writer.write(KEY_POS);
                writer.write(Integer.toString(sqlHistoryEntry.getCursorPosition()));
                writer.write(string);
                writer.write(KEY_START);
                writer.write(Integer.toString(sqlHistoryEntry.getSelectionStart()));
                writer.write(string);
                writer.write(KEY_END);
                writer.write(Integer.toString(sqlHistoryEntry.getSelectionEnd()));
                writer.write(string);
                BufferedReader bufferedReader = new BufferedReader(new StringReader(sqlHistoryEntry.getText()));
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    int n2 = StringUtil.getRealLineLength(string2);
                    if (n2 > 0) {
                        writer.write(string2.substring(0, n2));
                    }
                    writer.write(string);
                    string2 = bufferedReader.readLine();
                }
                writer.write(LIST_DELIMITER);
                writer.write(string);
            }
            writer.flush();
            this.changed = false;
        }
        catch (IOException iOException) {
            LogMgr.logError(new CallerInfo(){}, "Could not write history!", iOException);
        }
    }

    public List<SqlHistoryEntry> getEntries() {
        return new ArrayList<SqlHistoryEntry>(this.history);
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void readFromStream(InputStream inputStream) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder(500);
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        String string = "\n";
        try {
            object = new BufferedReader(EncodingUtil.createReader(inputStream, "UTF-8"));
            Throwable throwable = null;
            try {
                String string2 = ((BufferedReader)object).readLine();
                while (string2 != null) {
                    if (string2.equals(LIST_DELIMITER)) {
                        try {
                            SqlHistoryEntry sqlHistoryEntry = new SqlHistoryEntry(stringBuilder.toString(), n, n2, n3);
                            this.addEntry(sqlHistoryEntry);
                            n = 0;
                            n2 = -1;
                            n3 = -1;
                            stringBuilder = new StringBuilder(500);
                        }
                        catch (Exception exception) {
                            LogMgr.logError(new CallerInfo(){}, "Error when creating SqlHistoryEntry", exception);
                        }
                    } else if (string2.startsWith(KEY_POS)) {
                        n = StringUtil.getIntValue(string2.substring(KEY_POS.length()), -1);
                    } else if (string2.startsWith(KEY_START)) {
                        n2 = StringUtil.getIntValue(string2.substring(KEY_START.length()), -1);
                    } else if (string2.startsWith(KEY_END)) {
                        n3 = StringUtil.getIntValue(string2.substring(KEY_END.length()), -1);
                    } else {
                        int n4 = StringUtil.getRealLineLength(string2);
                        if (n4 > 0) {
                            stringBuilder.append(string2, 0, n4);
                        }
                        stringBuilder.append(string);
                    }
                    string2 = ((BufferedReader)object).readLine();
                }
                this.changed = false;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((BufferedReader)object).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((BufferedReader)object).close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            LogMgr.logError(new CallerInfo(){}, "Could not read history!", iOException);
        }
        if (stringBuilder.length() > 0) {
            object = new SqlHistoryEntry(stringBuilder.toString(), n, n2, n3);
            this.addEntry((SqlHistoryEntry)object);
        }
    }

    private void checkActions() {
        this.nextStmtAction.setEnabled(this.hasNext());
        this.lastStmtAction.setEnabled(this.hasNext());
        this.prevStmtAction.setEnabled(this.hasPrevious());
        this.firstStmtAction.setEnabled(this.hasPrevious());
        this.clearAction.setEnabled(this.history.size() > 0);
    }
}

