/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.sql;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.table.TableCellEditor;
import workbench.WbManager;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.ColumnWidthOptimizer;
import workbench.gui.components.DataStoreTableModel;
import workbench.gui.components.ValidatingDialog;
import workbench.gui.components.WbTable;
import workbench.gui.components.WbTextCellEditor;
import workbench.gui.renderer.RendererSetup;
import workbench.gui.sql.VariablesTable;
import workbench.interfaces.ValidatingComponent;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.sql.VariablePool;
import workbench.storage.DataStore;

public class VariablesEditor
extends JPanel
implements ValidatingComponent {
    private DataStore varData;
    private WbTable variablesTable;
    private ValidatingDialog dialog;
    private boolean autoAdvance = Settings.getInstance().getBoolProperty("workbench.gui.variables.editor.autoadvance", true);
    private boolean autoCloseOnAdvance = Settings.getInstance().getBoolProperty("workbench.gui.variables.editor.autoclose", this.autoAdvance);
    private static boolean dialogResult;

    public VariablesEditor(DataStore dataStore) {
        this.variablesTable = new VariablesTable(){

            @Override
            public void userStoppedEditing(int n) {
                if (VariablesEditor.this.autoAdvance) {
                    VariablesEditor.this.closeOrAdvance(n);
                }
            }
        };
        this.variablesTable.setRendererSetup(new RendererSetup(false));
        this.variablesTable.setRowSelectionAllowed(false);
        this.variablesTable.setColumnSelectionAllowed(false);
        this.varData = dataStore;
        DataStoreTableModel dataStoreTableModel = new DataStoreTableModel(dataStore);
        dataStoreTableModel.setLockedColumn(0);
        this.variablesTable.setModel(dataStoreTableModel);
        this.variablesTable.setAutoResizeMode(0);
        JLabel jLabel = new JLabel(ResourceMgr.getString("TxtVariableInputText"));
        Border border = BorderFactory.createEmptyBorder(5, 2, 5, 2);
        jLabel.setBorder(border);
        jLabel.setBackground(Color.WHITE);
        jLabel.setOpaque(true);
        jLabel.setHorizontalAlignment(0);
        this.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.variablesTable);
        border = BorderFactory.createEmptyBorder(5, 0, 0, 0);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(border, jScrollPane.getBorder());
        jScrollPane.setBorder(compoundBorder);
        this.add((Component)jLabel, "North");
        this.add((Component)jScrollPane, "Center");
    }

    private void closeOrAdvance(int n) {
        if (n == this.variablesTable.getRowCount() - 1 && this.autoCloseOnAdvance) {
            this.dialog.approveAndClose();
        } else if (n >= 0) {
            EventQueue.invokeLater(() -> this.startEditRow(n + 1));
        }
    }

    @Override
    public void componentWillBeClosed() {
    }

    @Override
    public void componentDisplayed() {
        this.startEditRow(0);
    }

    private void startEditRow(int n) {
        this.variablesTable.setColumnSelectionInterval(1, 1);
        this.variablesTable.editCellAt(n, 1);
        TableCellEditor tableCellEditor = this.variablesTable.getCellEditor();
        if (tableCellEditor instanceof WbTextCellEditor) {
            WbTextCellEditor wbTextCellEditor = (WbTextCellEditor)tableCellEditor;
            wbTextCellEditor.selectAll();
            wbTextCellEditor.requestFocus();
        }
    }

    @Override
    public boolean validateInput() {
        this.variablesTable.stopEditing();
        int n = this.varData.getRowCount();
        for (int i = 0; i < n; ++i) {
            String string = this.varData.getValueAsString(i, 0);
            if (VariablePool.getInstance().isValidVariableName(string)) continue;
            String string2 = ResourceMgr.getString("ErrIllegalVariableName");
            string2 = string2.replace("%varname%", string);
            string2 = string2 + "\n" + ResourceMgr.getString("ErrVarDefWrongName");
            WbSwingUtilities.showErrorMessage(this, string2);
            return false;
        }
        return true;
    }

    public static boolean showVariablesDialog(DataStore dataStore) {
        WbSwingUtilities.invoke(() -> {
            VariablesEditor variablesEditor = new VariablesEditor(dataStore);
            String string = "workbench.gui.variables.dialog";
            JFrame jFrame = WbManager.getInstance().getCurrentWindow();
            variablesEditor.dialog = ValidatingDialog.createDialog(jFrame, variablesEditor, ResourceMgr.getString("TxtEditVariablesWindowTitle"), null, 0, false);
            int n = -1;
            if (Settings.getInstance().restoreWindowSize(variablesEditor.dialog, string)) {
                variablesEditor.dialog.setLocationRelativeTo(jFrame);
                n = (int)((double)variablesEditor.dialog.getWidth() * 0.92);
            } else {
                n = (int)(variablesEditor.dialog.getPreferredSize().getWidth() * 0.92);
            }
            ColumnWidthOptimizer columnWidthOptimizer = new ColumnWidthOptimizer(variablesEditor.variablesTable);
            columnWidthOptimizer.optimizeColWidth(0, true);
            int n2 = variablesEditor.variablesTable.getColumnModel().getColumn(0).getWidth();
            int n3 = n - n2;
            variablesEditor.variablesTable.getColumnModel().getColumn(1).setPreferredWidth(n3);
            variablesEditor.dialog.setVisible(true);
            dialogResult = !variablesEditor.dialog.isCancelled();
            Settings.getInstance().storeWindowSize(variablesEditor.dialog, string);
        });
        boolean bl = false;
        if (dialogResult) {
            try {
                dataStore.updateDb(null, null);
                bl = true;
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Error when saving values", exception);
                bl = false;
            }
        }
        return bl;
    }
}

