/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.tools;

import java.util.Arrays;
import java.util.Comparator;
import javax.swing.table.AbstractTableModel;
import workbench.db.ColumnIdentifier;
import workbench.gui.tools.ColumnMapRow;
import workbench.gui.tools.ColumnMapper;
import workbench.gui.tools.SkipColumnIndicator;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.util.StringUtil;

class MapDataModel
extends AbstractTableModel {
    private boolean allowTargetEditing = false;
    private ColumnMapRow[] data;
    private final String sourceColName = ResourceMgr.getString("LblSourceColumn");
    private final String targetColName = ResourceMgr.getString("LblTargetColumn");

    MapDataModel(ColumnMapRow[] columnMapRowArray) {
        this.data = columnMapRowArray;
    }

    public Class getColumnClass(int n) {
        if (n == 2) {
            return Boolean.class;
        }
        return ColumnIdentifier.class;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return this.sourceColName;
            }
            case 1: {
                return this.targetColName;
            }
            case 2: {
                return ResourceMgr.getString("LblDPKeyColumnTitle");
            }
        }
        return "";
    }

    @Override
    public int getRowCount() {
        return this.data.length;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        ColumnMapRow columnMapRow = this.data[n];
        if (columnMapRow == null) {
            return "(error)";
        }
        Object object = null;
        switch (n2) {
            case 0: {
                object = columnMapRow.getSource();
                if (object != null) break;
                object = ColumnMapper.SKIP_COLUMN;
                break;
            }
            case 1: {
                object = columnMapRow.getTarget();
                break;
            }
            case 2: {
                boolean bl;
                ColumnIdentifier columnIdentifier = columnMapRow.getTarget();
                object = columnIdentifier == null ? Boolean.FALSE : ((bl = columnIdentifier.isPkColumn()) ? Boolean.TRUE : Boolean.FALSE);
            }
        }
        return object;
    }

    public void setAllowTargetEditing(boolean bl) {
        this.allowTargetEditing = bl;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (n < 0 || n > this.getRowCount() - 1) {
            return false;
        }
        if (n2 == 0) {
            return true;
        }
        if (n2 == 1) {
            if (!this.allowTargetEditing) {
                return false;
            }
            ColumnMapRow columnMapRow = this.data[n];
            return columnMapRow.getSource() != null && this.allowTargetEditing;
        }
        return true;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        ColumnMapRow columnMapRow = this.data[n];
        if (columnMapRow == null) {
            return;
        }
        if (object == null) {
            return;
        }
        switch (n2) {
            case 0: {
                if (object instanceof ColumnIdentifier) {
                    columnMapRow.setSource((ColumnIdentifier)object);
                    break;
                }
                if (object instanceof String) {
                    ColumnIdentifier columnIdentifier = columnMapRow.getSource();
                    String string = (String)object;
                    if (StringUtil.isBlank(string)) break;
                    if (columnIdentifier == null) {
                        columnIdentifier = new ColumnIdentifier();
                    }
                    columnIdentifier.setExpression(string);
                    break;
                }
                if (object instanceof SkipColumnIndicator) {
                    columnMapRow.setSource(null);
                    break;
                }
                LogMgr.logWarning(new CallerInfo(){}, "Unsupported data type " + object.getClass().getName());
                break;
            }
            case 1: {
                if (object instanceof ColumnIdentifier) {
                    columnMapRow.setTarget((ColumnIdentifier)object);
                    break;
                }
                if (this.allowTargetEditing && object instanceof String) {
                    ColumnIdentifier columnIdentifier = new ColumnIdentifier((String)object);
                    columnMapRow.setTarget(columnIdentifier);
                    break;
                }
                LogMgr.logWarning(new CallerInfo(){}, "Unsupported data type " + object.getClass().getName());
                break;
            }
            case 2: {
                if (!(object instanceof Boolean)) break;
                boolean bl = (Boolean)object;
                columnMapRow.getTarget().setIsPkColumn(bl);
            }
        }
    }

    public void sortBySourcePosition() {
        Comparator<ColumnMapRow> comparator = new Comparator<ColumnMapRow>(){

            @Override
            public int compare(ColumnMapRow columnMapRow, ColumnMapRow columnMapRow2) {
                if (columnMapRow == null) {
                    return 1;
                }
                if (columnMapRow2 == null) {
                    return -1;
                }
                ColumnIdentifier columnIdentifier = columnMapRow.getSource();
                ColumnIdentifier columnIdentifier2 = columnMapRow2.getSource();
                if (columnIdentifier == null) {
                    return 1;
                }
                if (columnIdentifier2 == null) {
                    return -1;
                }
                return columnIdentifier.getPosition() - columnIdentifier2.getPosition();
            }
        };
        Arrays.sort(this.data, comparator);
    }
}

