/*
 * Decompiled with CFR 0.152.
 */
package workbench.liquibase;

import workbench.util.StringUtil;

public class ChangeSetIdentifier {
    private final String author;
    private final String id;
    private String comment;

    public ChangeSetIdentifier(String string) {
        if (string == null) {
            throw new NullPointerException("Parameter must not be null");
        }
        int n = string.indexOf("::");
        if (n == -1) {
            this.id = string.trim();
            this.author = "*";
        } else {
            String[] stringArray = string.split("::");
            if (stringArray.length == 1) {
                this.id = string.trim();
                this.author = "*";
            } else {
                this.author = stringArray[0].trim();
                this.id = stringArray[1].trim();
            }
        }
    }

    public ChangeSetIdentifier(String string, String string2) {
        this.author = string == null ? "*" : string.trim();
        this.id = string2 == null ? "*" : string2.trim();
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getId() {
        return this.id;
    }

    private boolean isWildcard(String string) {
        return string == null || "*".equals(string);
    }

    public boolean isEqualTo(ChangeSetIdentifier changeSetIdentifier) {
        if (changeSetIdentifier == null) {
            return false;
        }
        boolean bl = this.isWildcard(this.author) || this.isWildcard(changeSetIdentifier.author) || StringUtil.equalString(this.author, changeSetIdentifier.author);
        boolean bl2 = this.isWildcard(this.id) || this.isWildcard(changeSetIdentifier.id) || StringUtil.equalString(this.id, changeSetIdentifier.id);
        return bl && bl2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(20);
        stringBuilder.append(this.author == null ? "*" : this.author);
        stringBuilder.append("::");
        stringBuilder.append(this.id == null ? "*" : this.id);
        return stringBuilder.toString();
    }
}

