/*
 * Decompiled with CFR 0.152.
 */
package workbench.resource;

import java.util.List;
import java.util.Set;
import workbench.db.DbSettings;
import workbench.db.DropType;
import workbench.resource.Settings;
import workbench.util.CollectionUtil;

public class DbExplorerSettings {
    public static final String PROP_USE_FILTER_RETRIEVE = "workbench.dbexplorer.tablelist.filter.retrieve";
    public static final String PROP_USE_SQLSORT = "workbench.dbexplorer.datapanel.applysqlorder";
    public static final String PROP_TABLE_HISTORY = "workbench.dbexplorer.tablelist.history";
    public static final String PROP_ALLOW_ALTER_TABLE = "workbench.dbexplorer.allow.alter";
    public static final String PROP_ALLOW_SOURCE_EDITING = "workbench.dbexplorer.allow.source.edit";
    public static final String PROP_INSTANT_FILTER = "workbench.dbexplorer.instantfilter";
    public static final String PROP_ASSUME_WILDCARDS = "workbench.dbexplorer.assumewildcards";

    public static boolean showApplyDDLHint() {
        return Settings.getInstance().getBoolProperty("workbench.gui.apply.ddl.hint", true);
    }

    public static boolean showSynonymTargetInDbExplorer() {
        return Settings.getInstance().getBoolProperty("workbench.dbexplorer.synonyms.showtarget", true);
    }

    public static void setShowSynonymTargetInDbExplorer(boolean bl) {
        Settings.getInstance().setProperty("workbench.dbexplorer.synonyms.showtarget", bl);
    }

    public static boolean allowSourceEditing() {
        return Settings.getInstance().getBoolProperty(PROP_ALLOW_SOURCE_EDITING, false);
    }

    public static void setAllowSourceEditing(boolean bl) {
        Settings.getInstance().setProperty(PROP_ALLOW_SOURCE_EDITING, bl);
    }

    public static Set<String> objectTypesToRunWithoutConfirmation() {
        List<String> list = Settings.getInstance().getListProperty("workbench.dbexplorer.exec.noconfirm.types", false);
        Set<String> set = CollectionUtil.caseInsensitiveSet();
        set.addAll(list);
        return set;
    }

    public static boolean allowAlterInDbExplorer() {
        return Settings.getInstance().getBoolProperty(PROP_ALLOW_ALTER_TABLE, false);
    }

    public static void setAllowAlterInDbExplorer(boolean bl) {
        Settings.getInstance().setProperty(PROP_ALLOW_ALTER_TABLE, bl);
    }

    public static boolean getUseFilterForRetrieve() {
        return Settings.getInstance().getBoolProperty(PROP_USE_FILTER_RETRIEVE, false);
    }

    public static void setUseFilterForRetrieve(boolean bl) {
        Settings.getInstance().setProperty(PROP_USE_FILTER_RETRIEVE, bl);
    }

    public static boolean getApplySQLSortInDbExplorer() {
        return Settings.getInstance().getBoolProperty(PROP_USE_SQLSORT, false);
    }

    public static void setApplySQLSortInDbExplorer(boolean bl) {
        Settings.getInstance().setProperty(PROP_USE_SQLSORT, bl);
    }

    public static boolean getDbExplorerTableDetailFullyQualified() {
        return Settings.getInstance().getBoolProperty("workbench.dbexplorer.tabledetails.fullname", true);
    }

    public static int getDbExplorerTableHistorySize() {
        return Settings.getInstance().getIntProperty("workbench.dbexplorer.tablelist.history.size", 25);
    }

    public static boolean getDbExplorerShowTableHistory() {
        return Settings.getInstance().getBoolProperty(PROP_TABLE_HISTORY, true);
    }

    public static void setDbExplorerShowTableHistory(boolean bl) {
        Settings.getInstance().setProperty(PROP_TABLE_HISTORY, bl);
    }

    public static boolean getDbExplorerMultiSelectTypes() {
        return Settings.getInstance().getBoolProperty("workbench.dbexplorer.tablelist.types.multiselect", true);
    }

    public static boolean getDbExplorerMultiSelectTypesAutoClose() {
        return Settings.getInstance().getBoolProperty("workbench.dbexplorer.tablelist.types.multiselect.autoclose", false);
    }

    public static boolean getDbExplorerIncludeTrgInTableSource() {
        return Settings.getInstance().getBoolProperty("workbench.dbexplorer.tablesource.include.trigger", false);
    }

    public static void setDbExplorerIncludeTrgInTableSource(boolean bl) {
        Settings.getInstance().setProperty("workbench.dbexplorer.tablesource.include.trigger", bl);
    }

    public static boolean getGenerateTableGrants() {
        return Settings.getInstance().getBoolProperty("workbench.db.generate.tablesource.include.grants", true);
    }

    public static void setGenerateTableGrants(boolean bl) {
        Settings.getInstance().setProperty("workbench.db.generate.tablesource.include.grants", bl);
    }

    public static DropType getDropTypeToGenerate() {
        return DbExplorerSettings.getDropTypeToGenerate(null);
    }

    public static DropType getDropTypeToGenerate(String string) {
        String string2 = "workbench.dbexplorer.generate.drop";
        String string3 = Settings.getInstance().getProperty(string2, DropType.cascaded.name());
        if (string != null && !"default".equalsIgnoreCase(string)) {
            string3 = Settings.getInstance().getProperty(string2 + "." + DbSettings.getKeyValue(string), string3);
        }
        if ("true".equalsIgnoreCase(string3)) {
            return DropType.cascaded;
        }
        if ("false".equalsIgnoreCase(string3)) {
            return DropType.none;
        }
        try {
            return DropType.valueOf(string3);
        }
        catch (Exception exception) {
            return DropType.cascaded;
        }
    }

    public static void setDropTypeToGenerate(DropType dropType) {
        Settings.getInstance().setProperty("workbench.dbexplorer.generate.drop", dropType.name());
    }

    public static void setDropTypeToGenerate(DropType dropType, String string) {
        Settings.getInstance().setProperty("workbench.dbexplorer.generate.drop." + DbSettings.getKeyValue(string), dropType.name());
    }

    public static boolean getUsePartialMatch() {
        return Settings.getInstance().getBoolProperty(PROP_ASSUME_WILDCARDS, true);
    }

    public static void setUsePartialMatch(boolean bl) {
        Settings.getInstance().setProperty(PROP_ASSUME_WILDCARDS, bl);
    }

    public static boolean getFilterDuringTyping() {
        return Settings.getInstance().getBoolProperty(PROP_INSTANT_FILTER, false);
    }

    public static void setFilterDuringTyping(boolean bl) {
        Settings.getInstance().setProperty(PROP_INSTANT_FILTER, bl);
    }

    public static boolean getAlwaysUseSeparateConnForDbExpWindow() {
        return Settings.getInstance().getBoolProperty("workbench.dbexplorer.connection.always.separate", false);
    }

    public static String getDefaultExplorerObjectType() {
        return Settings.getInstance().getProperty("workbench.gui.dbobjects.TableListPanel.objecttype", null);
    }

    public static void setDefaultExplorerObjectType(String string) {
        Settings.getInstance().setProperty("workbench.gui.dbobjects.TableListPanel.objecttype", string);
    }

    public static boolean getRetrieveDbExplorer() {
        return Settings.getInstance().getBoolProperty("workbench.dbexplorer.retrieveonopen", true);
    }

    public static void setRetrieveDbExplorer(boolean bl) {
        Settings.getInstance().setProperty("workbench.dbexplorer.retrieveonopen", bl);
    }

    public static void setShowDbExplorerInMainWindow(boolean bl) {
        Settings.getInstance().setProperty("workbench.dbexplorer.mainwindow", bl);
    }

    public static boolean getShowDbExplorerInMainWindow() {
        return Settings.getInstance().getBoolProperty("workbench.dbexplorer.mainwindow", true);
    }

    public static boolean getAutoGeneratePKName() {
        return Settings.getInstance().getBoolProperty("workbench.db.createpkname", false);
    }

    public static void setGenerateColumnListInViews(boolean bl) {
        Settings.getInstance().setProperty("workbench.sql.create.view.columnlist", bl);
    }

    public static boolean getGenerateColumnListInViews() {
        return Settings.getInstance().getBoolProperty("workbench.sql.create.view.columnlist", true);
    }

    public static void setAutoGeneratePKName(boolean bl) {
        Settings.getInstance().setProperty("workbench.db.createpkname", bl);
    }

    public static boolean getShowTriggerPanel() {
        return Settings.getInstance().getBoolProperty("workbench.dbexplorer.triggerpanel.show", true);
    }

    public static void setShowTriggerPanel(boolean bl) {
        Settings.getInstance().setProperty("workbench.dbexplorer.triggerpanel.show", bl);
    }

    public static void setShowFocusInDbExplorer(boolean bl) {
        Settings.getInstance().setProperty("workbench.gui.dbobjects.showfocus", bl);
    }

    public static boolean getRememberMetaColumnOrder(String string) {
        return Settings.getInstance().getBoolProperty("workbench.dbexplorer." + string + ".remember.columnorder", true);
    }

    public static void setRememberMetaColumnOrder(String string, boolean bl) {
        Settings.getInstance().setProperty("workbench.dbexplorer." + string + ".remember.columnorder", bl);
    }

    public static boolean showFocusInDbExplorer() {
        return Settings.getInstance().getBoolProperty("workbench.gui.dbobjects.showfocus", false);
    }

    public static void setRememberSortInDbExplorer(boolean bl) {
        Settings.getInstance().setProperty("workbench.dbexplorer.remembersort", bl);
    }

    public static boolean getRememberSortInDbExplorer() {
        return Settings.getInstance().getBoolProperty("workbench.dbexplorer.remembersort", false);
    }

    public static void setRememberColumnOrder(boolean bl) {
        Settings.getInstance().setProperty("workbench.dbexplorer.remember.columnorder", bl);
    }

    public static boolean getRememberColumnOrder() {
        return Settings.getInstance().getBoolProperty("workbench.dbexplorer.remember.columnorder", false);
    }

    public static void setStoreExplorerObjectType(boolean bl) {
        Settings.getInstance().setProperty("workbench.dbexplorer.rememberObjectType", bl);
    }

    public static boolean getStoreExplorerObjectType() {
        return Settings.getInstance().getBoolProperty("workbench.dbexplorer.rememberObjectType", false);
    }

    public static boolean getSwitchCatalogInExplorer() {
        return Settings.getInstance().getBoolProperty("workbench.dbexplorer.switchcatalog", true);
    }

    public static boolean getSelectDataPanelAfterRetrieve() {
        return Settings.getInstance().getBoolProperty("workbench.gui.dbobjects.autoselectdatapanel", true);
    }

    public static void setSelectDataPanelAfterRetrieve(boolean bl) {
        Settings.getInstance().setProperty("workbench.gui.dbobjects.autoselectdatapanel", bl);
    }

    public static boolean getSelectSourcePanelAfterRetrieve() {
        return Settings.getInstance().getBoolProperty("workbench.gui.dbobjects.autoselectsrcpanel", true);
    }

    public static void setSelectSourcePanelAfterRetrieve(boolean bl) {
        Settings.getInstance().setProperty("workbench.gui.dbobjects.autoselectsrcpanel", bl);
    }

    public static boolean getAutoRetrieveFKTree() {
        return Settings.getInstance().getBoolProperty("workbench.dbexplorer.fktree.autoload", true);
    }

    public static void setAutoRetrieveFKTree(boolean bl) {
        Settings.getInstance().setProperty("workbench.dbexplorer.fktree.autoload", bl);
    }

    public static boolean getGenerateScriptSeparator() {
        return Settings.getInstance().getBoolProperty("workbench.dbexplorer.sqlscript.separator", false);
    }

    public static void setGenerateScriptSeparator(boolean bl) {
        Settings.getInstance().setProperty("workbench.dbexplorer.sqlscript.separator", bl);
    }

    public static boolean useNaturalSort() {
        return Settings.getInstance().getBoolProperty("workbench.dbexplorer.sort.natural", true);
    }

    public static boolean sortIgnoreCase() {
        return Settings.getInstance().getBoolProperty("workbench.dbexplorer.sort.ignorecase", true);
    }

    public static boolean enableExtendedObjectFilter() {
        return Settings.getInstance().getBoolProperty("workbench.dbexplorer.extended.objectfilter.enabled", true);
    }

    public static boolean showRowCountsInline() {
        return Settings.getInstance().getBoolProperty("workbench.dbexplorer.tablelist.rowcount.inline", true);
    }
}

