/*
 * Decompiled with CFR 0.152.
 */
package workbench.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import workbench.resource.Settings;
import workbench.util.StringUtil;

public class ListItemProperty {
    private String propName;

    public ListItemProperty(String string) {
        this.propName = string;
    }

    private int getItemCount() {
        return Settings.getInstance().getIntProperty("workbench." + this.propName + ".count", 0);
    }

    public List<String> getItems() {
        Settings settings = Settings.getInstance();
        int n = this.getItemCount();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            String string = settings.getProperty("workbench." + this.propName + "." + i, null);
            if (!StringUtil.isNonBlank(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private void clearList() {
        int n = this.getItemCount();
        for (int i = 0; i < n; ++i) {
            Settings.getInstance().removeProperty("workbench." + this.propName + "." + i);
        }
    }

    public void storeItems(Collection<? extends Object> collection) {
        this.clearList();
        int n = 0;
        for (Object object : collection) {
            Settings.getInstance().setProperty("workbench." + this.propName + "." + n, object.toString());
            ++n;
        }
        Settings.getInstance().setProperty("workbench." + this.propName + ".count", n);
    }
}

