/*
 * Decompiled with CFR 0.152.
 */
package workbench.resource;

import java.awt.Image;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.IconMgr;
import workbench.resource.PlatformShortcuts;
import workbench.resource.ResourcePath;
import workbench.resource.Settings;
import workbench.resource.WbResourceBundle;
import workbench.util.FileUtil;
import workbench.util.StringUtil;
import workbench.util.VersionNumber;

public class ResourceMgr {
    public static final String TXT_PRODUCT_NAME = "SQL Workbench/J";
    public static final String TXT_OK = "LblOK";
    public static final String TXT_CANCEL = "LblCancel";
    public static final String MNU_TXT_WORKSPACE = "MnuTxtWorkspace";
    public static final String MNU_TXT_FILE = "MnuTxtFile";
    public static final String MNU_TXT_MACRO = "MnuTxtMacro";
    public static final String MNU_TXT_SQL = "MnuTxtSQL";
    public static final String MNU_TXT_EDIT = "MnuTxtEdit";
    public static final String MNU_TXT_DATA = "MnuTxtData";
    public static final String MNU_TXT_COPY_SELECTED = "MnuTxtCopySelected";
    public static final String MNU_TXT_VIEW = "MnuTxtView";
    public static final String MNU_TXT_TOOLS = "MnuTxtTools";
    public static final String MNU_TXT_TAB_HISTORY = "MnuTxtTabHistory";
    public static final String MNU_TXT_HELP = "MnuTxtHelp";
    public static final String MNU_TXT_OPTIONS = "MnuTxtOptions";
    private static ResourceBundle resources;
    private static final String PROP_CHANGE_LOCALE = "workbench.gui.setdefaultlocale";

    private ResourceMgr() {
    }

    public static String getBuildInfo() {
        return ResourceMgr.getString("TxtBuild") + " " + ResourceMgr.getBuildNumber().toString() + " (" + ResourceMgr.getString("TxtBuildDate") + ")";
    }

    public static String getFullJavaInfo() {
        return "Java version=" + System.getProperty("java.version") + ", java.home=" + System.getProperty("java.home") + ", vendor=" + System.getProperty("java.vendor") + ", name=" + System.getProperty("java.vm.name");
    }

    public static String getOSInfo() {
        return "Operating System=" + System.getProperty("os.name") + ", version=" + System.getProperty("os.version") + ", platform=" + System.getProperty("os.arch");
    }

    public static String getJavaInfo() {
        String string = System.getProperty("java.version");
        String string2 = ResourceMgr.getString("TxtJavaVersion") + ": " + string;
        String string3 = System.getProperty("sun.arch.data.model", null);
        if (string3 != null) {
            string2 = string2 + " (" + string3 + "bit)";
        }
        return string2;
    }

    public static String replaceModifierText(String string) {
        string = StringUtil.replace(string, "%shift%", KeyEvent.getKeyModifiersText(1));
        string = StringUtil.replace(string, "%control%", KeyEvent.getKeyModifiersText(PlatformShortcuts.getDefaultModifier()));
        return string;
    }

    public static Date getBuildDate() {
        String string = ResourceMgr.getString("TxtBuildDate");
        if ("@BUILD_DATE@".equals(string)) {
            return new Date();
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        Date date = null;
        try {
            date = simpleDateFormat.parse(string);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Err when parsing build date!", exception);
            date = new Date();
        }
        return date;
    }

    public static boolean isDevBuild() {
        String string = ResourceMgr.getString("TxtBuildNumber");
        char c = string.charAt(0);
        return c == '[' || c == '@';
    }

    public static VersionNumber getBuildNumber() {
        String string = ResourceMgr.getString("TxtBuildNumber");
        return new VersionNumber(string);
    }

    public static void setWindowIcons(Window window, List<File> list) {
        if (list == null) {
            return;
        }
        try {
            ArrayList<Image> arrayList = new ArrayList<Image>(list.size());
            for (File file : list) {
                URL uRL = file.toURI().toURL();
                ImageIcon imageIcon = new ImageIcon(uRL);
                arrayList.add(imageIcon.getImage());
            }
            window.setIconImages(arrayList);
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Could not set icons!", throwable);
            ResourceMgr.setWindowIcons(window, "workbench");
        }
    }

    public static void setWindowIcons(Window window, String string) {
        ImageIcon imageIcon;
        ArrayList<Image> arrayList = new ArrayList<Image>(2);
        ImageIcon imageIcon2 = IconMgr.getInstance().getPngIcon(string, 16);
        if (imageIcon2 != null) {
            arrayList.add(imageIcon2.getImage());
        }
        if ((imageIcon = IconMgr.getInstance().getPngIcon(string, 32)) != null) {
            arrayList.add(imageIcon.getImage());
        }
        if (arrayList.size() > 0) {
            window.setIconImages(arrayList);
        }
    }

    public static String getDefaultTabLabel() {
        return Settings.getInstance().getProperty("workbench.gui.tabs.defaultlabel", ResourceMgr.getString("LblTabStatement"));
    }

    public static String getFormattedString(String string, Object ... objectArray) {
        return ResourceMgr.getFormattedString(null, string, objectArray);
    }

    public static String getFormattedString(ResourcePath resourcePath, String string, Object ... objectArray) {
        return MessageFormat.format(ResourceMgr.getString(resourcePath, string, false), objectArray);
    }

    public static String getDynamicString(String string, String string2, String string3) {
        return ResourceMgr.getDynamicString(null, string, string2, string3);
    }

    public static String getDynamicString(ResourcePath resourcePath, String string, String string2, String string3) {
        if (string == null || string2 == null) {
            return null;
        }
        String string4 = null;
        if (string3 != null) {
            string4 = string + "." + string3 + "." + string2.toLowerCase();
            if (!ResourceMgr.getResources().containsKey(string4)) {
                string4 = string + "." + string2.toLowerCase();
            }
        } else {
            string4 = string + "." + string2.toLowerCase();
        }
        if (ResourceMgr.getResources(resourcePath).containsKey(string4)) {
            return ResourceMgr.getResources(resourcePath).getString(string4);
        }
        return null;
    }

    public static String getString(String string) {
        return ResourceMgr.getString(null, string, false);
    }

    public static String getString(ResourcePath resourcePath, String string, boolean bl) {
        try {
            String string2 = ResourceMgr.getResources(resourcePath).getString(string);
            if (bl) {
                return ResourceMgr.replaceModifierText(string2);
            }
            return string2;
        }
        catch (MissingResourceException missingResourceException) {
            LogMgr.logWarning(new CallerInfo(){}, "String with key=" + string + " not found in resource file!", missingResourceException);
            return string;
        }
    }

    public static String getPlainString(String string) {
        String string2 = ResourceMgr.getString(string).replace("&", "");
        return string2;
    }

    public static String getDescription(String string) {
        return ResourceMgr.getDescription(string, false);
    }

    public static String getDescription(String string, boolean bl) {
        String string2 = ResourceMgr.getString("d_" + string);
        if (bl) {
            string2 = ResourceMgr.replaceModifierText(string2);
        }
        return string2;
    }

    public static InputStream getDefaultSettings() {
        InputStream inputStream = ResourceMgr.class.getResourceAsStream("default.properties");
        return inputStream;
    }

    static ResourceBundle getResourceBundle(Locale locale) {
        return ResourceMgr.getResourceBundle(locale, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ResourceBundle getResourceBundle(Locale locale, String string) {
        if (string == null) {
            string = "language";
        }
        if (Settings.getInstance().isUTF8Language(locale)) {
            ResourceBundle.Control control = ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES);
            String string2 = "/" + control.toBundleName(string + "/wbstrings", locale) + ".properties";
            InputStream inputStream = null;
            InputStreamReader inputStreamReader = null;
            try {
                inputStream = ResourceMgr.class.getResourceAsStream(string2);
                inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
                WbResourceBundle wbResourceBundle = new WbResourceBundle(inputStreamReader);
                ResourceBundle resourceBundle = ResourceBundle.getBundle("language/wbstrings", Locale.ENGLISH);
                wbResourceBundle.setParent(resourceBundle);
                WbResourceBundle wbResourceBundle2 = wbResourceBundle;
                return wbResourceBundle2;
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Could not read resource bundle " + string2 + " using UTF-8", exception);
            }
            finally {
                FileUtil.closeQuietely(inputStream);
            }
        }
        return ResourceBundle.getBundle(string + "/wbstrings", locale);
    }

    public static ResourceBundle getResources() {
        return ResourceMgr.getResources(null);
    }

    public static ResourceBundle getResources(ResourcePath resourcePath) {
        if (resources == null && resourcePath == null) {
            Locale locale = Settings.getInstance().getLanguage();
            resources = ResourceMgr.getResourceBundle(locale);
            boolean bl = Settings.getInstance().getBoolProperty(PROP_CHANGE_LOCALE, true);
            if (bl) {
                LogMgr.logInfo(new CallerInfo(){}, "Setting default locale to: " + locale.toString());
                Locale.setDefault(locale);
            } else {
                Locale locale2 = Locale.getDefault();
                LogMgr.logInfo(new CallerInfo(){}, "Default locale is : " + locale2.toString());
            }
        } else if (resourcePath != null) {
            Locale locale = Settings.getInstance().getLanguage();
            return ResourceMgr.getResourceBundle(locale, resourcePath.getPath());
        }
        return resources;
    }
}

