/*
 * Decompiled with CFR 0.152.
 */
package workbench.resource;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import workbench.gui.actions.WbAction;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.resource.ShortcutDefinition;
import workbench.sql.macros.MacroDefinition;
import workbench.sql.macros.MacroManager;
import workbench.util.WbPersistence;

public class ShortcutManager {
    private Set<ChangeListener> changeListener = new HashSet<ChangeListener>(5);
    private String filename;
    private Map<String, ShortcutDefinition> keyMap;
    private List<WbAction> allActions = new ArrayList<WbAction>(100);
    private Map<KeyStroke, WbAction> keyDebugMap;
    private boolean modified;

    protected ShortcutManager(String string) {
        this.filename = string;
        try {
            WbPersistence wbPersistence = new WbPersistence(this.filename);
            this.keyMap = (HashMap)wbPersistence.readObject();
        }
        catch (Exception exception) {
            this.keyMap = null;
        }
        if (this.keyMap == null) {
            this.keyMap = new HashMap<String, ShortcutDefinition>(30);
        }
    }

    public static synchronized ShortcutManager getInstance() {
        return LazyInstanceHolder.instane;
    }

    public void removeShortcut(String string) {
        this.assignKey(string, null);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListener.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListener.remove(changeListener);
    }

    public boolean isKeyStrokeAssigned(KeyStroke keyStroke) {
        if (keyStroke == null) {
            return false;
        }
        if (this.getActionClassForKey(keyStroke) != null) {
            return true;
        }
        MacroDefinition macroDefinition = MacroManager.getInstance().getMacroForKeyStroke(keyStroke);
        return macroDefinition != null;
    }

    public void fireShortcutsChanged() {
        if (this.changeListener.isEmpty()) {
            return;
        }
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.changeListener) {
            if (changeListener == null) continue;
            changeListener.stateChanged(changeEvent);
        }
    }

    public void registerAction(WbAction wbAction) {
        KeyStroke keyStroke;
        String string = wbAction.getClass().getName();
        ShortcutDefinition shortcutDefinition = this.getDefinition(string);
        if (shortcutDefinition == null) {
            shortcutDefinition = new ShortcutDefinition(string);
            this.keyMap.put(string, shortcutDefinition);
        }
        if (!shortcutDefinition.hasDefault() && (keyStroke = wbAction.getDefaultAccelerator()) != null) {
            shortcutDefinition.assignDefaultKey(keyStroke);
        }
        if (LogMgr.isDebugEnabled() && (keyStroke = wbAction.getDefaultAccelerator()) != null) {
            WbAction wbAction2;
            if (this.keyDebugMap == null) {
                this.keyDebugMap = new HashMap<KeyStroke, WbAction>(100);
            }
            if ((wbAction2 = this.keyDebugMap.get(keyStroke)) != null && !wbAction2.equals(wbAction)) {
                Exception exception = new Exception("Duplicate key mapping");
                LogMgr.logError(new CallerInfo(){}, "Duplicate key assignment for keyStroke " + keyStroke + " from " + string + ", already registered for " + wbAction2.getClass().getName(), exception);
            } else {
                this.keyDebugMap.put(keyStroke, wbAction);
            }
        }
        this.allActions.add(wbAction);
    }

    public String getTooltip(String string) {
        for (WbAction wbAction : this.allActions) {
            String string2 = wbAction.getClass().getName();
            if (!string2.equals(string)) continue;
            return wbAction.getToolTipText();
        }
        return null;
    }

    public WbAction getActionForClass(String string) {
        for (WbAction wbAction : this.allActions) {
            if (!wbAction.getClass().getName().equals(string)) continue;
            return wbAction;
        }
        return null;
    }

    public String getActionClassForKey(KeyStroke keyStroke) {
        String string = null;
        for (ShortcutDefinition shortcutDefinition : this.keyMap.values()) {
            if (!shortcutDefinition.isMappedTo(keyStroke)) continue;
            string = shortcutDefinition.getActionClass();
            break;
        }
        return string;
    }

    public String getActionNameForKey(KeyStroke keyStroke) {
        String string = this.getActionClassForKey(keyStroke);
        WbAction wbAction = this.getActionForClass(string);
        if (wbAction != null) {
            return wbAction.getDescriptiveName();
        }
        return string;
    }

    public void resetToDefault(String string) {
        ShortcutDefinition shortcutDefinition = this.getDefinition(string);
        if (shortcutDefinition == null) {
            return;
        }
        shortcutDefinition.resetToDefault();
        this.modified = true;
    }

    public void assignKey(String string, KeyStroke keyStroke) {
        ShortcutDefinition shortcutDefinition = this.getDefinition(string);
        if (shortcutDefinition == null) {
            return;
        }
        if (keyStroke == null) {
            shortcutDefinition.setShortcutRemoved(true);
        } else {
            shortcutDefinition.assignKey(keyStroke);
        }
        this.modified = true;
    }

    public void updateActions() {
        for (WbAction wbAction : this.allActions) {
            if (wbAction == null) continue;
            String string = wbAction.getClass().getName();
            ShortcutDefinition shortcutDefinition = this.getDefinition(string);
            KeyStroke keyStroke = shortcutDefinition.getActiveKeyStroke();
            wbAction.setAccelerator(keyStroke);
        }
    }

    public String getActionNameForClass(String string) {
        WbAction wbAction = this.getActionForClass(string);
        if (wbAction == null) {
            return null;
        }
        return wbAction.getDescriptiveName();
    }

    public void saveSettings() {
        Object object;
        if (!this.modified) {
            return;
        }
        HashMap<String, ShortcutDefinition> hashMap = new HashMap<String, ShortcutDefinition>(this.keyMap);
        for (Map.Entry<String, ShortcutDefinition> entry : this.keyMap.entrySet()) {
            ShortcutDefinition shortcutDefinition = entry.getValue();
            if (shortcutDefinition.isCustomized()) continue;
            hashMap.remove(entry.getKey());
        }
        if (hashMap.size() > 0) {
            object = new WbPersistence(this.filename);
            try {
                ((WbPersistence)object).writeObject(hashMap);
            }
            catch (Throwable throwable) {}
        } else {
            object = new File(this.filename);
            if (((File)object).exists()) {
                ((File)object).delete();
            }
        }
    }

    public Collection<ShortcutDefinition> getDefinitions() {
        return Collections.unmodifiableCollection(this.keyMap.values());
    }

    public KeyStroke getCustomizedKeyStroke(Action action) {
        ShortcutDefinition shortcutDefinition = this.getDefinition(action.getClass().getName());
        if (shortcutDefinition == null) {
            return null;
        }
        return shortcutDefinition.getActiveKeyStroke();
    }

    public void setCustomizedKeyStroke(String string, KeyStroke keyStroke) {
        ShortcutDefinition shortcutDefinition;
        String string2 = this.getActionClassForKey(keyStroke);
        if (string2 != null && (shortcutDefinition = this.keyMap.get(string2)) != null) {
            shortcutDefinition.clearKeyStroke();
        }
        if ((shortcutDefinition = this.keyMap.get(string)) == null) {
            return;
        }
        shortcutDefinition.assignKey(keyStroke);
        this.modified = true;
    }

    private ShortcutDefinition getDefinition(String string) {
        return this.keyMap.get(string);
    }

    public List<WbAction> getAllActions() {
        return Collections.unmodifiableList(this.allActions);
    }

    private static class LazyInstanceHolder {
        static final ShortcutManager instane = new ShortcutManager(Settings.getInstance().getShortcutFilename());

        private LazyInstanceHolder() {
        }
    }
}

