/*
 * Decompiled with CFR 0.152.
 */
package workbench.resource;

import java.awt.event.KeyEvent;
import javax.swing.KeyStroke;

public class StoreableKeyStroke {
    private int keyCode;
    private int modifier;
    private boolean keyCodeSet = false;
    private boolean modifierSet = false;

    public StoreableKeyStroke() {
    }

    public StoreableKeyStroke(KeyStroke keyStroke) {
        this.keyCode = keyStroke.getKeyCode();
        this.modifier = keyStroke.getModifiers();
        this.modifierSet = true;
        this.keyCodeSet = true;
    }

    public KeyStroke getKeyStroke() {
        if (this.keyCodeSet || this.modifierSet) {
            return KeyStroke.getKeyStroke(this.keyCode, this.modifier);
        }
        return null;
    }

    public int getKeyCode() {
        KeyStroke keyStroke = this.getKeyStroke();
        if (keyStroke != null) {
            return keyStroke.getKeyCode();
        }
        return 0;
    }

    public void setKeyCode(int n) {
        this.keyCode = n;
        this.keyCodeSet = true;
    }

    public void setKeyModifier(int n) {
        this.modifier = n;
        this.modifierSet = true;
    }

    public int getKeyModifier() {
        KeyStroke keyStroke = this.getKeyStroke();
        if (keyStroke != null) {
            return keyStroke.getModifiers();
        }
        return 0;
    }

    public boolean equals(KeyStroke keyStroke) {
        KeyStroke keyStroke2 = this.getKeyStroke();
        if (keyStroke2 == null && keyStroke == null) {
            return true;
        }
        return keyStroke2.equals(keyStroke);
    }

    public boolean equals(StoreableKeyStroke storeableKeyStroke) {
        KeyStroke keyStroke = this.getKeyStroke();
        KeyStroke keyStroke2 = storeableKeyStroke.getKeyStroke();
        if (keyStroke == null && keyStroke2 == null) {
            return true;
        }
        if (keyStroke == null && keyStroke2 != null) {
            return false;
        }
        if (keyStroke != null && keyStroke2 == null) {
            return false;
        }
        return keyStroke.equals(keyStroke2);
    }

    public boolean equals(Object object) {
        if (object instanceof StoreableKeyStroke) {
            return this.equals((StoreableKeyStroke)object);
        }
        if (object instanceof KeyStroke) {
            return this.equals((KeyStroke)object);
        }
        return false;
    }

    public int hashCode() {
        int n = 7;
        n = 17 * n + this.keyCode;
        n = 17 * n + this.modifier;
        return n;
    }

    public String toString() {
        KeyStroke keyStroke = this.getKeyStroke();
        if (keyStroke == null) {
            return "";
        }
        int n = keyStroke.getModifiers();
        int n2 = keyStroke.getKeyCode();
        String string = KeyEvent.getKeyModifiersText(n);
        if (string.length() == 0) {
            return KeyEvent.getKeyText(n2);
        }
        return string + "-" + KeyEvent.getKeyText(n2);
    }
}

