/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.commands;

import java.sql.SQLException;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.sql.SavepointStrategy;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.sql.lexer.SQLLexer;
import workbench.sql.lexer.SQLLexerFactory;
import workbench.sql.lexer.SQLToken;
import workbench.util.StringUtil;

public class TransactionEndCommand
extends SqlCommand {
    public static final String COMMIT_VERB = "COMMIT";
    public static final String ROLLBACK_VERB = "ROLLBACK";
    private String verb;

    public static SqlCommand getCommit() {
        return new TransactionEndCommand(COMMIT_VERB);
    }

    public static SqlCommand getRollback() {
        return new TransactionEndCommand(ROLLBACK_VERB);
    }

    private TransactionEndCommand(String string) {
        this.verb = string;
        this.isUpdatingCommand = COMMIT_VERB.equalsIgnoreCase(this.verb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult(string);
        statementRunnerResult.ignoreUpdateCounts(true);
        if (this.shouldIgnore()) {
            statementRunnerResult.setSuccess();
            if (this.currentConnection.getDbSettings().showFeedbackForIgnoredCommit()) {
                statementRunnerResult.addMessageByKey("MsgTransControlIgnored", this.getVerb());
            }
            LogMgr.logInfo(new CallerInfo(){}, this.getVerb() + " not sent to database as connection is in auto-commit mode");
            return statementRunnerResult;
        }
        try {
            if (this.currentConnection.useJdbcCommit()) {
                if (COMMIT_VERB.equals(this.verb)) {
                    this.currentConnection.getSqlConnection().commit();
                } else if (ROLLBACK_VERB.equals(this.verb)) {
                    this.currentConnection.getSqlConnection().rollback();
                }
            } else {
                this.currentStatement = this.currentConnection.createStatement();
                this.currentStatement.execute(string);
            }
            if (this.shouldHandleTransactionEnd(string)) {
                this.handleTransactionEnd();
            }
            this.runner.removeSessionProperty("manual_transaction");
            this.appendSuccessMessage(statementRunnerResult);
            statementRunnerResult.setSuccess();
            this.processResults(statementRunnerResult, false);
        }
        catch (Exception exception) {
            this.addErrorInfo(statementRunnerResult, string, exception);
            LogMgr.logUserSqlError(new CallerInfo(){}, string, exception);
        }
        finally {
            this.done();
        }
        return statementRunnerResult;
    }

    @Override
    public String getVerb() {
        return this.verb;
    }

    private boolean shouldIgnore() {
        if (this.currentConnection == null) {
            return true;
        }
        if (this.currentConnection.getDbSettings() == null) {
            return false;
        }
        return this.currentConnection.getDbSettings().ignoreCommitInAutocommitMode() && this.currentConnection.getAutoCommit();
    }

    private boolean isManualTransaction() {
        return StringUtil.stringToBool(this.runner.getSessionAttribute("manual_transaction"));
    }

    private boolean shouldHandleTransactionEnd(String string) {
        if (!this.isManualTransaction()) {
            return false;
        }
        if (this.getVerb().equals(COMMIT_VERB)) {
            return true;
        }
        SQLLexer sQLLexer = SQLLexerFactory.createLexer(this.currentConnection, string);
        SQLToken sQLToken = sQLLexer.getNextToken(false, false);
        sQLToken = sQLLexer.getNextToken(false, false);
        if (sQLToken == null) {
            return true;
        }
        if (sQLToken.getText().equalsIgnoreCase("TO")) {
            return false;
        }
        sQLToken = sQLLexer.getNextToken(false, false);
        return sQLToken == null || !sQLToken.getText().equalsIgnoreCase("TO");
    }

    private void handleTransactionEnd() {
        try {
            LogMgr.logInfo(new CallerInfo(){}, "Transaction end detected. Turning auto commit back on");
            this.runner.getConnection().setAutoCommit(true);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could disable auto commit!", exception);
        }
        String string = this.runner.getSessionAttribute("savepoint_strategy");
        if (string != null) {
            this.runner.setSavepointStrategy(SavepointStrategy.valueOf(string));
            this.runner.removeSessionProperty("savepoint_strategy");
        }
    }
}

