/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.formatter;

import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.sql.formatter.ExternalFormatter;
import workbench.sql.formatter.SqlFormatter;
import workbench.sql.formatter.WbSqlFormatter;

public class SqlFormatterFactory {
    public static SqlFormatter createFormatter(WbConnection wbConnection) {
        return SqlFormatterFactory.createFormatter(wbConnection == null ? null : wbConnection.getDbId());
    }

    public static SqlFormatter createFormatter(String string) {
        SqlFormatter sqlFormatter = SqlFormatterFactory.getExternalFormatter(string);
        if (sqlFormatter == null) {
            sqlFormatter = SqlFormatterFactory.getExternalFormatter(null);
        }
        if (sqlFormatter != null) {
            return sqlFormatter;
        }
        return new WbSqlFormatter(Settings.getInstance().getFormatterMaxSubselectLength(), string);
    }

    private static SqlFormatter getExternalFormatter(String string) {
        ExternalFormatter externalFormatter = ExternalFormatter.getDefinition(string);
        if (externalFormatter != null && externalFormatter.isEnabled()) {
            if (externalFormatter.isUsable()) {
                LogMgr.logInfo(new CallerInfo(){}, "Using external formatter: " + externalFormatter.toString() + " for DBID: " + string);
                return externalFormatter;
            }
            if (!externalFormatter.programExists()) {
                LogMgr.logInfo(new CallerInfo(){}, "External formatter executetable: " + externalFormatter.getProgram() + " not found! Formatter for " + string + " not used.");
            }
        }
        return null;
    }
}

