/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.generator;

import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.sql.generator.DefaultInsertGenerator;
import workbench.sql.generator.InsertType;

public class MySQLInsertGenerator
extends DefaultInsertGenerator {
    public MySQLInsertGenerator(TableIdentifier tableIdentifier, List<ColumnIdentifier> list) {
        super(tableIdentifier, list);
    }

    public MySQLInsertGenerator(TableIdentifier tableIdentifier, List<ColumnIdentifier> list, WbConnection wbConnection) {
        super(tableIdentifier, list, wbConnection);
    }

    @Override
    public boolean supportsType(InsertType insertType) {
        return super.supportsType(insertType) || insertType == InsertType.InsertIgnore || insertType == InsertType.Upsert;
    }

    @Override
    protected CharSequence buildFinalPart() {
        switch (this.getInsertType()) {
            case InsertIgnore: {
                return this.createInsertIgnore();
            }
            case Upsert: {
                return this.createUpsert();
            }
        }
        return super.buildFinalPart();
    }

    private String createInsertIgnore() {
        String string = "\nON DUPLICATE KEY UPDATE \n  ";
        String string2 = ((ColumnIdentifier)this.targetColumns.get(0)).getDisplayName();
        string2 = this.quoteHandler.quoteObjectname(string2);
        string = string + " " + string2 + " = " + string2;
        return string;
    }

    private CharSequence createUpsert() {
        StringBuilder stringBuilder = new StringBuilder(this.targetColumns.size() * 20 + 20);
        stringBuilder.append("\nON DUPLICATE KEY UPDATE \n  ");
        for (int i = 0; i < this.targetColumns.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(",\n  ");
            }
            String string = ((ColumnIdentifier)this.targetColumns.get(i)).getDisplayName();
            string = this.quoteHandler.quoteObjectname(string);
            stringBuilder.append(string);
            stringBuilder.append(" = VALUES(");
            stringBuilder.append(string);
            stringBuilder.append(')');
        }
        return stringBuilder;
    }
}

