/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.macros;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import workbench.sql.macros.MacroDefinition;
import workbench.sql.macros.Sortable;
import workbench.sql.macros.Sorter;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;

public class MacroGroup
implements Sortable {
    private String name;
    private List<MacroDefinition> macros = new ArrayList<MacroDefinition>();
    private List<MacroDefinition> filtered = new ArrayList<MacroDefinition>();
    private int sortOrder;
    private String tooltip;
    private boolean modified = false;
    private boolean showInMenu = true;
    private boolean showInPopup = true;

    public MacroGroup() {
    }

    public MacroGroup(String string) {
        this.name = string;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String string) {
        this.modified = this.modified || StringUtil.stringsAreNotEqual(this.tooltip, string);
        this.tooltip = StringUtil.trimToNull(string);
    }

    public boolean isVisibleInMenu() {
        return this.showInMenu;
    }

    public void setVisibleInMenu(boolean bl) {
        this.modified = this.modified || bl != this.showInMenu;
        this.showInMenu = bl;
    }

    public boolean isVisibleInPopup() {
        return this.showInPopup;
    }

    public void setVisibleInPopup(boolean bl) {
        this.modified = this.modified || bl != this.showInPopup;
        this.showInPopup = bl;
    }

    @Override
    public int getSortOrder() {
        return this.sortOrder;
    }

    @Override
    public void setSortOrder(int n) {
        this.modified = this.modified || this.sortOrder != n;
        this.sortOrder = n;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.modified = this.modified || StringUtil.stringsAreNotEqual(this.name, string);
        this.name = string;
    }

    public synchronized void addMacro(MacroDefinition macroDefinition) {
        this.macros.add(macroDefinition);
        this.applySort();
        this.modified = true;
    }

    public synchronized void sortByName() {
        Comparator comparator = (macroDefinition, macroDefinition2) -> {
            if (macroDefinition == null && macroDefinition2 == null) {
                return 0;
            }
            if (macroDefinition == null) {
                return -1;
            }
            if (macroDefinition2 == null) {
                return 1;
            }
            return macroDefinition.getName().compareToIgnoreCase(macroDefinition2.getName());
        };
        Collections.sort(this.macros, comparator);
        for (int i = 0; i < this.macros.size(); ++i) {
            this.macros.get(i).setSortOrder(i);
        }
    }

    public synchronized void applySort() {
        this.applySort(this.macros);
    }

    private void applySort(List<MacroDefinition> list) {
        Collections.sort(list, new Sorter());
        for (int i = 0; i < list.size(); ++i) {
            list.get(i).setSortOrder(i);
        }
    }

    public synchronized List<MacroDefinition> getVisibleMacros() {
        ArrayList<MacroDefinition> arrayList = new ArrayList<MacroDefinition>(this.macros.size());
        for (MacroDefinition macroDefinition : this.macros) {
            if (!macroDefinition.isVisibleInMenu()) continue;
            arrayList.add(macroDefinition);
        }
        return arrayList;
    }

    public synchronized List<MacroDefinition> getMacrosForPopup() {
        ArrayList<MacroDefinition> arrayList = new ArrayList<MacroDefinition>(this.macros.size());
        for (MacroDefinition macroDefinition : this.macros) {
            if (!macroDefinition.isVisibleInPopup()) continue;
            arrayList.add(macroDefinition);
        }
        return arrayList;
    }

    public synchronized void setMacros(List<MacroDefinition> list) {
        this.filtered.clear();
        this.macros.clear();
        this.macros.addAll(list);
        this.applySort();
        this.modified = false;
    }

    public synchronized List<MacroDefinition> getMacros() {
        return this.macros;
    }

    public synchronized List<MacroDefinition> getAllMacros() {
        ArrayList<MacroDefinition> arrayList = new ArrayList<MacroDefinition>();
        arrayList.addAll(this.macros);
        arrayList.addAll(this.filtered);
        this.applySort(arrayList);
        return arrayList;
    }

    public synchronized void removeMacro(MacroDefinition macroDefinition) {
        this.macros.remove(macroDefinition);
        this.modified = true;
    }

    public MacroGroup createCopy() {
        MacroGroup macroGroup = new MacroGroup();
        macroGroup.name = this.name;
        macroGroup.sortOrder = this.sortOrder;
        macroGroup.showInMenu = this.showInMenu;
        macroGroup.showInPopup = this.showInPopup;
        macroGroup.tooltip = this.tooltip;
        macroGroup.modified = false;
        for (MacroDefinition macroDefinition : this.macros) {
            macroGroup.macros.add(macroDefinition.createCopy());
        }
        for (MacroDefinition macroDefinition : this.filtered) {
            macroGroup.macros.add(macroDefinition.createCopy());
        }
        this.applySort(macroGroup.macros);
        return macroGroup;
    }

    public boolean isModified() {
        if (this.modified) {
            return true;
        }
        for (MacroDefinition macroDefinition : this.macros) {
            if (!macroDefinition.isModified()) continue;
            return true;
        }
        return false;
    }

    public void resetModified() {
        this.modified = false;
        for (MacroDefinition macroDefinition : this.macros) {
            macroDefinition.resetModified();
        }
    }

    public int getVisibleMacroSize() {
        int n = 0;
        for (MacroDefinition macroDefinition : this.macros) {
            if (!macroDefinition.isVisibleInMenu()) continue;
            ++n;
        }
        return n;
    }

    public int getSize() {
        return this.macros.size();
    }

    public boolean equals(Object object) {
        if (object instanceof MacroGroup) {
            return StringUtil.equalStringIgnoreCase(this.name, ((MacroGroup)object).name);
        }
        return false;
    }

    public int hashCode() {
        int n = 7;
        n = 19 * n + (this.name != null ? this.name.toLowerCase().hashCode() : 0);
        return n;
    }

    public void resetFilter() {
        this.macros.addAll(this.filtered);
        this.filtered.clear();
        this.applySort();
    }

    public boolean isFiltered() {
        return CollectionUtil.isNonEmpty(this.filtered);
    }

    public void applyFilter(String string) {
        this.resetFilter();
        if (StringUtil.isBlank(string)) {
            return;
        }
        string = string.toLowerCase();
        Iterator<MacroDefinition> iterator = this.macros.iterator();
        while (iterator.hasNext()) {
            MacroDefinition macroDefinition = iterator.next();
            if (macroDefinition.getName().toLowerCase().contains(string)) continue;
            this.filtered.add(macroDefinition);
            iterator.remove();
        }
    }
}

