/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.macros;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import workbench.interfaces.MacroChangeListener;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.resource.ShortcutManager;
import workbench.sql.macros.MacroDefinition;
import workbench.sql.macros.MacroGroup;
import workbench.sql.macros.Sorter;
import workbench.util.CaseInsensitiveComparator;
import workbench.util.FileUtil;
import workbench.util.FileVersioner;
import workbench.util.WbFile;
import workbench.util.WbPersistence;

public class MacroStorage {
    private final Object lock = new Object();
    private final Map<String, MacroDefinition> allMacros = new TreeMap<String, MacroDefinition>(CaseInsensitiveComparator.INSTANCE);
    private final List<MacroGroup> groups = new ArrayList<MacroGroup>();
    private boolean modified = false;
    private String currentFilter;
    private List<MacroChangeListener> changeListeners = new ArrayList<MacroChangeListener>(1);
    private WbFile sourceFile;

    public MacroStorage(WbFile wbFile) {
        this.sourceFile = wbFile;
        this.loadMacros();
    }

    public MacroStorage() {
    }

    public synchronized void loadNewFile(WbFile wbFile) {
        this.sourceFile = wbFile;
        this.loadMacros();
        this.fireMacroListChanged();
    }

    public synchronized MacroDefinition getMacro(String string) {
        return this.allMacros.get(string);
    }

    public File getCurrentFile() {
        return this.sourceFile;
    }

    public String getCurrentMacroFilename() {
        if (this.sourceFile == null) {
            return null;
        }
        return this.sourceFile.getFullPath();
    }

    public void removeGroup(MacroGroup macroGroup) {
        this.groups.remove(macroGroup);
        this.modified = true;
    }

    public synchronized int getSize() {
        int n = 0;
        for (MacroGroup macroGroup : this.groups) {
            n += macroGroup.getSize();
        }
        return n;
    }

    public void addChangeListener(MacroChangeListener macroChangeListener) {
        this.changeListeners.add(macroChangeListener);
    }

    public void removeChangeListener(MacroChangeListener macroChangeListener) {
        this.changeListeners.remove(macroChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void copyFrom(MacroStorage macroStorage) {
        Object object = this.lock;
        synchronized (object) {
            this.allMacros.clear();
            this.groups.clear();
            for (MacroGroup macroGroup : macroStorage.groups) {
                this.groups.add(macroGroup.createCopy());
            }
            this.currentFilter = null;
            this.modified = macroStorage.isModified();
            this.updateMap();
        }
        this.fireMacroListChanged();
    }

    public MacroStorage createCopy() {
        MacroStorage macroStorage = new MacroStorage();
        for (MacroGroup macroGroup : this.groups) {
            macroStorage.groups.add(macroGroup.createCopy());
        }
        macroStorage.updateMap();
        macroStorage.resetModified();
        return macroStorage;
    }

    private File createBackup(WbFile wbFile) {
        if (Settings.getInstance().getCreateMacroBackup()) {
            int n = Settings.getInstance().getMaxBackupFiles();
            String string = Settings.getInstance().getBackupDir();
            char c = Settings.getInstance().getFileVersionDelimiter();
            FileVersioner fileVersioner = new FileVersioner(n, string, c);
            try {
                return fileVersioner.createBackup(wbFile);
            }
            catch (IOException iOException) {
                LogMgr.logWarning(new CallerInfo(){}, "Error when creating backup for: " + wbFile.getAbsolutePath(), iOException);
            }
        }
        return wbFile.makeBackup();
    }

    public void saveMacros(WbFile wbFile) {
        this.sourceFile = wbFile;
        this.saveMacros();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveMacros() {
        if (this.sourceFile == null) {
            return;
        }
        boolean bl = !Settings.getInstance().getCreateMacroBackup();
        boolean bl2 = false;
        File file = null;
        String string = this.currentFilter;
        long l = System.currentTimeMillis();
        Object object = this.lock;
        synchronized (object) {
            if (this.currentFilter != null) {
                this.resetFilter();
            }
            if (this.getSize() == 0) {
                if (this.sourceFile.exists() && this.isModified()) {
                    file = this.createBackup(this.sourceFile);
                    this.sourceFile.delete();
                    LogMgr.logDebug(new CallerInfo(){}, "All macros from " + this.sourceFile.getFullPath() + " were removed. Macro file deleted.");
                } else {
                    LogMgr.logDebug(new CallerInfo(){}, "No macros defined, nothing to save");
                }
            } else {
                file = this.createBackup(this.sourceFile);
                WbPersistence wbPersistence = new WbPersistence(this.sourceFile.getAbsolutePath());
                try {
                    wbPersistence.writeObject(this.groups);
                    long l2 = System.currentTimeMillis() - l;
                    LogMgr.logDebug(new CallerInfo(){}, "Saved " + this.allMacros.size() + " macros to " + this.sourceFile.getFullPath() + " in " + l2 + "ms");
                }
                catch (Throwable throwable) {
                    LogMgr.logError(new CallerInfo(){}, "Error saving macros to " + this.sourceFile.getFullPath(), throwable);
                    bl2 = true;
                }
                if (file != null) {
                    if (bl2) {
                        LogMgr.logWarning(new CallerInfo(){}, "Restoring the old macro file from backup: " + file.getAbsolutePath());
                        FileUtil.copySilently(file, this.sourceFile);
                    } else if (bl) {
                        LogMgr.logDebug(new CallerInfo(){}, "Deleting temporary backup file: " + file.getAbsolutePath());
                        file.delete();
                    }
                }
            }
            if (string != null) {
                this.applyFilter(string);
            }
            this.resetModified();
        }
    }

    private void fireMacroListChanged() {
        for (MacroChangeListener macroChangeListener : this.changeListeners) {
            if (macroChangeListener == null) continue;
            macroChangeListener.macroListChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sortGroupsByName() {
        Object object = this.lock;
        synchronized (object) {
            Comparator comparator = (macroGroup, macroGroup2) -> {
                if (macroGroup == null && macroGroup2 == null) {
                    return 0;
                }
                if (macroGroup == null) {
                    return -1;
                }
                if (macroGroup2 == null) {
                    return 1;
                }
                return macroGroup.getName().compareToIgnoreCase(macroGroup2.getName());
            };
            this.groups.sort(comparator);
            this.modified = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applySort() {
        Object object = this.lock;
        synchronized (object) {
            this.groups.sort(new Sorter());
            for (int i = 0; i < this.groups.size(); ++i) {
                this.groups.get(i).setSortOrder(i);
                this.groups.get(i).applySort();
            }
            this.modified = true;
        }
    }

    private void updateMap() {
        boolean bl = false;
        this.allMacros.clear();
        for (MacroGroup macroGroup : this.groups) {
            List<MacroDefinition> list = macroGroup.getMacros();
            for (MacroDefinition macroDefinition : list) {
                this.allMacros.put(macroDefinition.getName(), macroDefinition);
                bl = bl || macroDefinition.isShortcutChanged();
            }
        }
        if (bl) {
            ShortcutManager.getInstance().fireShortcutsChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMacros() {
        if (this.sourceFile == null) {
            LogMgr.logDebug(new CallerInfo(){}, "No macro file specified. No Macros loaded");
            return;
        }
        if (!this.sourceFile.exists()) {
            LogMgr.logDebug(new CallerInfo(){}, "Macro file " + this.sourceFile + " not found. No Macros loaded");
            return;
        }
        try {
            Object object = this.lock;
            synchronized (object) {
                WbPersistence wbPersistence = new WbPersistence(this.sourceFile.getAbsolutePath());
                Object object2 = wbPersistence.readObject();
                if (object2 instanceof List) {
                    List list = (List)object2;
                    this.groups.clear();
                    this.groups.addAll(list);
                } else if (object2 instanceof HashMap) {
                    File file = new File(this.sourceFile.getParentFile(), this.sourceFile.getName() + ".old");
                    FileUtil.copy(this.sourceFile, file);
                    Map map = (Map)object2;
                    MacroGroup macroGroup = new MacroGroup(ResourceMgr.getString("LblDefGroup"));
                    this.groups.clear();
                    int n = 0;
                    for (Map.Entry entry : map.entrySet()) {
                        MacroDefinition macroDefinition = new MacroDefinition((String)entry.getKey(), (String)entry.getValue());
                        macroDefinition.setSortOrder(n);
                        ++n;
                        macroGroup.addMacro(macroDefinition);
                    }
                    this.groups.add(macroGroup);
                }
                this.applySort();
                this.updateMap();
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error loading macro file", exception);
        }
        this.resetModified();
    }

    public synchronized void moveMacro(MacroDefinition macroDefinition, MacroGroup macroGroup) {
        this.moveMacro(macroDefinition, macroGroup, true);
    }

    private void moveMacro(MacroDefinition macroDefinition, MacroGroup macroGroup, boolean bl) {
        MacroGroup macroGroup2 = this.findMacroGroup(macroDefinition.getName());
        if (macroGroup2 != null && macroGroup2.equals(macroGroup)) {
            return;
        }
        if (macroGroup2 != null) {
            macroGroup2.removeMacro(macroDefinition);
        }
        macroGroup.addMacro(macroDefinition);
        this.modified = true;
        if (bl) {
            this.fireMacroListChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MacroGroup findMacroGroup(String string) {
        Object object = this.lock;
        synchronized (object) {
            for (MacroGroup macroGroup : this.groups) {
                List<MacroDefinition> list = macroGroup.getMacros();
                for (MacroDefinition macroDefinition : list) {
                    if (!macroDefinition.getName().equalsIgnoreCase(string)) continue;
                    return macroGroup;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMacro(MacroGroup macroGroup, MacroDefinition macroDefinition) {
        Object object = this.lock;
        synchronized (object) {
            this.allMacros.put(macroDefinition.getName(), macroDefinition);
            if (!this.containsGroup(macroGroup.getName())) {
                this.addGroup(macroGroup);
            }
            this.moveMacro(macroDefinition, macroGroup, false);
            macroDefinition.setSortOrder(macroGroup.getSize() + 1);
            this.modified = true;
        }
        this.fireMacroListChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMacro(MacroDefinition macroDefinition) {
        Object object = this.lock;
        synchronized (object) {
            MacroDefinition macroDefinition2 = this.allMacros.remove(macroDefinition.getName());
            for (MacroGroup macroGroup : this.groups) {
                macroGroup.removeMacro(macroDefinition2);
            }
            this.modified = true;
        }
        this.fireMacroListChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMacro(String string, String string2, String string3) {
        MacroDefinition macroDefinition = new MacroDefinition(string2, string3);
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (string != null) {
                for (MacroGroup macroGroup : this.groups) {
                    if (!macroGroup.getName().equalsIgnoreCase(string)) continue;
                    macroGroup.addMacro(macroDefinition);
                    bl = true;
                }
                if (!bl) {
                    MacroGroup macroGroup = new MacroGroup(string);
                    macroGroup.addMacro(macroDefinition);
                    this.groups.add(macroGroup);
                }
            } else {
                this.groups.get(0).addMacro(macroDefinition);
            }
            this.updateMap();
            this.modified = true;
        }
        this.fireMacroListChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsGroup(String string) {
        Object object = this.lock;
        synchronized (object) {
            for (MacroGroup macroGroup : this.groups) {
                if (!macroGroup.getName().equalsIgnoreCase(string)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGroup(MacroGroup macroGroup) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.groups.contains(macroGroup)) {
                int n = 1;
                if (this.groups.size() > 0) {
                    n = this.groups.get(this.groups.size() - 1).getSortOrder() + 1;
                }
                macroGroup.setSortOrder(n);
                this.groups.add(macroGroup);
                this.applySort();
                this.modified = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MacroGroup> getVisibleGroups() {
        ArrayList<MacroGroup> arrayList = new ArrayList<MacroGroup>(this.groups.size());
        Object object = this.lock;
        synchronized (object) {
            for (MacroGroup macroGroup : this.groups) {
                if (!macroGroup.isVisibleInMenu() || macroGroup.getVisibleMacroSize() <= 0) continue;
                arrayList.add(macroGroup);
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MacroGroup> getGroups() {
        Object object = this.lock;
        synchronized (object) {
            return Collections.unmodifiableList(this.groups);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetModified() {
        Object object = this.lock;
        synchronized (object) {
            this.modified = false;
            for (MacroGroup macroGroup : this.groups) {
                macroGroup.resetModified();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isModified() {
        Object object = this.lock;
        synchronized (object) {
            if (this.modified) {
                return true;
            }
            for (MacroGroup macroGroup : this.groups) {
                if (!macroGroup.isModified()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        Object object = this.lock;
        synchronized (object) {
            this.resetFilter();
            this.allMacros.clear();
            this.groups.clear();
            this.modified = true;
        }
        this.fireMacroListChanged();
    }

    public String toString() {
        return this.allMacros.size() + " macros";
    }

    public void resetFilter() {
        for (MacroGroup macroGroup : this.groups) {
            macroGroup.resetFilter();
        }
        this.currentFilter = null;
        this.updateMap();
    }

    public void applyFilter(String string) {
        this.currentFilter = string;
        for (MacroGroup macroGroup : this.groups) {
            macroGroup.applyFilter(string);
        }
        this.updateMap();
    }

    public boolean isFiltered() {
        return this.currentFilter != null;
    }
}

