/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import workbench.db.ColumnIdentifier;
import workbench.sql.wbcommands.MissingWidthDefinition;
import workbench.util.StringUtil;

public class ColumnWidthDefinition {
    private Map<ColumnIdentifier, Integer> columnWidths;

    public ColumnWidthDefinition(String string) throws MissingWidthDefinition {
        List<String> list = StringUtil.stringToList(string, ",", true, true);
        if (list == null || list.isEmpty()) {
            return;
        }
        this.columnWidths = new HashMap<ColumnIdentifier, Integer>();
        for (String string2 : list) {
            String[] stringArray = string2.split("=");
            if (stringArray == null || stringArray.length != 2) {
                throw new MissingWidthDefinition(string2);
            }
            ColumnIdentifier columnIdentifier = new ColumnIdentifier(stringArray[0]);
            int n = StringUtil.getIntValue(stringArray[1], -1);
            if (n <= 0) {
                throw new MissingWidthDefinition(string2);
            }
            this.columnWidths.put(columnIdentifier, n);
        }
    }

    public Map<ColumnIdentifier, Integer> getColumnWidths() {
        return this.columnWidths;
    }
}

