/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.io.File;
import java.util.List;
import workbench.db.ConnectionMgr;
import workbench.db.ConnectionProfile;
import workbench.db.DbDriver;
import workbench.db.WbConnection;
import workbench.resource.ResourceMgr;
import workbench.sql.wbcommands.InvalidConnectionDescriptor;
import workbench.ssh.SshConfig;
import workbench.ssh.SshHostConfig;
import workbench.util.StringUtil;
import workbench.util.WbFile;

public class ConnectionDescriptor {
    private File baseDir;
    private String jarfile;
    private int instance;
    private static int instanceCounter;

    public ConnectionDescriptor() {
        this(null);
    }

    public ConnectionDescriptor(String string) {
        this.baseDir = new File(StringUtil.isBlank(string) ? System.getProperty("user.dir") : string);
        this.instance = ++instanceCounter;
    }

    public ConnectionProfile parseDefinition(String string, WbConnection wbConnection) throws InvalidConnectionDescriptor {
        Object object;
        if (StringUtil.isBlank(string)) {
            return null;
        }
        List<String> list = StringUtil.stringToList(string, ",", true, true, false, false);
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        this.jarfile = null;
        boolean bl = false;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        String string12 = null;
        String string13 = null;
        String string14 = null;
        String string15 = null;
        for (String object22 : list) {
            object = object22.toLowerCase();
            if (((String)object).startsWith("username=") || ((String)object).startsWith("user=")) {
                string3 = this.getValue(object22);
            }
            if (((String)object).startsWith("password=")) {
                string4 = this.getValue(object22);
            }
            if (((String)object).startsWith("url=")) {
                string2 = this.getValue(object22);
            }
            if (((String)object).startsWith("driver=") || ((String)object).startsWith("driverclass=")) {
                string5 = this.getValue(object22);
            }
            if (((String)object).startsWith("driverName=")) {
                string6 = this.getValue(object22);
            }
            if (((String)object).startsWith("autocommit=")) {
                string7 = this.getValue(object22);
            }
            if (((String)object).startsWith("jar") || ((String)object).startsWith("driverjar=")) {
                this.jarfile = this.getValue(object22);
            }
            if (this.isParameter(object22, "sshHost")) {
                string8 = this.getValue(object22);
            }
            if (this.isParameter(object22, "sshUser")) {
                string9 = this.getValue(object22);
            }
            if (this.isParameter(object22, "sshPassword")) {
                string10 = this.getValue(object22);
            }
            if (this.isParameter(object22, "sshLocalPort")) {
                string12 = this.getValue(object22);
            }
            if (this.isParameter(object22, "sshDBPort")) {
                string15 = this.getValue(object22);
            }
            if (this.isParameter(object22, "sshDBHost")) {
                string14 = this.getValue(object22);
            }
            if (this.isParameter(object22, "sshPort")) {
                string13 = this.getValue(object22);
            }
            if (!this.isParameter(object22, "sshPrivateKey")) continue;
            string11 = this.getValue(object22);
        }
        if (string2 == null && wbConnection != null) {
            string2 = wbConnection.getUrl();
            bl = true;
        } else if (this.isSameDBMS(wbConnection, string2)) {
            bl = true;
        }
        if (StringUtil.isBlank(string2)) {
            throw new InvalidConnectionDescriptor("No JDBC URL specified in connection specification", ResourceMgr.getString("ErrConnectURLMissing"));
        }
        if (bl) {
            string6 = wbConnection.getProfile().getDriverName();
            string5 = wbConnection.getProfile().getDriverclass();
        } else {
            if (StringUtil.isEmptyString(string5)) {
                string5 = ConnectionDescriptor.findDriverClassFromUrl(string2);
            }
            if (StringUtil.isEmptyString(string5)) {
                throw new InvalidConnectionDescriptor("No JDBC URL specified in connection specification", ResourceMgr.getFormattedString("ErrConnectDrvNotFound", string2));
            }
        }
        Object object3 = null;
        object3 = StringUtil.isNonEmpty(string6) ? ConnectionMgr.getInstance().findDriverByName(string5, string6) : this.getDriver(string5, this.jarfile);
        ConnectionProfile connectionProfile = new ConnectionProfile();
        connectionProfile.setTemporaryProfile(true);
        connectionProfile.setName("$temp-profile-" + this.instance);
        connectionProfile.setDriver((DbDriver)object3);
        connectionProfile.setStoreExplorerSchema(false);
        connectionProfile.setUrl(string2);
        if (string7 != null) {
            connectionProfile.setAutocommit(StringUtil.stringToBool(string7));
        }
        if (string8 != null && string9 != null) {
            object = new SshConfig();
            SshHostConfig sshHostConfig = new SshHostConfig();
            sshHostConfig.setUsername(string9);
            sshHostConfig.setHostname(string8);
            sshHostConfig.setPassword(string10);
            sshHostConfig.setPrivateKeyFile(string11);
            sshHostConfig.setSshPort(StringUtil.getIntValue(string13, 0));
            ((SshConfig)object).setHostConfig(sshHostConfig);
            ((SshConfig)object).setDbHostname(string14);
            ((SshConfig)object).setDbPort(StringUtil.getIntValue(string15, 0));
            ((SshConfig)object).setLocalPort(StringUtil.getIntValue(string12, 0));
            connectionProfile.setSshConfig((SshConfig)object);
        }
        connectionProfile.setPassword(string4);
        connectionProfile.setStorePassword(true);
        connectionProfile.setUsername(string3);
        connectionProfile.setRollbackBeforeDisconnect(true);
        connectionProfile.setReadOnly(false);
        connectionProfile.resetChangedFlags();
        return connectionProfile;
    }

    private boolean isParameter(String string, String string2) {
        return string.toLowerCase().startsWith(string2.toLowerCase() + "=");
    }

    private String getValue(String string) {
        if (StringUtil.isEmptyString(string)) {
            return null;
        }
        int n = string.indexOf(61);
        if (n == -1) {
            return null;
        }
        return StringUtil.trimToNull(StringUtil.trimQuotes(string.substring(n + 1).trim()));
    }

    protected static String getUrlPrefix(String string) {
        if (StringUtil.isEmptyString(string)) {
            return null;
        }
        int n = string.indexOf(58);
        if (n == -1) {
            return null;
        }
        int n2 = string.indexOf(58, n + 1);
        if (n2 == -1) {
            return null;
        }
        return string.substring(0, n2 + 1);
    }

    public static String findDriverClassFromUrl(String string) {
        String string2 = ConnectionDescriptor.getUrlPrefix(string);
        if (string2 == null) {
            return null;
        }
        List<DbDriver> list = ConnectionMgr.getInstance().getDriverTemplates();
        for (DbDriver dbDriver : list) {
            String string3;
            String string4 = dbDriver.getSampleUrl();
            if (string4 == null || !string2.equals(string3 = ConnectionDescriptor.getUrlPrefix(string4))) continue;
            return dbDriver.getDriverClass();
        }
        return null;
    }

    public String getJarPath() {
        return this.getJarPath(this.jarfile);
    }

    private String getJarPath(String string) {
        String string2 = null;
        WbFile wbFile = new WbFile(string == null ? "" : string);
        if (wbFile.isAbsolute() || this.baseDir == null) {
            string2 = wbFile.getFullPath();
        } else {
            wbFile = new WbFile(this.baseDir, string);
            string2 = wbFile.getFullPath();
        }
        return string2;
    }

    private DbDriver getDriver(String string, String string2) {
        DbDriver dbDriver = null;
        if (string2 == null) {
            dbDriver = ConnectionMgr.getInstance().findDriver(string);
        } else {
            String string3 = this.getJarPath(string2);
            dbDriver = ConnectionMgr.getInstance().registerDriver(string, string3);
        }
        return dbDriver;
    }

    private boolean isSameDBMS(WbConnection wbConnection, String string) {
        if (StringUtil.isEmptyString(string)) {
            return false;
        }
        if (wbConnection == null) {
            return false;
        }
        String string2 = ConnectionDescriptor.getUrlPrefix(wbConnection.getUrl());
        return string2.equals(ConnectionDescriptor.getUrlPrefix(string));
    }
}

