/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import workbench.db.JdbcUtils;
import workbench.db.TableIdentifier;
import workbench.db.search.ClientSideTableSearcher;
import workbench.interfaces.TableSearchConsumer;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.sql.wbcommands.SourceTableArgument;
import workbench.storage.DataStore;
import workbench.storage.filter.ColumnComparator;
import workbench.storage.filter.ContainsComparator;
import workbench.storage.filter.IsNullComparator;
import workbench.storage.filter.RegExComparator;
import workbench.storage.filter.StartsWithComparator;
import workbench.storage.filter.StringEqualsComparator;
import workbench.util.ArgumentParser;
import workbench.util.ArgumentType;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;

public class WbGrepData
extends SqlCommand
implements TableSearchConsumer {
    public static final String VERB = "WbGrepData";
    public static final String ARG_EXPRESSION = "searchValue";
    public static final String ARG_EXCLUDE_LOBS = "excludeLobs";
    public static final String ARG_RETRIEVE_CLOBS = "retrieveCLOB";
    public static final String ARG_RETRIEVE_BLOBS = "retrieveBLOB";
    public static final String ARG_IGNORE_CASE = "ignoreCase";
    public static final String ARG_COMPARATOR = "compareType";
    public static final String ARG_COLUMNS = "columns";
    public static final String ARG_BLOB_ENCODING = "treatBlobAs";
    public static final String ARG_SUMMARY_ONLY = "summaryOnly";
    public static final String ARG_MATCHED_COLS = "matchedColumnsOnly";
    private ClientSideTableSearcher searcher;
    private StatementRunnerResult searchResult;
    private int foundTables;
    private List<String> searchedTables;

    public WbGrepData() {
        this.isUpdatingCommand = false;
        this.cmdLine = new ArgumentParser();
        this.cmdLine.addArgument("tables", ArgumentType.TableArgument);
        this.cmdLine.addArgument("excludeTables", ArgumentType.TableArgument);
        this.cmdLine.addArgument("types", ArgumentType.ObjectTypeArgument);
        this.cmdLine.addDeprecatedArgument(ARG_EXCLUDE_LOBS, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_IGNORE_CASE, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_RETRIEVE_CLOBS, ArgumentType.BoolSwitch);
        this.cmdLine.addArgument(ARG_RETRIEVE_BLOBS, ArgumentType.BoolSwitch);
        this.cmdLine.addArgument(ARG_SUMMARY_ONLY, ArgumentType.BoolSwitch);
        this.cmdLine.addArgument(ARG_MATCHED_COLS, ArgumentType.BoolSwitch);
        this.cmdLine.addArgument(ARG_EXPRESSION);
        this.cmdLine.addArgument(ARG_COLUMNS);
        this.cmdLine.addArgument(ARG_BLOB_ENCODING, StringUtil.stringToList(Settings.getInstance().getPopularEncodings(), ",", true, true));
        this.cmdLine.addArgument(ARG_COMPARATOR, CollectionUtil.arrayList("equals", "startsWith", "contains", "matches", "isNull"));
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        Object object;
        boolean bl;
        String string2;
        this.searchResult = new StatementRunnerResult(this.messageLogger);
        String string3 = this.getCommandLine(string);
        this.cmdLine.parse(string3);
        if (this.displayHelp(this.searchResult)) {
            return this.searchResult;
        }
        if (this.cmdLine.hasUnknownArguments()) {
            this.setUnknownMessage(this.searchResult, this.cmdLine, ResourceMgr.getString("ErrDataSearchWrongParms"));
            return this.searchResult;
        }
        String string4 = this.cmdLine.getValue(ARG_EXPRESSION);
        boolean bl2 = true;
        String string5 = this.cmdLine.getValue("tables");
        String string6 = this.cmdLine.getValue("excludeTables");
        List<TableIdentifier> list = null;
        if (StringUtil.isBlank(string5)) {
            string5 = "%";
        }
        String[] stringArray = SourceTableArgument.parseTypes(this.cmdLine.getValue("types"), this.currentConnection);
        SourceTableArgument sourceTableArgument = new SourceTableArgument(string5, string6, null, stringArray, this.currentConnection);
        list = sourceTableArgument.getTables();
        this.searcher = new ClientSideTableSearcher();
        if (this.cmdLine.isArgPresent(ARG_EXCLUDE_LOBS)) {
            this.searcher.setRetrieveLobColumns(!this.cmdLine.getBoolean(ARG_EXCLUDE_LOBS, false));
            string2 = ResourceMgr.getFormattedString("ErrDataSearchExclDeprecated", "-excludeLobs", "-retrieveCLOB", "-retrieveBLOB");
            this.searchResult.addWarning(string2);
        } else {
            if (this.cmdLine.isArgPresent(ARG_BLOB_ENCODING)) {
                string2 = this.cmdLine.getValue(ARG_BLOB_ENCODING);
                this.searcher.setTreatBlobAsText(StringUtil.isNonBlank(string2), string2);
            } else {
                this.searcher.setRetrieveBLOBs(this.cmdLine.getBoolean(ARG_RETRIEVE_BLOBS, false));
            }
            this.searcher.setIncludeCLOBs(this.cmdLine.getBoolean(ARG_RETRIEVE_CLOBS, true));
        }
        this.searcher.setConnection(this.currentConnection);
        this.searcher.setTableNames(list);
        boolean bl3 = this.cmdLine.getBoolean(ARG_IGNORE_CASE, true);
        String string7 = this.cmdLine.getValue(ARG_COMPARATOR);
        if (StringUtil.isBlank(string7)) {
            string7 = "contains";
        }
        ColumnComparator columnComparator = null;
        if ("equals".equalsIgnoreCase(string7)) {
            columnComparator = new StringEqualsComparator();
        } else if ("startsWith".equalsIgnoreCase(string7)) {
            columnComparator = new StartsWithComparator();
        } else if ("matches".equalsIgnoreCase(string7)) {
            columnComparator = new RegExComparator();
        } else if ("isnull".equalsIgnoreCase(string7)) {
            columnComparator = new IsNullComparator();
            bl2 = false;
        } else {
            columnComparator = new ContainsComparator();
        }
        if (bl2 && StringUtil.isBlank(string4)) {
            this.searchResult.addMessageByKey("ErrDataSearchValueReq");
            this.searchResult.addErrorMessageByKey("ErrDataSearchWrongParms");
            return this.searchResult;
        }
        List<String> list2 = this.cmdLine.getListValue(ARG_COLUMNS);
        this.searcher.setComparator(columnComparator);
        this.searcher.setConsumer(this);
        this.searcher.setCriteria(string4, bl3, list2);
        if (Settings.getInstance().getBoolProperty("workbench.searchdata.warn.buffer", true) && JdbcUtils.driverMightBufferResults(this.currentConnection) && !(bl = (object = this.runner.getExecutionController()).confirmExecution(ResourceMgr.getString("MsgTableSearchBuffered"), null, null))) {
            this.searchResult.addErrorMessageByKey("MsgStatementCancelled");
            return this.searchResult;
        }
        if (this.rowMonitor != null) {
            this.rowMonitor.setMonitorType(6);
        }
        this.searchResult.setSuccess();
        this.searcher.search();
        object = new StringBuilder(this.searchedTables.size() * 20);
        ((StringBuilder)object).append(ResourceMgr.getString("MsgSearchedTables"));
        for (String string8 : this.searchedTables) {
            ((StringBuilder)object).append("\n  ");
            ((StringBuilder)object).append(string8);
        }
        ((StringBuilder)object).append('\n');
        this.searchResult.addMessage(((StringBuilder)object).toString());
        String string9 = ResourceMgr.getFormattedString("MsgSearchDataFinished", this.searchedTables.size(), this.foundTables);
        this.searchResult.addMessage(string9);
        return this.searchResult;
    }

    @Override
    public void cancel() throws SQLException {
        super.cancel();
        if (this.searcher != null) {
            this.searcher.cancelSearch();
        }
    }

    @Override
    public void done() {
        super.done();
        this.searcher = null;
    }

    @Override
    public void setCurrentTable(String string, String string2, long l, long l2) {
        if (this.rowMonitor != null) {
            this.rowMonitor.setCurrentObject(string, l, l2);
        }
    }

    @Override
    public void error(String string) {
        this.searchResult.addMessage(string);
        this.searchResult.setFailure();
    }

    @Override
    public void tableSearched(TableIdentifier tableIdentifier, DataStore dataStore) {
        this.searchedTables.add(tableIdentifier.getTableName());
        if (dataStore != null && dataStore.getRowCount() > 0) {
            dataStore.resetStatus();
            dataStore.setGeneratingFilter(this.searcher.getSearchExpression());
            this.searchResult.addDataStore(dataStore);
            ++this.foundTables;
        }
    }

    @Override
    public void setStatusText(String string) {
        if (this.rowMonitor != null) {
            this.rowMonitor.setCurrentObject(string, -1L, -1L);
        }
    }

    @Override
    public void searchStarted() {
        if (this.rowMonitor != null) {
            this.rowMonitor.jobFinished();
        }
        this.searchedTables = new ArrayList<String>(50);
        this.foundTables = 0;
    }

    @Override
    public void searchEnded() {
        if (this.rowMonitor != null) {
            this.rowMonitor.jobFinished();
        }
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }

    @Override
    public boolean shouldEndTransaction() {
        return true;
    }
}

