/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.sql.SQLException;
import java.util.List;
import workbench.console.ConsoleSettings;
import workbench.console.RowDisplay;
import workbench.db.postgres.PostgresUtil;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.storage.DataStore;
import workbench.util.ArgumentParser;
import workbench.util.ArgumentType;
import workbench.util.StringUtil;

public class WbListCatalogs
extends SqlCommand {
    public static final String VERB = "WbListDB";
    public static final String VERB_ALTERNATE = "WbListCat";

    public WbListCatalogs() {
        this.isUpdatingCommand = false;
        this.cmdLine = new ArgumentParser();
        this.cmdLine.addArgument("verbose", ArgumentType.BoolSwitch);
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    public String getAlternateVerb() {
        return VERB_ALTERNATE;
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        DataStore dataStore = null;
        String string2 = StringUtil.capitalize(this.currentConnection.getMetadata().getCatalogTerm());
        if (this.currentConnection.getMetadata().isPostgres()) {
            this.cmdLine.parse(this.getCommandLine(string));
            boolean bl = this.cmdLine.getBoolean("verbose", false);
            dataStore = PostgresUtil.listPgDatabases(this.currentConnection, bl);
        } else {
            List<String> list = this.currentConnection.getMetadata().getCatalogs();
            String[] stringArray = new String[]{string2};
            int[] nArray = new int[]{12};
            int[] nArray2 = new int[]{10};
            dataStore = new DataStore(stringArray, nArray, nArray2);
            for (String string3 : list) {
                int n = dataStore.addRow();
                dataStore.setValue(n, 0, (Object)string3);
            }
            dataStore.setResultName(string2);
            dataStore.setGeneratingSql(string);
        }
        ConsoleSettings.getInstance().setNextRowDisplay(RowDisplay.SingleLine);
        dataStore.resetStatus();
        statementRunnerResult.addDataStore(dataStore);
        statementRunnerResult.setSuccess();
        return statementRunnerResult;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

