/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.sql.SQLException;
import workbench.console.ConsoleSettings;
import workbench.console.RowDisplay;
import workbench.db.JdbcProcedureReader;
import workbench.db.TableIdentifier;
import workbench.resource.ResourceMgr;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.storage.DataStore;
import workbench.storage.ResultInfo;
import workbench.util.ArgumentParser;
import workbench.util.ArgumentType;
import workbench.util.StringUtil;

public class WbListProcedures
extends SqlCommand {
    public static final String VERB = "WbListProcs";
    public static final String ALTERNATE_VERB = "WbListProcedures";

    public WbListProcedures() {
        this.isUpdatingCommand = false;
        this.cmdLine = new ArgumentParser();
        this.cmdLine.addArgument("schema", ArgumentType.SchemaArgument);
        this.cmdLine.addArgument("catalog", ArgumentType.CatalogArgument);
        this.cmdLine.addArgument("package");
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    public String getAlternateVerb() {
        return ALTERNATE_VERB;
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        Object object;
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        ConsoleSettings.getInstance().setNextRowDisplay(RowDisplay.SingleLine);
        String string2 = this.getCommandLine(string);
        this.cmdLine.parse(string2);
        if (this.displayHelp(statementRunnerResult)) {
            return statementRunnerResult;
        }
        String string3 = null;
        String string4 = null;
        String string5 = null;
        if (this.cmdLine.hasArguments()) {
            string3 = this.cmdLine.getValue("schema");
            string4 = this.cmdLine.getValue("catalog");
            if (StringUtil.isBlank(string4)) {
                string4 = this.cmdLine.getValue("package");
            }
        } else if (StringUtil.isNonBlank(string2)) {
            object = new TableIdentifier(string2, this.currentConnection);
            string3 = object.getSchema();
            string4 = object.getCatalog();
            string5 = object.getObjectName();
        }
        if (string3 == null) {
            string3 = this.currentConnection.getCurrentSchema();
        }
        if (string4 == null) {
            string4 = this.currentConnection.getCurrentCatalog();
        }
        object = this.currentConnection.getMetadata().getProcedureReader().getProcedures(string4, string3, string5);
        int n = ((DataStore)object).getRowCount();
        for (int i = 0; i < n; ++i) {
            int n2 = ((DataStore)object).getValueAsInt(i, 1, -1);
            String string6 = JdbcProcedureReader.convertProcTypeToSQL(n2);
            ((DataStore)object).setValue(i, 1, (Object)string6);
        }
        ResultInfo resultInfo = ((DataStore)object).getResultInfo();
        resultInfo.getColumn(1).setDataType(12);
        ((DataStore)object).setResultName(ResourceMgr.getString("TxtDbExplorerProcs"));
        ((DataStore)object).setGeneratingSql(string);
        ((DataStore)object).resetStatus();
        statementRunnerResult.addDataStore((DataStore)object);
        statementRunnerResult.setSuccess();
        return statementRunnerResult;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

