/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import workbench.liquibase.ChangeSetIdentifier;
import workbench.liquibase.LiquibaseParser;
import workbench.resource.ResourceMgr;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.sql.parser.ParserType;
import workbench.sql.wbcommands.CommonArgs;
import workbench.util.ArgumentParser;
import workbench.util.ArgumentType;
import workbench.util.CollectionUtil;
import workbench.util.ExceptionUtil;
import workbench.util.MessageBuffer;
import workbench.util.WbFile;

public class WbRunLB
extends SqlCommand {
    public static final String VERB = "WbRunLB";
    public static final String ARG_CHANGESET = "changeSet";

    public WbRunLB() {
        this.cmdLine = new ArgumentParser();
        this.cmdLine.addArgument("file", ArgumentType.Filename);
        this.cmdLine.addArgument("continueOnError", ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_CHANGESET, ArgumentType.Repeatable);
        this.cmdLine.addArgument("verbose", ArgumentType.BoolSwitch);
        CommonArgs.addEncodingParameter(this.cmdLine);
        this.isUpdatingCommand = true;
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    protected boolean isConnectionRequired() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        Object object;
        Object object2;
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult(string);
        statementRunnerResult.setSuccess();
        boolean bl = true;
        this.cmdLine.parse(this.getCommandLine(string));
        WbFile wbFile = null;
        if (this.cmdLine.hasArguments()) {
            wbFile = this.evaluateFileArgument(this.cmdLine.getValue("file"));
        } else {
            wbFile = this.evaluateFileArgument(this.getCommandLine(string));
            bl = false;
        }
        if (wbFile == null) {
            String string2 = ResourceMgr.getString("ErrLBWrongParameter");
            statementRunnerResult.addMessage(string2);
            statementRunnerResult.setFailure();
            return statementRunnerResult;
        }
        if (!wbFile.exists()) {
            statementRunnerResult.setFailure();
            String string3 = ResourceMgr.getFormattedString("ErrFileNotFound", wbFile.getFullPath());
            statementRunnerResult.addMessage(string3);
            return statementRunnerResult;
        }
        boolean bl2 = bl ? this.cmdLine.getBoolean("continueOnError", false) : false;
        boolean bl3 = bl ? this.cmdLine.getBoolean("verbose", false) : false;
        List<String> list = bl ? this.cmdLine.getListValue(ARG_CHANGESET) : null;
        ArrayList<ChangeSetIdentifier> arrayList = null;
        if (CollectionUtil.isNonEmpty(list)) {
            arrayList = new ArrayList<ChangeSetIdentifier>(list.size());
            object2 = list.iterator();
            while (object2.hasNext()) {
                String string4 = (String)object2.next();
                object = new ChangeSetIdentifier(string4);
                arrayList.add((ChangeSetIdentifier)object);
            }
        }
        Object object3 = object2 = bl ? this.cmdLine.getValue("encoding", "UTF-8") : "UTF-8";
        if (bl) {
            this.setUnknownMessage(statementRunnerResult, this.cmdLine, null);
        }
        boolean bl4 = this.runner.getVerboseLogging();
        try {
            this.runner.setVerboseLogging(bl3);
            object = new MessageBuffer();
            ParserType parserType = ParserType.getTypeFromConnection(this.currentConnection);
            LiquibaseParser liquibaseParser = new LiquibaseParser(wbFile, (String)object2, (MessageBuffer)object, parserType);
            List<String> list2 = liquibaseParser.getContentFromChangeSet(arrayList);
            this.rowMonitor.setMonitorType(7);
            for (int i = 0; i < list2.size(); ++i) {
                String string5 = list2.get(i);
                this.rowMonitor.setCurrentRow(i, list2.size());
                StatementRunnerResult statementRunnerResult2 = this.runner.runStatement(string5);
                statementRunnerResult.addMessage(statementRunnerResult2.getMessages());
                statementRunnerResult.addMessageNewLine();
                if (statementRunnerResult2.isSuccess() || bl2) continue;
                statementRunnerResult.setFailure();
                break;
            }
            if (this.rowMonitor != null) {
                this.rowMonitor.jobFinished();
            }
            if (((MessageBuffer)object).getLength() > 0) {
                statementRunnerResult.addWarning((MessageBuffer)object);
            }
        }
        catch (Exception exception) {
            statementRunnerResult.setFailure();
            statementRunnerResult.addMessage(ExceptionUtil.getDisplay(exception));
        }
        finally {
            this.runner.setVerboseLogging(bl4);
        }
        return statementRunnerResult;
    }

    @Override
    public void done() {
    }

    @Override
    public void cancel() throws SQLException {
        if (this.runner != null) {
            this.runner.cancel();
        }
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

