/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import workbench.db.WbConnection;
import workbench.interfaces.JobErrorHandler;
import workbench.resource.Settings;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.storage.DataStore;
import workbench.storage.DmlStatement;
import workbench.storage.RowData;
import workbench.util.ArgumentParser;
import workbench.util.StringUtil;

public class WbShowProps
extends SqlCommand {
    public static final String VERB = "WbProps";
    public static final String ALTERNATE_VERB = "WbShowProps";

    public WbShowProps() {
        this.cmdLine = new ArgumentParser();
        this.cmdLine.addArgument("type", StringUtil.stringToList("wb,system,db"));
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException, Exception {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult(string);
        String string2 = this.getCommandLine(string);
        this.cmdLine.parse(string2);
        if (this.cmdLine.hasArguments() || StringUtil.isBlank(string2)) {
            List<String> list = this.cmdLine.getListValue("type");
            if (list.contains("wb")) {
                statementRunnerResult.addDataStore(WbShowProps.getWbProperties(null));
            }
            if (list.isEmpty() || list.contains("system")) {
                statementRunnerResult.addDataStore(this.getSystemProperties());
            }
            if (list.contains("db") && this.currentConnection != null) {
                statementRunnerResult.addDataStore(WbShowProps.getWbProperties("workbench.db." + this.currentConnection.getDbId()));
            }
        } else if (StringUtil.isNonBlank(string2)) {
            DataStore dataStore;
            if (this.currentConnection != null) {
                string2 = string2.toLowerCase().replace("[dbid]", this.currentConnection.getDbId());
            }
            if ((dataStore = WbShowProps.getWbProperties(string2)).getRowCount() > 0) {
                statementRunnerResult.addDataStore(dataStore);
            }
        }
        statementRunnerResult.setSuccess();
        return statementRunnerResult;
    }

    static DataStore getWbProperties(String string) {
        PropertyDataStore propertyDataStore = new PropertyDataStore(true);
        Set<String> set = Settings.getInstance().getKeys();
        for (String string2 : set) {
            if (!WbShowProps.isWorkbenchProperty(string2) || string != null && !string2.startsWith(string)) continue;
            int n = propertyDataStore.addRow();
            propertyDataStore.setValue(n, 0, (Object)string2);
            propertyDataStore.setValue(n, 1, (Object)Settings.getInstance().getProperty(string2, null));
        }
        propertyDataStore.sortByColumn(0, true);
        propertyDataStore.setResultName("Workbench Properties");
        propertyDataStore.resetStatus();
        return propertyDataStore;
    }

    private static boolean isWorkbenchProperty(String string) {
        return string.startsWith("workbench.db") || string.startsWith("workbench.settings.") || string.startsWith("workbench.sql") && !string.startsWith("workbench.sql.replace.") && !string.startsWith("workbench.sql.formatter.") && !string.startsWith("workbench.sql.search.");
    }

    private DataStore getSystemProperties() {
        PropertyDataStore propertyDataStore = new PropertyDataStore(false);
        Set<Map.Entry<Object, Object>> set = System.getProperties().entrySet();
        for (Map.Entry<Object, Object> entry : set) {
            int n = propertyDataStore.addRow();
            propertyDataStore.setValue(n, 0, (Object)entry.getKey().toString());
            propertyDataStore.setValue(n, 1, (Object)entry.getValue().toString());
        }
        propertyDataStore.sortByColumn(0, true);
        propertyDataStore.setResultName("System Properties");
        propertyDataStore.resetStatus();
        return propertyDataStore;
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    public String getAlternateVerb() {
        return ALTERNATE_VERB;
    }

    @Override
    protected boolean isConnectionRequired() {
        return false;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }

    private static class PropertyDataStore
    extends DataStore {
        private boolean wbProps;

        PropertyDataStore(boolean bl) {
            super(new String[]{"PROPERTY", "VALUE"}, new int[]{12, 12});
            this.wbProps = bl;
            this.getColumns()[0].setIsPkColumn(true);
        }

        @Override
        public boolean checkUpdateTable() {
            return true;
        }

        @Override
        public boolean checkUpdateTable(WbConnection wbConnection) {
            return true;
        }

        @Override
        public boolean hasPkColumns() {
            return true;
        }

        @Override
        public boolean hasUpdateableColumns() {
            return true;
        }

        @Override
        public boolean isUpdateable() {
            return true;
        }

        @Override
        public boolean needPkForUpdate() {
            return true;
        }

        @Override
        public boolean pkColumnsComplete() {
            return true;
        }

        @Override
        public synchronized int updateDb(WbConnection wbConnection, JobErrorHandler jobErrorHandler) throws SQLException {
            Object object;
            int n = 0;
            this.resetUpdateRowCounters();
            for (int i = 0; i < this.getRowCount(); ++i) {
                object = this.getRow(i);
                if (((RowData)object).isOriginal()) continue;
                String string = this.getValueAsString(i, 0);
                String string2 = this.getValueAsString(i, 1);
                if (this.wbProps) {
                    Settings.getInstance().setProperty(string, string2);
                } else {
                    System.setProperty(string, string2);
                }
                this.getRow(i).resetStatus();
                ++n;
            }
            this.resetUpdateRowCounters();
            RowData rowData = this.getNextDeletedRow();
            while (rowData != null) {
                object = rowData.getValue(0).toString();
                if (this.wbProps) {
                    Settings.getInstance().removeProperty((String)object);
                } else {
                    System.clearProperty((String)object);
                }
                rowData = this.getNextDeletedRow();
                ++n;
            }
            this.resetStatus();
            return n;
        }

        @Override
        public List<DmlStatement> getUpdateStatements(WbConnection wbConnection) throws SQLException {
            return Collections.emptyList();
        }
    }
}

