/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands.console;

import java.sql.SQLException;
import java.util.List;
import workbench.db.ConnectionMgr;
import workbench.db.ConnectionProfile;
import workbench.db.ProfileGroupMap;
import workbench.resource.ResourceMgr;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.util.ArgumentParser;
import workbench.util.ArgumentType;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;

public class WbListProfiles
extends SqlCommand {
    public static final String VERB = "WbListProfiles";
    public static final String ARG_GROUP = "group";
    public static final String ARG_GROUPS_ONLY = "groupsOnly";

    public WbListProfiles() {
        this.cmdLine = new ArgumentParser();
        this.cmdLine.addArgument(ARG_GROUP);
        this.cmdLine.addArgument(ARG_GROUPS_ONLY, ArgumentType.BoolSwitch);
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    protected boolean isConnectionRequired() {
        return false;
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException, Exception {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        this.cmdLine.parse(this.getCommandLine(string));
        String string2 = null;
        if (this.cmdLine.isArgPresent(ARG_GROUP)) {
            string2 = this.cmdLine.getValue(ARG_GROUP);
        }
        boolean bl = this.cmdLine.getBoolean(ARG_GROUPS_ONLY);
        List<ConnectionProfile> list = CollectionUtil.arrayList();
        list.addAll(ConnectionMgr.getInstance().getProfiles());
        ProfileGroupMap profileGroupMap = new ProfileGroupMap(list);
        String string3 = ResourceMgr.getString("TxtUsername");
        for (String string4 : profileGroupMap.keySet()) {
            if (string2 != null && !string2.equalsIgnoreCase(string4)) continue;
            statementRunnerResult.addMessage(string4);
            if (bl) continue;
            List list2 = (List)profileGroupMap.get(string4);
            for (ConnectionProfile connectionProfile : list2) {
                String string5 = "  " + connectionProfile.getName();
                if (StringUtil.isNonBlank(connectionProfile.getUsername())) {
                    string5 = string5 + ", " + string3 + "=" + connectionProfile.getUsername();
                }
                string5 = string5 + ", URL=" + connectionProfile.getUrl();
                statementRunnerResult.addMessage(string5);
            }
        }
        statementRunnerResult.setSuccess();
        return statementRunnerResult;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

