/*
 * Decompiled with CFR 0.152.
 */
package workbench.storage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import workbench.db.importer.ValueDisplay;
import workbench.storage.ResultInfo;
import workbench.util.CollectionUtil;
import workbench.util.NumberUtil;
import workbench.util.StringUtil;

public class RowData {
    public static final int NOT_MODIFIED = 0;
    public static final int MODIFIED = 1;
    public static final int NEW = 2;
    private static final Object NO_CHANGE_MARKER = new Object();
    private int status = 0;
    private boolean dmlSent;
    private Object[] colData;
    private Object[] originalData;
    private List<String> dependencyDeletes;
    private Object userObject;
    private boolean normalizeNewlines;

    public RowData(Object[] objectArray) {
        this.colData = objectArray;
    }

    public RowData(ResultInfo resultInfo) {
        this(resultInfo.getColumnCount());
    }

    public RowData(int n) {
        this.colData = new Object[n];
        this.setNew();
    }

    public void setNormalizeNewLines(boolean bl) {
        this.normalizeNewlines = bl;
    }

    public Object[] getData() {
        return this.colData;
    }

    public RowData createCopy() {
        RowData rowData = new RowData(this.colData.length);
        System.arraycopy(this.colData, 0, rowData.colData, 0, this.colData.length);
        rowData.userObject = this.userObject;
        return rowData;
    }

    public int getColumnCount() {
        if (this.colData == null) {
            return 0;
        }
        return this.colData.length;
    }

    private void createOriginalData() {
        this.originalData = new Object[this.colData.length];
        Arrays.fill(this.originalData, NO_CHANGE_MARKER);
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object object) {
        this.userObject = object;
    }

    public void setValue(int n, Object object) throws IndexOutOfBoundsException {
        if (!this.isNew()) {
            Object object2 = this.colData[n];
            if (RowData.objectsAreEqual(object2, object, this.normalizeNewlines)) {
                return;
            }
            if (this.originalData == null) {
                this.createOriginalData();
            }
            if (this.originalData[n] == NO_CHANGE_MARKER) {
                this.originalData[n] = this.colData[n];
            }
        }
        this.colData[n] = object;
        this.setModified();
    }

    public Object getValue(int n) throws IndexOutOfBoundsException {
        return this.colData[n];
    }

    public Object getOriginalValue(int n) throws IndexOutOfBoundsException {
        if (!this.isNew() && this.isColumnModified(n)) {
            return this.originalData[n];
        }
        return this.getValue(n);
    }

    public Object restoreOriginalValue(int n) {
        if (this.originalData == null) {
            return null;
        }
        if (this.isColumnModified(n)) {
            this.colData[n] = this.originalData[n];
            this.resetStatusForColumn(n);
        }
        return this.colData[n];
    }

    public boolean restoreOriginalValues() {
        if (this.originalData == null) {
            return false;
        }
        for (int i = 0; i < this.originalData.length; ++i) {
            if (this.originalData[i] == null) continue;
            this.colData[i] = this.originalData[i];
        }
        this.originalData = null;
        this.resetStatus();
        return true;
    }

    public void resetStatusForColumn(int n) {
        if (!this.isNew() && this.originalData != null) {
            this.originalData[n] = NO_CHANGE_MARKER;
            for (Object object : this.originalData) {
                if (object == NO_CHANGE_MARKER) continue;
                return;
            }
            this.resetStatus();
        }
    }

    public boolean isColumnModified(int n) {
        if (this.isOriginal()) {
            return false;
        }
        if (this.isNew()) {
            return this.colData[n] != null;
        }
        if (this.originalData == null) {
            return false;
        }
        return this.originalData[n] != NO_CHANGE_MARKER;
    }

    public void resetStatus() {
        this.status = 0;
        this.dmlSent = false;
        this.originalData = null;
    }

    public void reset() {
        Arrays.fill(this.colData, null);
        this.resetStatus();
    }

    public final void setNew() {
        this.status = 2;
    }

    public boolean isOriginal() {
        return this.status == 0;
    }

    public boolean isModified() {
        return (this.status & 1) == 1;
    }

    public boolean isNew() {
        return (this.status & 2) == 2;
    }

    public void setModified() {
        this.status |= 1;
    }

    void setDmlSent(boolean bl) {
        this.dmlSent = bl;
    }

    public boolean isDmlSent() {
        return this.dmlSent;
    }

    public List<String> getDependencyDeletes() {
        return this.dependencyDeletes;
    }

    public void setDependencyDeletes(List<String> list) {
        this.dependencyDeletes = CollectionUtil.isEmpty(list) ? null : new ArrayList<String>(list);
    }

    public String toString() {
        ValueDisplay valueDisplay = new ValueDisplay(this.colData);
        return valueDisplay.toString();
    }

    public int hashCode() {
        int n = 7;
        n = 59 * n + (this.colData != null ? Arrays.hashCode(this.colData) : 0);
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof RowData)) {
            return false;
        }
        RowData rowData = (RowData)object;
        if (rowData.colData.length != this.colData.length) {
            return false;
        }
        for (int i = 0; i < this.colData.length; ++i) {
            if (RowData.objectsAreEqual(this.colData[i], rowData.colData[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean objectsAreEqual(Object object, Object object2) {
        return RowData.objectsAreEqual(object, object2, false);
    }

    public static boolean objectsAreEqual(Object object, Object object2, boolean bl) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (object instanceof byte[] && object2 instanceof byte[]) {
            return Arrays.equals((byte[])object, (byte[])object2);
        }
        if (object instanceof Number && object2 instanceof Number) {
            return NumberUtil.valuesAreEqual((Number)object, (Number)object2);
        }
        if (bl && object instanceof String && object2 instanceof String) {
            String string = object.toString();
            String string2 = object2.toString();
            if (RowData.containsNewLine(string) || RowData.containsNewLine(string2)) {
                String string3 = StringUtil.PATTERN_CRLF.matcher(string).replaceAll("\\n");
                String string4 = StringUtil.PATTERN_CRLF.matcher(string2).replaceAll("\\n");
                return string3.equals(string4);
            }
        }
        return object.equals(object2);
    }

    private static boolean containsNewLine(String string) {
        return string.indexOf(13) > -1 || string.indexOf(10) > -1;
    }

    public void dispose() {
        this.colData = null;
        this.originalData = null;
        if (this.dependencyDeletes != null) {
            this.dependencyDeletes.clear();
            this.dependencyDeletes = null;
        }
        this.userObject = null;
    }

    public void addColum() {
        Object[] objectArray = new Object[this.colData.length + 1];
        System.arraycopy(this.colData, 0, objectArray, 0, this.colData.length);
        this.colData = objectArray;
        this.resetStatus();
    }

    public void addColum(int n) {
        int n2 = this.colData.length;
        Object[] objectArray = new Object[n2 + 1];
        System.arraycopy(this.colData, 0, objectArray, 0, n);
        System.arraycopy(this.colData, n, objectArray, n + 1, n2 - n);
        this.colData = objectArray;
        this.resetStatus();
    }
}

