/*
 * Decompiled with CFR 0.152.
 */
package workbench.storage;

import java.util.ArrayList;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.ConnectionProfile;
import workbench.db.DbSettings;
import workbench.db.DefaultExpressionBuilder;
import workbench.db.DmlExpressionBuilder;
import workbench.db.DmlExpressionType;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.sql.formatter.FormatterUtil;
import workbench.storage.ColumnData;
import workbench.storage.DmlStatement;
import workbench.storage.ResultInfo;
import workbench.storage.RowData;
import workbench.util.SqlUtil;

public class StatementFactory {
    private ResultInfo resultInfo;
    private TableIdentifier tableToUse;
    private boolean includeTableOwner = true;
    private WbConnection dbConnection;
    private boolean emptyStringIsNull;
    private boolean includeNullInInsert = true;
    private boolean useColumnLabel;
    private boolean includeReadOnlyColumns;
    private boolean includeIdentityColumns;
    private DmlExpressionBuilder expressionBuilder;

    public StatementFactory(ResultInfo resultInfo, WbConnection wbConnection) {
        this.resultInfo = resultInfo;
        this.setCurrentConnection(wbConnection);
        this.expressionBuilder = DmlExpressionBuilder.Factory.getBuilder(wbConnection);
        this.includeIdentityColumns = !Settings.getInstance().getGenerateInsertIgnoreIdentity();
        this.includeReadOnlyColumns = !Settings.getInstance().getCheckEditableColumns();
    }

    public void setIncludeIdentiyColumns(boolean bl) {
        this.includeIdentityColumns = bl;
    }

    public void setIncludeReadOnlyColumns(boolean bl) {
        this.includeReadOnlyColumns = bl;
    }

    public void setUseColumnLabel(boolean bl) {
        this.useColumnLabel = bl;
    }

    public DmlStatement createUpdateStatement(RowData rowData, boolean bl, String string) {
        return this.createUpdateStatement(rowData, bl, string, null);
    }

    public DmlStatement createUpdateStatement(RowData rowData, boolean bl, String string, List<ColumnIdentifier> list) {
        Object object;
        int n;
        if (rowData == null) {
            return null;
        }
        boolean bl2 = true;
        int n2 = this.resultInfo.getColumnCount();
        if (!this.resultInfo.hasPkColumns()) {
            throw new IllegalArgumentException("Cannot proceed without a primary key");
        }
        DmlStatement dmlStatement = null;
        if (!bl && !rowData.isModified()) {
            return null;
        }
        ArrayList<ColumnData> arrayList = new ArrayList<ColumnData>(n2);
        StringBuilder stringBuilder = new StringBuilder(50);
        this.appendKeyword(stringBuilder, "UPDATE ");
        stringBuilder.append(this.getTableNameToUse());
        this.appendKeyword(stringBuilder, " SET ");
        bl2 = true;
        for (n = 0; n < n2; ++n) {
            if (list != null && !list.contains(this.resultInfo.getColumn(n)) || !rowData.isColumnModified(n) && (!bl || this.resultInfo.isPkColumn(n))) continue;
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(", ");
            }
            String string2 = this.getColumnName(n);
            stringBuilder.append(string2);
            object = rowData.getValue(n);
            if (this.isNull(object)) {
                this.appendKeyword(stringBuilder, " = NULL");
                continue;
            }
            stringBuilder.append(" = ");
            stringBuilder.append(this.getDmlExpression(this.resultInfo.getColumn(n)));
            arrayList.add(new ColumnData(object, this.resultInfo.getColumn(n)));
        }
        this.appendKeyword(stringBuilder, " WHERE ");
        bl2 = true;
        n = this.resultInfo.getColumnCount();
        for (int i = 0; i < n; ++i) {
            if (!this.resultInfo.isPkColumn(i)) continue;
            if (bl2) {
                bl2 = false;
            } else {
                this.appendKeyword(stringBuilder, " AND ");
            }
            object = this.getColumnName(i);
            stringBuilder.append((String)object);
            Object object2 = rowData.getOriginalValue(i);
            if (object2 == null) {
                this.appendKeyword(stringBuilder, " IS NULL");
                continue;
            }
            stringBuilder.append(" = ");
            stringBuilder.append(this.getDmlExpression(this.resultInfo.getColumn(i)));
            arrayList.add(new ColumnData(object2, this.resultInfo.getColumn(i)));
        }
        dmlStatement = new DmlStatement(stringBuilder.toString(), arrayList);
        return dmlStatement;
    }

    private String getDmlExpression(ColumnIdentifier columnIdentifier) {
        return this.expressionBuilder.getDmlExpression(columnIdentifier, DmlExpressionType.Any);
    }

    private String getColumnName(int n) {
        String string = this.useColumnLabel ? this.resultInfo.getColumnDisplayName(n) : this.resultInfo.getColumnName(n);
        return this.adjustColumnName(string);
    }

    void setTestSettings(DbSettings dbSettings) {
        if (this.expressionBuilder instanceof DefaultExpressionBuilder) {
            ((DefaultExpressionBuilder)this.expressionBuilder).setDbSettings(dbSettings);
        }
    }

    public DmlStatement createInsertStatement(RowData rowData, boolean bl, String string) {
        return this.createInsertStatement(rowData, bl, string, null);
    }

    private boolean includeInsertColumn(ColumnIdentifier columnIdentifier) {
        if (columnIdentifier.isAutoGenerated()) {
            if (!this.includeIdentityColumns) {
                LogMgr.logDebug(new CallerInfo(){}, "Ignoring column " + this.getTableNameToUse() + "." + columnIdentifier.getColumnName() + " because it is an auto-increment/identity column");
                return false;
            }
        } else {
            if (this.includeReadOnlyColumns) {
                return true;
            }
            if (columnIdentifier.getComputedColumnExpression() != null) {
                LogMgr.logDebug(new CallerInfo(){}, "Ignoring column " + this.getTableNameToUse() + "." + columnIdentifier.getColumnName() + " because it is a computed column");
                return false;
            }
            if (!columnIdentifier.isUpdateable() || columnIdentifier.isReadonly()) {
                LogMgr.logDebug(new CallerInfo(){}, "Ignoring column " + this.getTableNameToUse() + "." + columnIdentifier.getColumnName() + " because it is marked as not updateable");
                return false;
            }
        }
        return true;
    }

    public DmlStatement createInsertStatement(RowData rowData, boolean bl, String string, List<ColumnIdentifier> list) {
        if (!bl && !rowData.isModified()) {
            return null;
        }
        int n = this.resultInfo.getColumnCount();
        ArrayList<ColumnData> arrayList = new ArrayList<ColumnData>(n);
        StringBuilder stringBuilder = new StringBuilder(250);
        this.appendKeyword(stringBuilder, "INSERT INTO ");
        stringBuilder.append(this.getTableNameToUse());
        stringBuilder.append(" (");
        StringBuilder stringBuilder2 = new StringBuilder(250);
        boolean bl2 = true;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            boolean bl3;
            ColumnIdentifier columnIdentifier = this.resultInfo.getColumn(i);
            boolean bl4 = false;
            if (list == null ? !this.includeInsertColumn(columnIdentifier) : !(bl4 = ColumnIdentifier.containsColumn(list, columnIdentifier))) continue;
            ++n2;
            Object object = rowData.getValue(i);
            boolean bl5 = this.isNull(object);
            boolean bl6 = bl3 = bl || rowData.isColumnModified(i);
            if (bl5) {
                boolean bl7 = bl3 = bl3 || this.includeNullInInsert;
            }
            if (!bl3) continue;
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(',');
                stringBuilder2.append(',');
            }
            stringBuilder.append(this.getColumnName(i));
            stringBuilder2.append(this.getDmlExpression(columnIdentifier));
            arrayList.add(new ColumnData(object, columnIdentifier));
        }
        this.appendKeyword(stringBuilder, ") VALUES (");
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append(')');
        DmlStatement dmlStatement = new DmlStatement(stringBuilder.toString(), arrayList);
        if (n2 == 0) {
            LogMgr.logError(new CallerInfo(){}, "No columns included in the INSERT statement for the table " + this.getTableNameToUse() + " Please turn on DEBUG logging to see why the columns where excluded", null);
        }
        return dmlStatement;
    }

    public DmlStatement createDeleteStatement(RowData rowData) {
        return this.createDeleteStatement(rowData, false);
    }

    public DmlStatement createDeleteStatement(RowData rowData, boolean bl) {
        if (rowData == null) {
            return null;
        }
        if (!bl && rowData.isNew()) {
            return null;
        }
        boolean bl2 = true;
        int n = this.resultInfo.getColumnCount();
        ArrayList<ColumnData> arrayList = new ArrayList<ColumnData>(n);
        StringBuilder stringBuilder = new StringBuilder(250);
        this.appendKeyword(stringBuilder, "DELETE FROM ");
        stringBuilder.append(this.getTableNameToUse());
        this.appendKeyword(stringBuilder, " WHERE ");
        bl2 = true;
        for (int i = 0; i < n; ++i) {
            if (!this.resultInfo.isPkColumn(i)) continue;
            if (bl2) {
                bl2 = false;
            } else {
                this.appendKeyword(stringBuilder, " AND ");
            }
            stringBuilder.append(this.getColumnName(i));
            Object object = rowData.getOriginalValue(i);
            if (this.isNull(object)) {
                object = null;
            }
            if (object == null) {
                this.appendKeyword(stringBuilder, " IS NULL");
                continue;
            }
            stringBuilder.append(" = ");
            stringBuilder.append(this.getDmlExpression(this.resultInfo.getColumn(i)));
            arrayList.add(new ColumnData(object, this.resultInfo.getColumn(i)));
        }
        DmlStatement dmlStatement = new DmlStatement(stringBuilder.toString(), arrayList);
        return dmlStatement;
    }

    public void setTableToUse(TableIdentifier tableIdentifier) {
        this.tableToUse = tableIdentifier;
    }

    public void setIncludeTableOwner(boolean bl) {
        this.includeTableOwner = bl;
    }

    public void setEmptyStringIsNull(boolean bl) {
        this.emptyStringIsNull = bl;
    }

    public void setIncludeNullInInsert(boolean bl) {
        this.includeNullInInsert = bl;
    }

    public final void setCurrentConnection(WbConnection wbConnection) {
        this.dbConnection = wbConnection;
        if (this.dbConnection != null) {
            ConnectionProfile connectionProfile = this.dbConnection.getProfile();
            this.emptyStringIsNull = connectionProfile == null ? true : connectionProfile.getEmptyStringIsNull();
            this.includeNullInInsert = connectionProfile == null ? true : connectionProfile.getIncludeNullInInsert();
        }
    }

    private String adjustColumnName(String string) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        string2 = this.dbConnection == null ? SqlUtil.quoteObjectname(string, false, true, '\"') : this.dbConnection.getMetadata().quoteObjectname(string);
        return FormatterUtil.getIdentifier(string2);
    }

    private TableIdentifier getUpdateTable() {
        return this.tableToUse != null ? this.tableToUse : this.resultInfo.getUpdateTable();
    }

    private String getTableNameToUse() {
        String string = null;
        TableIdentifier tableIdentifier = this.getUpdateTable();
        if (tableIdentifier == null) {
            throw new IllegalArgumentException("Cannot proceed without update table defined");
        }
        TableIdentifier tableIdentifier2 = tableIdentifier.createCopy();
        tableIdentifier2.adjustCase(this.dbConnection);
        if (this.includeTableOwner) {
            string = tableIdentifier2.getTableExpression(this.dbConnection);
        } else {
            string = this.dbConnection == null ? SqlUtil.quoteObjectname(tableIdentifier2.getTableName(), false, true, '\"') : this.dbConnection.getMetadata().quoteObjectname(tableIdentifier2.getTableName());
            string = FormatterUtil.getIdentifier(string);
        }
        return string;
    }

    private void appendKeyword(StringBuilder stringBuilder, String string) {
        stringBuilder.append(FormatterUtil.getKeyword(string));
    }

    private boolean isNull(Object object) {
        if (object == null) {
            return true;
        }
        String string = object.toString();
        return this.emptyStringIsNull && string.isEmpty();
    }
}

