/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.UnknownHostException;
import java.sql.SQLException;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;

public class ExceptionUtil {
    private ExceptionUtil() {
    }

    public static StringBuilder getSqlStateString(SQLException sQLException) {
        StringBuilder stringBuilder = new StringBuilder(30);
        try {
            int n;
            String string = sQLException.getSQLState();
            if (string != null && string.length() > 0) {
                stringBuilder.append("SQL State=");
                stringBuilder.append(string);
            }
            if ((n = sQLException.getErrorCode()) != 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append("DB Errorcode=");
                stringBuilder.append(Integer.toString(n));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return stringBuilder;
    }

    public static StringBuilder getAllExceptions(Throwable throwable) {
        if (throwable instanceof SQLException) {
            return ExceptionUtil.getAllExceptions((SQLException)throwable);
        }
        StringBuilder stringBuilder = new StringBuilder(100);
        ExceptionUtil.getDisplayBuffer(stringBuilder, throwable, false);
        for (Throwable throwable2 = throwable.getCause(); throwable2 != null; throwable2 = throwable2.getCause()) {
            stringBuilder.append("\nCaused by: ");
            ExceptionUtil.getDisplayBuffer(stringBuilder, throwable2, false);
        }
        return stringBuilder;
    }

    public static StringBuilder getAllExceptions(SQLException sQLException) {
        StringBuilder stringBuilder = new StringBuilder(100);
        ExceptionUtil.getDisplayBuffer(stringBuilder, sQLException, false);
        for (SQLException sQLException2 = sQLException.getNextException(); sQLException2 != null; sQLException2 = sQLException2.getNextException()) {
            stringBuilder.append("\nNext: ");
            ExceptionUtil.getDisplayBuffer(stringBuilder, sQLException2, false);
        }
        return stringBuilder;
    }

    public static String getDisplay(Throwable throwable) {
        if (throwable instanceof SQLException) {
            return ExceptionUtil.getAllExceptions((SQLException)throwable).toString().trim();
        }
        return ExceptionUtil.getDisplay(throwable, false).trim();
    }

    public static String getDisplay(Throwable throwable, boolean bl) {
        return ExceptionUtil.getDisplayBuffer(null, throwable, bl).toString();
    }

    public static StringBuilder getDisplayBuffer(StringBuilder stringBuilder, Throwable throwable, boolean bl) {
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder(50);
        }
        try {
            Object object;
            Appendable appendable;
            if (throwable.getMessage() == null) {
                stringBuilder.append(throwable.getClass().getName());
                if (!bl) {
                    bl = throwable instanceof NullPointerException;
                }
            } else {
                stringBuilder.append(throwable.getMessage().trim());
            }
            if (throwable.getCause() instanceof UnknownHostException) {
                stringBuilder.append(" (UnknownHost)");
            }
            if (throwable instanceof SQLException && (appendable = ExceptionUtil.getSqlStateString((SQLException)(object = (SQLException)throwable))).length() > 0) {
                stringBuilder.append(" [");
                stringBuilder.append((CharSequence)((Object)appendable));
                stringBuilder.append("] ");
            }
            if (bl) {
                object = new StringWriter();
                appendable = new PrintWriter((Writer)object);
                throwable.printStackTrace((PrintWriter)appendable);
                stringBuilder.append("\n");
                stringBuilder.append(((StringWriter)object).getBuffer());
            }
        }
        catch (Throwable throwable2) {
            LogMgr.logError(new CallerInfo(){}, "Error while creating display string", throwable2);
            stringBuilder.append("Exception: ");
            stringBuilder.append(throwable.getClass().getName());
        }
        return stringBuilder;
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter(250);
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }
}

