/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.io.BufferedReader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatterBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import workbench.util.CharacterEscapeType;
import workbench.util.CharacterRange;
import workbench.util.CollectionUtil;
import workbench.util.ExceptionUtil;
import workbench.util.FileUtil;
import workbench.util.HtmlUtil;
import workbench.util.NumberStringCache;
import workbench.util.QuoteEscapeType;
import workbench.util.WbStringTokenizer;

public class StringUtil {
    public static final String REGEX_CRLF = "((\r\n)|(\n\r)|\r|\n)";
    public static final Pattern PATTERN_CRLF = Pattern.compile("((\r\n)|(\n\r)|\r|\n)");
    public static final String LINE_TERMINATOR = System.getProperty("line.separator");
    public static final String EMPTY_STRING = "";
    public static final String ISO_DATE_FORMAT = "yyyy-MM-dd";
    public static final String ISO_TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String ISO_TZ_TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS z";
    private static final SimpleDateFormat ISO_TIMESTAMP_FORMATTER = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static final SimpleDateFormat ISO_TZ_TIMESTAMP_FORMATTER = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS z");
    private static final char[] HEX_DIGIT = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final Pattern PATTERN_NON_LF = Pattern.compile("(\r\n)|(\n\r)|(\r)|(\u000b)");
    public static final Comparator<String> NATURAL_COMPARATOR = (string, string2) -> StringUtil.naturalCompare(string, string2, true);
    private static final int[] LIMITS = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
    public static final String REGEX_SPECIAL_CHARS = "\\[](){}.*+?$^|";
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\$\\{[0-9a-zA-Z_\\.\\-]*\\}");

    public static StringBuilder emptyBuilder() {
        return new StringBuilder(0);
    }

    public static SimpleDateFormat getIsoTimestampFormatter() {
        return new SimpleDateFormat(ISO_TIMESTAMP_FORMAT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatIsoTimestamp(long l) {
        String string = ISO_TIMESTAMP_FORMAT;
        synchronized (ISO_TIMESTAMP_FORMAT) {
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return ISO_TIMESTAMP_FORMATTER.format(new Date(l));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCurrentTimestamp() {
        String string = ISO_TIMESTAMP_FORMAT;
        synchronized (ISO_TIMESTAMP_FORMAT) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return ISO_TIMESTAMP_FORMATTER.format(StringUtil.now());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCurrentTimestampWithTZString() {
        String string = ISO_TZ_TIMESTAMP_FORMAT;
        synchronized (ISO_TZ_TIMESTAMP_FORMAT) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return ISO_TZ_TIMESTAMP_FORMATTER.format(StringUtil.now());
        }
    }

    public static String isDatePatternValid(String string) {
        if (StringUtil.isBlank(string)) {
            return null;
        }
        try {
            new DateTimeFormatterBuilder().appendPattern(string);
        }
        catch (Exception exception) {
            return ExceptionUtil.getDisplay(exception);
        }
        return null;
    }

    public static Date parseISODate(String string) {
        if (StringUtil.isBlank(string)) {
            return null;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(ISO_DATE_FORMAT);
            return simpleDateFormat.parse(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Date now() {
        return new Date(System.currentTimeMillis());
    }

    public static String getPathSeparator() {
        return System.getProperty("path.separator");
    }

    public static int hashCode(CharSequence charSequence) {
        int n = charSequence.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 = 31 * n2 + charSequence.charAt(i);
        }
        return n2;
    }

    public static String makePlainLinefeed(String string) {
        Matcher matcher = PATTERN_NON_LF.matcher(string);
        return matcher.replaceAll("\n");
    }

    public static boolean endsWith(CharSequence charSequence, String string) {
        if (charSequence == null) {
            return false;
        }
        if (StringUtil.isEmptyString(string)) {
            return false;
        }
        int n = charSequence.length();
        if (n == 0) {
            return false;
        }
        if (n < string.length()) {
            return false;
        }
        String string2 = charSequence.subSequence(n - string.length(), n).toString();
        return string.equals(string2);
    }

    public static boolean endsWith(CharSequence charSequence, char c) {
        if (charSequence == null) {
            return false;
        }
        int n = charSequence.length();
        if (n == 0) {
            return false;
        }
        return charSequence.charAt(n - 1) == c;
    }

    public static boolean lineStartsWith(CharSequence charSequence, int n, String string) {
        if (StringUtil.isEmptyString(string)) {
            return false;
        }
        if (StringUtil.isEmptyString(charSequence)) {
            return false;
        }
        int n2 = charSequence.length();
        int n3 = string.length();
        int n4 = StringUtil.findFirstNonWhitespace(charSequence, n, false);
        if (n4 > n) {
            n = n4;
        }
        for (int i = 0; i < n3; ++i) {
            char c = '\u0000';
            char c2 = string.charAt(i);
            if (n + i < n2) {
                c = charSequence.charAt(n + i);
            }
            if (c == c2) continue;
            return false;
        }
        return true;
    }

    public static int getRealLineLength(String string) {
        int n = string.length();
        if (n == 0) {
            return 0;
        }
        char c = string.charAt(n - 1);
        while (n > 0 && (c == '\r' || c == '\n')) {
            if (--n <= 0) continue;
            c = string.charAt(n - 1);
        }
        return n;
    }

    public static boolean isWhitespace(CharSequence charSequence) {
        if (charSequence == null) {
            return false;
        }
        int n = charSequence.length();
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            char c = charSequence.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    public static String trim(String string) {
        if (string == null) {
            return string;
        }
        return string.trim();
    }

    public static String trimToNull(String string) {
        String string2 = StringUtil.trim(string);
        if (StringUtil.isEmptyString(string2)) {
            return null;
        }
        return string2;
    }

    public static String removeTrailing(String string, char c) {
        if (string == null) {
            return string;
        }
        int n = string.length();
        if (n == 0) {
            return string;
        }
        char c2 = string.charAt(n - 1);
        if (c2 != c) {
            return string;
        }
        while (n > 0 && string.charAt(n - 1) == c) {
            --n;
        }
        return string.substring(0, n);
    }

    public static String rtrim(String string) {
        if (string == null) {
            return string;
        }
        int n = string.length();
        if (n == 0) {
            return string;
        }
        char c = string.charAt(n - 1);
        if (c > ' ') {
            return string;
        }
        while (n > 0 && string.charAt(n - 1) <= ' ') {
            --n;
        }
        return string.substring(0, n);
    }

    public static CharSequence rtrim(CharSequence charSequence) {
        if (charSequence == null) {
            return charSequence;
        }
        int n = charSequence.length();
        if (n == 0) {
            return charSequence;
        }
        char c = charSequence.charAt(n - 1);
        if (c > ' ') {
            return charSequence;
        }
        while (n > 0 && charSequence.charAt(n - 1) <= ' ') {
            --n;
        }
        return charSequence.subSequence(0, n);
    }

    public static int indexOf(CharSequence charSequence, char c) {
        return StringUtil.indexOf(charSequence, c, 1);
    }

    public static int indexOf(CharSequence charSequence, char c, int n) {
        if (charSequence == null) {
            return -1;
        }
        if (n <= 0) {
            n = 1;
        }
        int n2 = 0;
        for (int i = 0; i < charSequence.length(); ++i) {
            if (charSequence.charAt(i) != c || ++n2 != n) continue;
            return i;
        }
        return -1;
    }

    public static void trimTrailingWhitespace(StringBuilder stringBuilder) {
        if (stringBuilder == null || stringBuilder.length() == 0) {
            return;
        }
        int n = stringBuilder.length();
        int n2 = n - 1;
        char c = stringBuilder.charAt(n2);
        if (!Character.isWhitespace(c)) {
            return;
        }
        while (n2 > 0 && Character.isWhitespace(stringBuilder.charAt(n2 - 1))) {
            --n2;
        }
        stringBuilder.setLength(n2);
    }

    public static boolean isMixedCase(String string) {
        return !StringUtil.isUpperCase(string) && !StringUtil.isLowerCase(string);
    }

    public static boolean isLowerCase(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!Character.isUpperCase(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isUpperCase(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!Character.isLowerCase(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean arraysEqual(String[] stringArray, String[] stringArray2) {
        if (stringArray == null && stringArray2 == null) {
            return true;
        }
        if (stringArray == null || stringArray2 == null) {
            return false;
        }
        if (stringArray.length != stringArray2.length) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (StringUtil.equalString(stringArray[i], stringArray2[i])) continue;
            return false;
        }
        return true;
    }

    public static String toLowerCase(String string) {
        if (string == null) {
            return null;
        }
        return string.toLowerCase();
    }

    public static String[] toUpperCase(String[] stringArray) {
        if (stringArray == null) {
            return stringArray;
        }
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i] == null ? null : stringArray[i].toUpperCase();
        }
        return stringArray2;
    }

    public static boolean hasOpenQuotes(String string, char c, QuoteEscapeType quoteEscapeType) {
        if (StringUtil.isEmptyString(string)) {
            return false;
        }
        int n = string.length();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            char c2;
            char c3 = string.charAt(i);
            if (c3 != c) continue;
            if (quoteEscapeType == QuoteEscapeType.escape) {
                c2 = '\u0000';
                if (i > 1) {
                    c2 = string.charAt(i - 1);
                }
                if (c2 == '\\') continue;
                bl = !bl;
                continue;
            }
            if (quoteEscapeType == QuoteEscapeType.duplicate) {
                c2 = '\u0000';
                if (i < string.length() - 1) {
                    c2 = string.charAt(i + 1);
                }
                if (c2 == c) {
                    ++i;
                    continue;
                }
                bl = !bl;
                continue;
            }
            bl = !bl;
        }
        return bl;
    }

    public static String capitalize(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.toLowerCase());
        char c = stringBuilder.charAt(0);
        stringBuilder.setCharAt(0, Character.toUpperCase(c));
        return stringBuilder.toString();
    }

    public static String makeFilename(String string) {
        return StringUtil.makeFilename(string, true);
    }

    public static String makeFilename(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        if (string.equals("..")) {
            return "__";
        }
        if (string.equals(".")) {
            return "_";
        }
        String string2 = string.replaceAll("[\t:\\\\/\\?\\*\\|<>\"'%\u00a7\\^&\u0000]", EMPTY_STRING);
        return bl ? string2.toLowerCase() : string2;
    }

    public static int lastIndexOf(CharSequence charSequence, char c) {
        if (charSequence == null) {
            return -1;
        }
        int n = charSequence.length();
        if (n == 0) {
            return -1;
        }
        for (int i = n - 1; i > 0; --i) {
            if (charSequence.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    public static String replace(String string, String string2, String string3) {
        if (string3 == null) {
            return string;
        }
        if (string2 == null) {
            return string;
        }
        if (string == null) {
            return null;
        }
        int n = string.indexOf(string2);
        if (n == -1) {
            return string;
        }
        int n2 = string3.length() - string2.length() * 2;
        if (n2 < 0) {
            n2 = 0;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + n2);
        int n3 = 0;
        int n4 = string2.length();
        while (n != -1) {
            stringBuilder.append(string.substring(n3, n));
            stringBuilder.append(string3);
            n3 = n + n4;
            n = string.indexOf(string2, n3);
        }
        if (n3 < string.length()) {
            stringBuilder.append(string.substring(n3));
        }
        return stringBuilder.toString();
    }

    public static int numDigits(int n) {
        for (int i = 0; i < LIMITS.length; ++i) {
            if (n > LIMITS[i]) continue;
            return i + 1;
        }
        return LIMITS.length + 1;
    }

    public static String getLongestLine(String string, int n) {
        int n2;
        if (StringUtil.isEmptyString(string)) {
            return EMPTY_STRING;
        }
        Matcher matcher = PATTERN_CRLF.matcher(string);
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (matcher.find(n3)) {
            ++n4;
            n2 = matcher.start();
            int n8 = n2 - n3;
            if (n8 > n5) {
                n6 = n3;
                n7 = n2;
                n5 = n8;
            }
            n3 = n2 + 1;
            if (n4 < n) continue;
            break;
        }
        if (matcher.hitEnd() && (n2 = string.length() - n3) > n5) {
            n5 = n2;
            n6 = n3;
            n7 = string.length();
        }
        if (n6 >= 0 && n7 <= string.length()) {
            return string.substring(n6, n7);
        }
        return string;
    }

    public static boolean isNumber(String string) {
        if (string == null) {
            return false;
        }
        try {
            Double.parseDouble(string);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static boolean isNonBlank(CharSequence charSequence) {
        return !StringUtil.isBlank(charSequence);
    }

    public static boolean isBlank(CharSequence charSequence) {
        if (StringUtil.isEmptyString(charSequence)) {
            return true;
        }
        return StringUtil.isWhitespace(charSequence);
    }

    public static boolean isNonEmpty(CharSequence charSequence) {
        return charSequence != null && charSequence.length() > 0;
    }

    public static boolean isEmptyString(CharSequence charSequence) {
        if (charSequence == null) {
            return true;
        }
        return charSequence.length() == 0;
    }

    public static boolean allEmpty(CharSequence ... charSequenceArray) {
        if (charSequenceArray == null) {
            return true;
        }
        for (CharSequence charSequence : charSequenceArray) {
            if (!StringUtil.isNonEmpty(charSequence)) continue;
            return false;
        }
        return true;
    }

    public static char getFirstNonWhitespace(CharSequence charSequence) {
        int n = StringUtil.findFirstNonWhitespace(charSequence);
        if (n > -1 && n < charSequence.length()) {
            return charSequence.charAt(n);
        }
        return '\u0000';
    }

    public static int findFirstNonWhitespace(CharSequence charSequence) {
        return StringUtil.findFirstNonWhitespace(charSequence, 0, true);
    }

    public static int findFirstNonWhitespace(CharSequence charSequence, int n, boolean bl) {
        if (charSequence == null) {
            return -1;
        }
        int n2 = charSequence.length();
        if (n2 == 0) {
            return -1;
        }
        if (n >= n2) {
            return -1;
        }
        int n3 = n;
        char c = charSequence.charAt(n3);
        do {
            c = charSequence.charAt(n3);
            if (!(bl || c != '\n' && c != '\r')) {
                return -1;
            }
            if (c <= ' ') continue;
            return n3;
        } while (++n3 < n2);
        return -1;
    }

    public static String getStartingWhiteSpace(String string) {
        if (string == null) {
            return null;
        }
        int n = StringUtil.findFirstNonWhitespace(string);
        if (n <= 0) {
            return null;
        }
        String string2 = string.substring(0, n);
        return string2;
    }

    public static double getDoubleValue(String string, double d) {
        if (string == null) {
            return d;
        }
        double d2 = d;
        try {
            d2 = Double.parseDouble(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return d2;
    }

    public static int getIntValue(String string) {
        return StringUtil.getIntValue(string, 0);
    }

    public static int getIntValue(String string, int n) {
        if (string == null) {
            return n;
        }
        int n2 = n;
        try {
            n2 = Integer.parseInt(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n2;
    }

    public static long getLongValue(String string, long l) {
        if (string == null) {
            return l;
        }
        long l2 = l;
        try {
            l2 = Long.parseLong(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return l2;
    }

    public static boolean equalStringOrEmpty(String string, String string2) {
        if (StringUtil.isBlank(string) && StringUtil.isBlank(string2)) {
            return true;
        }
        return StringUtil.equalString(string, string2);
    }

    public static boolean equalStringOrEmpty(String string, String string2, boolean bl) {
        if (StringUtil.isBlank(string) && StringUtil.isBlank(string2)) {
            return true;
        }
        return StringUtil.compareStrings(string, string2, bl) == 0;
    }

    public static boolean equalString(String string, String string2) {
        return StringUtil.compareStrings(string, string2, false) == 0;
    }

    public static boolean stringsAreNotEqual(String string, String string2) {
        return StringUtil.compareStrings(string, string2, false) != 0;
    }

    public static String concatWithSeparator(String string, String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return EMPTY_STRING;
        }
        StringBuilder stringBuilder = new StringBuilder(stringArray.length * 10);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!StringUtil.isNonBlank(stringArray[i])) continue;
            if (i > 0 && stringBuilder.length() > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(stringArray[i]);
        }
        return stringBuilder.toString();
    }

    public static int compareStrings(String string, String string2, boolean bl) {
        if (string == null && string2 == null) {
            return 0;
        }
        if (string == null) {
            return -1;
        }
        if (string2 == null) {
            return 1;
        }
        if (bl) {
            return string.compareToIgnoreCase(string2);
        }
        return string.compareTo(string2);
    }

    public static boolean equalStringIgnoreCase(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        return string.equalsIgnoreCase(string2);
    }

    public static List<String> stringToList(String string) {
        return StringUtil.stringToList(string, ",");
    }

    public static List<String> stringToList(String string, String string2) {
        return StringUtil.stringToList(string, string2, false, false);
    }

    public static List<String> stringToList(String string, String string2, boolean bl) {
        return StringUtil.stringToList(string, string2, bl, false);
    }

    public static List<String> stringToList(String string, String string2, boolean bl, boolean bl2) {
        return StringUtil.stringToList(string, string2, bl, bl2, false, false);
    }

    public static List<String> stringToList(String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        return StringUtil.stringToList(string, string2, bl, bl2, bl3, false);
    }

    public static List<String> stringToList(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (StringUtil.isEmptyString(string)) {
            return new ArrayList<String>(0);
        }
        WbStringTokenizer wbStringTokenizer = new WbStringTokenizer(string, string2);
        wbStringTokenizer.setDelimiterNeedsWhitspace(false);
        wbStringTokenizer.setKeepQuotes(bl4);
        wbStringTokenizer.setCheckBrackets(bl3);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (wbStringTokenizer.hasMoreTokens()) {
            String string3 = wbStringTokenizer.nextToken();
            if (string3 == null) continue;
            if (bl2) {
                string3 = string3.trim();
            }
            if (bl && StringUtil.isEmptyString(string3)) continue;
            arrayList.add(string3);
        }
        return arrayList;
    }

    public static String[] toArray(Collection<String> collection, boolean bl) {
        return StringUtil.toArray(collection, bl, false);
    }

    public static String[] toArray(Collection<String> collection, boolean bl, boolean bl2) {
        if (collection == null) {
            return null;
        }
        if (collection.isEmpty()) {
            return new String[0];
        }
        if (bl2) {
            Set<String> set = CollectionUtil.caseInsensitiveSet();
            set.addAll(collection);
            collection = set;
        }
        int n = 0;
        String[] stringArray = new String[collection.size()];
        for (String string : collection) {
            stringArray[n++] = string == null ? null : (bl ? string.toUpperCase() : string);
        }
        return stringArray;
    }

    public static String listToString(Collection collection, char c) {
        return StringUtil.listToString(collection, String.valueOf(c), false);
    }

    public static String listToString(Collection collection, char c, boolean bl) {
        return StringUtil.listToString(collection, String.valueOf(c), bl);
    }

    public static String listToString(Collection collection, String string, boolean bl) {
        return StringUtil.listToString(collection, string, bl, '\"');
    }

    public static String listToString(Collection collection, String string, boolean bl, char c) {
        if (collection == null || collection.isEmpty()) {
            return EMPTY_STRING;
        }
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder(collection.size() * 50);
        for (Object e : collection) {
            if (e == null) continue;
            if (n > 0) {
                stringBuilder.append(string);
            }
            if (bl) {
                stringBuilder.append(c);
            }
            stringBuilder.append(e.toString());
            if (bl) {
                stringBuilder.append(c);
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    public static String removeQuotes(String string, String string2) {
        if (StringUtil.isEmptyString(string)) {
            return string;
        }
        if ((string = string.trim()).equals(string2)) {
            return string;
        }
        if (!string.startsWith(string2) || !string.endsWith(string2)) {
            return string;
        }
        return string.substring(string2.length(), string.length() - string2.length());
    }

    public static String removeBrackets(String string) {
        if (StringUtil.isEmptyString(string)) {
            return string;
        }
        if (string.length() < 2) {
            return string;
        }
        char c = string.charAt(0);
        char c2 = string.charAt(string.length() - 1);
        if (c == '(' && c2 == ')' || c == '{' && c2 == '}' || c == '[' && c2 == '}') {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static String trimQuotes(String string) {
        if (StringUtil.isBlank(string)) {
            return string;
        }
        String string2 = string.trim();
        int n = string2.length();
        if (n < 2) {
            return string;
        }
        char c = string2.charAt(0);
        char c2 = string2.charAt(n - 1);
        if (c == '\"' && c2 == '\"' || c == '\'' && c2 == '\'') {
            return string2.substring(1, n - 1);
        }
        return string;
    }

    public static String trimQuotes(String string, char c) {
        if (StringUtil.isBlank(string)) {
            return string;
        }
        String string2 = string.trim();
        int n = string2.length();
        if (n < 2) {
            return string;
        }
        char c2 = string2.charAt(0);
        char c3 = string2.charAt(n - 1);
        if (c2 == c && c3 == c) {
            return string2.substring(1, n - 1);
        }
        return string;
    }

    public static boolean isBoolean(String string) {
        if (string == null) {
            return false;
        }
        return "false".equalsIgnoreCase(string) || "true".equalsIgnoreCase(string);
    }

    public static boolean stringToBool(String string) {
        if (string == null) {
            return false;
        }
        return "true".equalsIgnoreCase(string = string.trim()) || "1".equals(string) || "y".equalsIgnoreCase(string) || "yes".equalsIgnoreCase(string) || "on".equalsIgnoreCase(string);
    }

    public static String getMaxSubstring(String string, int n, String string2) {
        if (string == null) {
            return EMPTY_STRING;
        }
        if (n < 1) {
            return string;
        }
        if (string.length() < n) {
            return string;
        }
        if (string2 == null) {
            return string.substring(0, n);
        }
        return string.substring(0, n) + string2;
    }

    public static String getMaxSubstring(String string, int n) {
        return StringUtil.getMaxSubstring(string, n, "...");
    }

    public static String quoteRegexMeta(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return EMPTY_STRING;
        }
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n + 5);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (REGEX_SPECIAL_CHARS.indexOf(c) != -1) {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static int findPreviousWhitespace(String string, int n) {
        if (string == null) {
            return -1;
        }
        int n2 = string.length();
        if (n > n2 || n <= 1) {
            return -1;
        }
        for (int i = n; i > 0; --i) {
            if (!Character.isWhitespace(string.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public static int findWordBoundary(String string, int n, String string2) {
        if (string2 == null) {
            return StringUtil.findPreviousWhitespace(string, n);
        }
        if (string == null) {
            return -1;
        }
        int n2 = string.length();
        if (n > n2) {
            return -1;
        }
        if (n == n2) {
            --n;
        }
        if (n <= 1) {
            return 0;
        }
        for (int i = n; i > 0; --i) {
            char c = string.charAt(i);
            if (string2.indexOf(c) <= -1 && !Character.isWhitespace(c)) continue;
            return i;
        }
        return 0;
    }

    public static String getFirstWord(String string) {
        if (StringUtil.isEmptyString(string)) {
            return EMPTY_STRING;
        }
        int n = StringUtil.findFirstWhiteSpace(string = string.trim());
        if (n < 0) {
            return string;
        }
        return string.substring(0, n);
    }

    public static int findFirstWhiteSpace(CharSequence charSequence) {
        return StringUtil.findFirstWhiteSpace(charSequence, '\"');
    }

    public static int findFirstWhiteSpace(CharSequence charSequence, char c) {
        if (charSequence == null) {
            return -1;
        }
        int n = charSequence.length();
        if (n == 0) {
            return -1;
        }
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            char c2 = charSequence.charAt(i);
            if (c2 == c) {
                boolean bl2 = bl = !bl;
            }
            if (bl || !Character.isWhitespace(charSequence.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public static String findWordLeftOfCursor(String string, int n) {
        if (n < 0) {
            return null;
        }
        try {
            int n2 = n;
            char c = string.charAt(n2);
            while (n2 > 0 && Character.isWhitespace(c)) {
                c = string.charAt(--n2);
            }
            if (n2 > 0) {
                return StringUtil.getWordLeftOfCursor(string, n2 + 1, null);
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getWordLeftOfCursor(String string, int n, String string2) {
        try {
            if (n < 0) {
                return null;
            }
            int n2 = string.length();
            int n3 = -1;
            n3 = n >= n2 ? n2 - 1 : n - 1;
            if (n3 < 1) {
                return null;
            }
            if (Character.isWhitespace(string.charAt(n3))) {
                return null;
            }
            String string3 = null;
            int n4 = StringUtil.findWordBoundary(string, n3, string2);
            if (n4 == 0) {
                string3 = string.substring(0, Math.min(n, n2));
            } else if (n4 > 0) {
                string3 = string.substring(n4 + 1, Math.min(n, n2));
            }
            return string3;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static int findPattern(String string, String string2, int n) {
        Pattern pattern = Pattern.compile(string, 2);
        return StringUtil.findPattern(pattern, string2, n);
    }

    public static int findPattern(Pattern pattern, String string, int n) {
        if (n < 0) {
            return -1;
        }
        Matcher matcher = pattern.matcher(string);
        int n2 = -1;
        if (matcher.find(n)) {
            n2 = matcher.start();
        }
        return n2;
    }

    public static String decodeUnicode(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        if (n == 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        int n2 = 0;
        while (n2 < n) {
            char c;
            if ((c = string.charAt(n2++)) == '\\' && n2 < n) {
                if ((c = string.charAt(n2++)) == 'u') {
                    int n3 = -1;
                    int n4 = 0;
                    for (n4 = 0; n4 < 4; ++n4) {
                        if (n2 + n4 >= n) {
                            n3 = -1;
                            break;
                        }
                        c = string.charAt(n2 + n4);
                        switch (c) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                n3 = (n3 << 4) + c - 48;
                                break;
                            }
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                n3 = (n3 << 4) + 10 + c - 97;
                                break;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': {
                                n3 = (n3 << 4) + 10 + c - 65;
                                break;
                            }
                            default: {
                                n3 = -1;
                            }
                        }
                        if (n3 == -1) break;
                    }
                    if (n3 != -1) {
                        stringBuilder.append((char)n3);
                    } else {
                        stringBuilder.append("\\u");
                        if (n4 == 0 && n2 < n) {
                            stringBuilder.append(c);
                        } else {
                            for (int i = 0; i < n4; ++i) {
                                stringBuilder.append(string.charAt(n2 + i));
                            }
                        }
                        ++n2;
                    }
                    n2 += n4;
                    continue;
                }
                switch (c) {
                    case '\\': {
                        c = '\\';
                        break;
                    }
                    case 't': {
                        c = '\t';
                        break;
                    }
                    case 'r': {
                        c = '\r';
                        break;
                    }
                    case 'n': {
                        c = '\n';
                        break;
                    }
                    case 'f': {
                        c = '\f';
                        break;
                    }
                    default: {
                        stringBuilder.append('\\');
                    }
                }
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String escapeText(String string, CharacterRange characterRange) {
        return StringUtil.escapeText(string, characterRange, EMPTY_STRING);
    }

    public static String escapeText(String string, CharacterRange characterRange, String string2) {
        return StringUtil.escapeText(string, characterRange, string2, CharacterEscapeType.unicode);
    }

    public static String escapeText(String string, CharacterRange characterRange, String string2, CharacterEscapeType characterEscapeType) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        if (n == 0) {
            return string;
        }
        if (string2 == null) {
            string2 = EMPTY_STRING;
        }
        StringBuilder stringBuilder = null;
        block11: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\\': {
                    if (stringBuilder == null) {
                        stringBuilder = StringUtil.createStringBuilder(string, i);
                    }
                    stringBuilder.append("\\\\");
                    continue block11;
                }
                case '\t': {
                    if (stringBuilder == null) {
                        stringBuilder = StringUtil.createStringBuilder(string, i);
                    }
                    stringBuilder.append("\\t");
                    continue block11;
                }
                case '\n': {
                    if (stringBuilder == null) {
                        stringBuilder = StringUtil.createStringBuilder(string, i);
                    }
                    stringBuilder.append("\\n");
                    continue block11;
                }
                case '\r': {
                    if (stringBuilder == null) {
                        stringBuilder = StringUtil.createStringBuilder(string, i);
                    }
                    stringBuilder.append("\\r");
                    continue block11;
                }
                case '\f': {
                    if (stringBuilder == null) {
                        stringBuilder = StringUtil.createStringBuilder(string, i);
                    }
                    stringBuilder.append("\\f");
                    continue block11;
                }
                default: {
                    if (characterRange.isOutsideRange(c) || string2.indexOf(c) > -1) {
                        if (stringBuilder == null) {
                            stringBuilder = StringUtil.createStringBuilder(string, i);
                        }
                        switch (characterEscapeType) {
                            case pgHex: {
                                if (c == '\u0000') break;
                                stringBuilder.append("\\x");
                                stringBuilder.append(NumberStringCache.getHexString(c));
                                break;
                            }
                            case hex: {
                                stringBuilder.append(StringUtil.hexString(c, 4));
                                break;
                            }
                            default: {
                                stringBuilder.append("\\u");
                                StringUtil.appendUnicode(stringBuilder, c);
                                break;
                            }
                        }
                        continue block11;
                    }
                    if (stringBuilder == null) continue block11;
                    stringBuilder.append(c);
                }
            }
        }
        if (stringBuilder == null) {
            return string;
        }
        return stringBuilder.toString();
    }

    private static StringBuilder createStringBuilder(String string, int n) {
        int n2 = string.length();
        StringBuilder stringBuilder = new StringBuilder((int)((double)n2 * 1.2));
        stringBuilder.append(string.substring(0, n));
        return stringBuilder;
    }

    public static CharSequence getOctalString(int n) {
        StringBuilder stringBuilder = new StringBuilder(3);
        String string = Integer.toOctalString(n);
        int n2 = string.length();
        if (n2 == 1) {
            stringBuilder.append("00");
        } else if (n2 == 2) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string);
        return stringBuilder;
    }

    public static String padRight(String string, int n) {
        return StringUtil.padRight(string, n, ' ');
    }

    public static String padRight(String string, int n, char c) {
        if (string == null) {
            return null;
        }
        if (string.length() >= n) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        stringBuilder.append(string);
        while (stringBuilder.length() < n) {
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static CharSequence formatInt(int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder(n2);
        if (n < 0) {
            stringBuilder.append('-');
        }
        String string = Integer.toString(Math.abs(n));
        for (int i = 0; i < n2 - string.length(); ++i) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string);
        return stringBuilder;
    }

    public static String formatNumber(int n, int n2, boolean bl) {
        String string = NumberStringCache.getNumberString(n);
        int n3 = string.length();
        if (n3 >= n2) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(n2);
        if (bl) {
            stringBuilder.append(string);
        }
        for (int i = n3; i < n2; ++i) {
            stringBuilder.append(' ');
        }
        if (!bl) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String replaceProperties(String string) {
        return StringUtil.replaceProperties(System.getProperties(), string);
    }

    public static String replaceProperties(Map<String, String> map, String string) {
        if (StringUtil.isEmptyString(string)) {
            return string;
        }
        Matcher matcher = VARIABLE_PATTERN.matcher(string);
        if (matcher == null) {
            return string;
        }
        while (matcher.find()) {
            int n = matcher.start();
            int n2 = matcher.end();
            String string2 = string.substring(n, n2);
            String string3 = string.substring(n + 2, n2 - 1);
            String string4 = map.get(string3);
            if (string4 == null || (matcher = VARIABLE_PATTERN.matcher(string = string.replace(string2, string4))) != null) continue;
            return string;
        }
        return string;
    }

    public static void appendUnicode(StringBuilder stringBuilder, char c) {
        stringBuilder.append(StringUtil.hexDigit(c >> 12));
        stringBuilder.append(StringUtil.hexDigit(c >> 8));
        stringBuilder.append(StringUtil.hexDigit(c >> 4));
        stringBuilder.append(StringUtil.hexDigit(c));
    }

    public static String hexString(int n, int n2) {
        String string = Integer.toHexString(n);
        StringBuilder stringBuilder = new StringBuilder(n2);
        for (int i = 0; i < n2 - string.length(); ++i) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    public static char hexDigit(int n) {
        return HEX_DIGIT[n & 0xF];
    }

    public static boolean containsWords(CharSequence charSequence, List<String> list, boolean bl, boolean bl2) {
        return StringUtil.containsWords(charSequence, list, bl, bl2, false);
    }

    public static boolean containsWords(CharSequence charSequence, List<String> list, boolean bl, boolean bl2, boolean bl3) {
        if (StringUtil.isBlank(charSequence)) {
            return false;
        }
        if (CollectionUtil.isEmpty(list)) {
            return false;
        }
        for (String string : list) {
            int n;
            String string2 = null;
            string2 = bl3 ? string : "(" + StringUtil.quoteRegexMeta(string) + ")";
            int n2 = n = bl2 ? 2 : 0;
            if (bl3) {
                n += 8;
            }
            Pattern pattern = Pattern.compile(string2, n);
            Matcher matcher = pattern.matcher(charSequence);
            boolean bl4 = matcher.find();
            if (!bl && bl4) {
                return true;
            }
            if (!bl || bl4) continue;
            return false;
        }
        return bl;
    }

    public static String quoteIfNeeded(String string) {
        if (StringUtil.isBlank(string)) {
            return string;
        }
        String string2 = "'";
        boolean bl = false;
        if (string.indexOf(39) > -1) {
            string2 = "\"";
            bl = true;
        }
        if (string.indexOf(32) > -1) {
            bl = true;
        }
        if (bl) {
            return string2 + string + string2;
        }
        return string;
    }

    public static List<String> getLines(String string) {
        if (string == null) {
            return Collections.emptyList();
        }
        return FileUtil.getLines(new BufferedReader(new StringReader(string)));
    }

    public static String wildcardToRegex(String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + 5);
        stringBuilder.append('^');
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '*' || c == '%' && bl) {
                stringBuilder.append(".*");
                continue;
            }
            if (c == '?') {
                stringBuilder.append(".");
                continue;
            }
            if (REGEX_SPECIAL_CHARS.indexOf(c) != -1) {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c);
        }
        stringBuilder.append('$');
        return stringBuilder.toString();
    }

    public static void removeFromEnd(StringBuilder stringBuilder, int n) {
        if (stringBuilder == null) {
            return;
        }
        if (n > stringBuilder.length()) {
            stringBuilder.setLength(0);
        } else {
            stringBuilder.delete(stringBuilder.length() - n, stringBuilder.length());
        }
    }

    public static int getLineStart(CharSequence charSequence, int n) {
        if (StringUtil.isEmptyString(charSequence)) {
            return 0;
        }
        if (n >= charSequence.length()) {
            return 0;
        }
        int n2 = 0;
        for (int i = n; i > 0; --i) {
            char c = charSequence.charAt(i);
            if (c != '\r' && c != '\n') continue;
            n2 = i + 1;
            break;
        }
        return n2;
    }

    public static int getLineEnd(String string, int n) {
        int n2;
        if (StringUtil.isEmptyString(string)) {
            return 0;
        }
        int n3 = n2 = string.length();
        for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            if (c != '\r' && c != '\n') continue;
            n3 = i;
            break;
        }
        return n3;
    }

    public static int findNextLineStart(String string, int n) {
        int n2 = StringUtil.getLineEnd(string, n);
        if (n2 <= 0) {
            return 0;
        }
        char c = string.charAt(n2);
        int n3 = string.length();
        while (n2 < n3 - 1 && (c == '\r' || c == '\n')) {
            c = string.charAt(++n2);
        }
        return n2;
    }

    public static String arrayToString(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return EMPTY_STRING;
        }
        StringBuilder stringBuilder = new StringBuilder(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(stringArray[i]);
        }
        return stringBuilder.toString();
    }

    public static int[] stringToArray(String string) {
        if (StringUtil.isBlank(string)) {
            return null;
        }
        String[] stringArray = string.split(",");
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = StringUtil.getIntValue(stringArray[i], 0);
        }
        return nArray;
    }

    public static String arrayToString(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(Integer.toString(nArray[i]));
        }
        return stringBuilder.toString();
    }

    public static int findOccurance(String string, char c, int n) {
        int n2 = 0;
        int n3 = -1;
        while ((n3 = string.indexOf(c, n3 + 1)) != -1 && ++n2 < n) {
        }
        return n3;
    }

    public static String coalesce(String ... stringArray) {
        if (stringArray == null) {
            return null;
        }
        for (String string : stringArray) {
            if (string == null) continue;
            return string;
        }
        return null;
    }

    public static String firstNonBlank(String ... stringArray) {
        if (stringArray == null) {
            return null;
        }
        for (String string : stringArray) {
            if (!StringUtil.isNonBlank(string)) continue;
            return string;
        }
        return null;
    }

    public static String unescape(String string) {
        if (StringUtil.isBlank(string)) {
            return string;
        }
        if (string.startsWith("&") && string.endsWith(";")) {
            return HtmlUtil.unescapeHTML(string);
        }
        if (!string.startsWith("\\")) {
            return string;
        }
        return StringUtil.decodeUnicode(string);
    }

    public static int naturalCompare(String string, String string2, boolean bl) {
        if (bl) {
            string = string.toLowerCase();
            string2 = string2.toLowerCase();
        }
        int n = string.length();
        int n2 = string2.length();
        int n3 = Math.min(n, n2);
        boolean bl2 = false;
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            boolean bl3;
            char c = string.charAt(i);
            char c2 = string2.charAt(i);
            boolean bl4 = c >= '0' && c <= '9';
            boolean bl5 = bl3 = c2 >= '0' && c2 <= '9';
            if (bl2) {
                if (bl4 && bl3) {
                    if (n4 != 0) continue;
                    n4 = c - c2;
                    continue;
                }
                if (bl4) {
                    return 1;
                }
                if (bl3) {
                    return -1;
                }
                if (n4 == 0) {
                    if (c != c2) {
                        return c - c2;
                    }
                    bl2 = false;
                    continue;
                }
                return n4;
            }
            if (bl4 && bl3) {
                bl2 = true;
                if (n4 != 0) continue;
                n4 = c - c2;
                continue;
            }
            if (c == c2) continue;
            return c - c2;
        }
        if (bl2) {
            if (n > n2 && string.charAt(n2) >= '0' && string.charAt(n2) <= '9') {
                return 1;
            }
            if (n2 > n && string2.charAt(n) >= '0' && string2.charAt(n) <= '9') {
                return -1;
            }
            return n4;
        }
        return n - n2;
    }
}

