/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.sql.formatter.WbSqlFormatter;
import workbench.sql.lexer.SQLLexer;
import workbench.sql.lexer.SQLLexerFactory;
import workbench.sql.lexer.SQLToken;
import workbench.sql.parser.ParserType;
import workbench.util.Alias;
import workbench.util.SqlParsingUtil;
import workbench.util.SqlUtil;

public class TableListParser {
    private char catalogSeparator = (char)46;
    private char schemaSeparator = (char)46;
    private ParserType parserType = ParserType.Standard;

    public TableListParser() {
    }

    public TableListParser(ParserType parserType) {
        this('.', '.', parserType);
    }

    public TableListParser(char c, char c2, ParserType parserType) {
        this.parserType = parserType;
        this.catalogSeparator = c;
        this.schemaSeparator = c2;
    }

    public List<Alias> getTables(String string, boolean bl) {
        SQLLexer sQLLexer = SQLLexerFactory.createLexer(this.parserType, (CharSequence)"");
        string = SqlUtil.trimSemicolon(string);
        int n = SqlParsingUtil.getKeywordPosition(Collections.singleton("FROM"), string, 0, sQLLexer);
        if (n < 0) {
            return Collections.emptyList();
        }
        ArrayList<Alias> arrayList = new ArrayList<Alias>();
        try {
            Object object;
            boolean bl2 = false;
            SQLToken sQLToken = sQLLexer.getNextToken(false, false);
            boolean bl3 = true;
            int n2 = 0;
            boolean bl4 = false;
            int n3 = -1;
            while (!(sQLToken == null || WbSqlFormatter.FROM_TERMINAL.contains(object = sQLToken.getContents()) && n2 == 0)) {
                if (((String)object).equals("SELECT") && n2 > 0) {
                    bl4 = true;
                    n3 = n2;
                }
                if ("(".equals(object)) {
                    if (bl2) {
                        sQLToken = this.skipAliasColumns(sQLLexer, sQLToken);
                        bl2 = false;
                        continue;
                    }
                    ++n2;
                } else if (")".equals(object)) {
                    if (bl4 && n2 == n3) {
                        bl4 = false;
                    }
                    --n2;
                    sQLToken = sQLLexer.getNextToken(false, false);
                    if (sQLToken != null && sQLToken.getContents().equals("AS")) {
                        bl3 = true;
                        continue;
                    }
                    bl3 = n2 == 0;
                    continue;
                }
                if (!bl4) {
                    if (SqlUtil.getJoinKeyWords().contains(object)) {
                        bl3 = true;
                    } else if (",".equals(object)) {
                        bl3 = true;
                    } else if ("ON".equals(object) || "USING".equals(object)) {
                        bl3 = false;
                    } else if (bl3 && !((String)object).equals("(") && !((String)object).equalsIgnoreCase("LATERAL")) {
                        bl3 = false;
                        bl2 = true;
                        Alias alias = new Alias();
                        alias.setStartPositionInQuery(sQLToken.getCharBegin());
                        if (!sQLToken.getContents().equals("AS")) {
                            sQLToken = this.collectToWhiteSpace(sQLLexer, sQLToken, alias);
                        }
                        if (sQLToken != null && sQLToken.isWhiteSpace()) {
                            sQLToken = sQLLexer.getNextToken(false, false);
                        }
                        if (sQLToken != null && sQLToken.getContents().equals("AS")) {
                            alias.setAsKeyword(sQLToken.getText());
                            sQLToken = sQLLexer.getNextToken(false, false);
                            alias.setAlias(sQLToken != null ? sQLToken.getText() : null);
                            if (sQLToken != null) {
                                alias.setEndPositionInQuery(sQLToken.getCharEnd());
                            }
                            arrayList.add(alias);
                        } else if (sQLToken != null && sQLToken.isIdentifier()) {
                            alias.setAlias(sQLToken.getText());
                            alias.setEndPositionInQuery(sQLToken.getCharEnd());
                            arrayList.add(alias);
                        } else {
                            if (sQLToken != null) {
                                alias.setEndPositionInQuery(sQLToken.getCharEnd());
                            }
                            arrayList.add(alias);
                            continue;
                        }
                    }
                }
                sQLToken = sQLLexer.getNextToken(false, false);
            }
            if (!bl) {
                for (Alias alias : arrayList) {
                    alias.setAlias(null);
                }
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error parsing sql", exception);
        }
        return arrayList;
    }

    private SQLToken skipAliasColumns(SQLLexer sQLLexer, SQLToken sQLToken) {
        if (sQLToken == null) {
            return sQLToken;
        }
        if (!sQLToken.getText().equals("(")) {
            return sQLToken;
        }
        SQLToken sQLToken2 = sQLLexer.getNextToken(false, false);
        while (sQLToken2 != null) {
            if (sQLToken2.getText().equals(")")) {
                return sQLLexer.getNextToken(false, false);
            }
            sQLToken2 = sQLLexer.getNextToken(false, false);
        }
        return null;
    }

    private SQLToken collectToWhiteSpace(SQLLexer sQLLexer, SQLToken sQLToken, Alias alias) {
        String string;
        if (!sQLToken.isWhiteSpace()) {
            alias.appendObjectName(sQLToken.getText());
        }
        SQLToken sQLToken2 = sQLLexer.getNextToken(false, true);
        while (!(sQLToken2 == null || !this.isSeparator(string = sQLToken2.getContents()) && (sQLToken2.isWhiteSpace() || sQLToken2.isOperator() || sQLToken2.isReservedWord() || string.equals(",")))) {
            alias.appendObjectName(sQLToken2.getText());
            alias.setEndPositionInQuery(sQLToken2.getCharEnd());
            sQLToken2 = sQLLexer.getNextToken(false, true);
        }
        return sQLToken2;
    }

    private boolean isSeparator(String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        return string.charAt(0) == this.schemaSeparator || string.charAt(0) == this.catalogSeparator;
    }
}

