/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.io.File;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.time.temporal.Temporal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.storage.reader.TimestampTZHandler;
import workbench.util.CollectionUtil;
import workbench.util.ConverterException;
import workbench.util.LobFileParameter;
import workbench.util.LobFileParameterParser;
import workbench.util.StringUtil;
import workbench.util.WbDateFormatter;

public class ValueConverter {
    public static final String DETECT_FIRST = "detect_once";
    public static final String ALWAYS_CHECK_INTERNAL = "detect";
    private final List<String> timestampFormats = CollectionUtil.arrayList("yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "dd.MM.yyyy HH:mm:ss.SSS", "dd.MM.yyyy HH:mm:ss", "dd.MM.yy HH:mm:ss.SSS", "dd.MM.yy HH:mm:ss", "dd.MM.yy HH:mm", "MM/dd/yyyy HH:mm:ss.SSS", "MM/dd/yyyy HH:mm:ss", "MM/dd/yy HH:mm:ss.SSS", "MM/dd/yy HH:mm:ss", "MM/dd/yy HH:mm", "yyyy-MM-dd", "dd.MM.yyyy", "dd.MM.yy", "MM/dd/yy", "MM/dd/yyyy");
    private final List<String> dateFormats = CollectionUtil.arrayList("yyyy-MM-dd", "dd.MM.yyyy", "dd.MM.yy", "MM/dd/yy", "MM/dd/yyyy", "dd-MMM-yyyy", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ss", "dd.MM.yyyy HH:mm:ss", "MM/dd/yy HH:mm:ss", "MM/dd/yyyy HH:mm:ss");
    private final String[] timeFormats = new String[]{"HH:mm:ss.SS", "HH:mm:ss", "HH:mm", "HHmm", "HH"};
    private String defaultDateFormat;
    private String defaultTimestampFormat;
    private char decimalCharacter = (char)46;
    private final WbDateFormatter dateFormatter = new WbDateFormatter();
    private final WbDateFormatter timestampFormatter = new WbDateFormatter();
    private final WbDateFormatter formatter = new WbDateFormatter();
    private boolean autoConvertBooleanNumbers = true;
    private final Map<String, Boolean> booleanValues = new HashMap<String, Boolean>();
    private boolean booleanUserMap;
    private Integer integerTrue = 1;
    private Integer integerFalse = 0;
    private Long longTrue = 1L;
    private Long longFalse = 0L;
    private BigDecimal bigDecimalTrue = BigDecimal.valueOf(1L);
    private BigDecimal bigDecimalFalse = BigDecimal.valueOf(0L);
    private static final String FORMAT_MILLIS = "millis";
    private boolean checkBuiltInFormats = true;
    private boolean useFirstMatching = true;
    private boolean illegalDateIsNull;
    private boolean cleanupNumbers = false;
    private boolean logWarnings = true;
    private TimestampTZHandler tzType = TimestampTZHandler.DUMMY_HANDLER;

    public ValueConverter() {
        this(null);
    }

    public ValueConverter(WbConnection wbConnection) {
        Settings settings = Settings.getInstance();
        this.setDefaultDateFormat(settings.getDefaultDateFormat());
        this.setDefaultTimestampFormat(settings.getDefaultTimestampFormat());
        this.cleanupNumbers = Settings.getInstance().getBoolProperty("workbench.converter.cleanupdecimals", false);
        this.readConfiguredBooleanValues();
        this.tzType = TimestampTZHandler.Factory.getHandler(wbConnection);
    }

    public void setLogWarnings(boolean bl) {
        this.logWarnings = bl;
    }

    private void readConfiguredBooleanValues() {
        List<String> list = Settings.getInstance().getListProperty("workbench.converter.boolean.true", true, "1,t,true");
        List<String> list2 = Settings.getInstance().getListProperty("workbench.converter.boolean.false", true, "0,f,false");
        this.fillBooleanMap(list, list2);
        this.booleanUserMap = false;
    }

    private void fillBooleanMap(Collection<String> collection, Collection<String> collection2) {
        this.booleanValues.clear();
        for (String string : collection) {
            this.booleanValues.put(string, Boolean.TRUE);
        }
        for (String string : collection2) {
            this.booleanValues.put(string, Boolean.FALSE);
        }
    }

    public ValueConverter(String string, String string2) {
        if (StringUtil.isEmptyString(string)) {
            this.setDefaultDateFormat(Settings.getInstance().getDefaultDateFormat());
        } else {
            this.setDefaultDateFormat(string);
        }
        if (StringUtil.isEmptyString(string2)) {
            this.setDefaultTimestampFormat(Settings.getInstance().getDefaultTimestampFormat());
        } else {
            this.setDefaultTimestampFormat(string2);
        }
    }

    public void setLocale(Locale locale) {
        this.dateFormatter.setLocale(locale);
        this.timestampFormatter.setLocale(locale);
        this.formatter.setLocale(locale);
    }

    public void setIllegalDateIsNull(boolean bl) {
        this.illegalDateIsNull = bl;
    }

    public void setCheckBuiltInFormats(boolean bl) {
        this.checkBuiltInFormats = bl;
    }

    public final void setDefaultDateFormat(String string) throws IllegalArgumentException {
        if (DETECT_FIRST.equalsIgnoreCase(string)) {
            this.defaultDateFormat = null;
            this.checkBuiltInFormats = true;
            this.useFirstMatching = true;
        } else if (ALWAYS_CHECK_INTERNAL.equalsIgnoreCase(string)) {
            this.defaultDateFormat = null;
            this.checkBuiltInFormats = true;
            this.useFirstMatching = false;
        } else if (string.equalsIgnoreCase(FORMAT_MILLIS)) {
            this.defaultDateFormat = FORMAT_MILLIS;
            this.checkBuiltInFormats = false;
        } else if (StringUtil.isNonEmpty(string)) {
            this.checkBuiltInFormats = false;
            this.defaultDateFormat = string;
            this.dateFormatter.applyPattern(string);
        }
    }

    public final void setDefaultTimestampFormat(String string) throws IllegalArgumentException {
        if (DETECT_FIRST.equalsIgnoreCase(string)) {
            this.defaultTimestampFormat = null;
            this.checkBuiltInFormats = true;
            this.useFirstMatching = true;
        } else if (ALWAYS_CHECK_INTERNAL.equalsIgnoreCase(string)) {
            this.defaultTimestampFormat = null;
            this.checkBuiltInFormats = true;
            this.useFirstMatching = false;
        } else if (string.equalsIgnoreCase(FORMAT_MILLIS)) {
            this.defaultTimestampFormat = FORMAT_MILLIS;
            this.checkBuiltInFormats = false;
        } else if (StringUtil.isNonEmpty(string)) {
            this.checkBuiltInFormats = false;
            this.defaultTimestampFormat = string;
            this.timestampFormatter.applyPattern(string, true);
        }
    }

    public void setNumericBooleanValues(int n, int n2) {
        this.integerFalse = n;
        this.integerTrue = n2;
        this.longFalse = n;
        this.longTrue = n2;
        this.bigDecimalFalse = BigDecimal.valueOf(n);
        this.bigDecimalTrue = BigDecimal.valueOf(n2);
    }

    public char getDecimalCharacter() {
        return this.decimalCharacter;
    }

    public void setDecimalCharacter(char c) {
        this.decimalCharacter = c;
    }

    public void setAutoConvertBooleanNumbers(boolean bl) {
        this.autoConvertBooleanNumbers = bl;
    }

    public void setBooleanLiterals(Collection<String> collection, Collection<String> collection2) {
        if (CollectionUtil.isEmpty(collection) || CollectionUtil.isEmpty(collection2)) {
            LogMgr.logWarning(new CallerInfo(){}, "Ignoring attempt to set boolean literals because at least one collection is empty or null");
            this.readConfiguredBooleanValues();
        } else {
            this.fillBooleanMap(collection, collection2);
            this.booleanUserMap = true;
        }
    }

    private Number getNumberFromString(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        try {
            BigDecimal bigDecimal = new BigDecimal(this.adjustDecimalString(string));
            if (bl) {
                return bigDecimal.intValueExact();
            }
            return bigDecimal.longValueExact();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Number getLong(String string) throws ConverterException {
        if (StringUtil.isBlank(string)) {
            return null;
        }
        try {
            return new Long(string);
        }
        catch (NumberFormatException numberFormatException) {
            Boolean bl;
            Number number = this.getNumberFromString(string, false);
            if (number != null) {
                return number;
            }
            if (this.autoConvertBooleanNumbers && (bl = this.getBoolean(string, 16)) != null) {
                if (bl.booleanValue()) {
                    return this.longTrue;
                }
                return this.longFalse;
            }
            throw new ConverterException(string, -5, numberFormatException);
        }
    }

    public Number getInt(String string, int n) throws ConverterException {
        if (StringUtil.isBlank(string)) {
            return null;
        }
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            Boolean bl;
            Number number = this.getNumberFromString(string, true);
            if (number != null) {
                return number;
            }
            if (this.autoConvertBooleanNumbers && (bl = this.getBoolean(string, 16)) != null) {
                if (bl.booleanValue()) {
                    return this.integerTrue;
                }
                return this.integerFalse;
            }
            throw new ConverterException(string, n, numberFormatException);
        }
    }

    public BigDecimal getBigDecimal(String string, int n) throws ConverterException {
        if (StringUtil.isBlank(string)) {
            return null;
        }
        try {
            return new BigDecimal(this.adjustDecimalString(string));
        }
        catch (NumberFormatException numberFormatException) {
            Boolean bl;
            if (this.autoConvertBooleanNumbers && (bl = this.getBoolean(string, 16)) != null) {
                if (bl.booleanValue()) {
                    return this.bigDecimalTrue;
                }
                return this.bigDecimalFalse;
            }
            throw new ConverterException(string, n, numberFormatException);
        }
    }

    private String makeString(Object object) {
        return object.toString().trim();
    }

    public Object convertValue(Object object, int n) throws ConverterException {
        if (object == null) {
            return null;
        }
        switch (n) {
            case -5: {
                return this.getLong(this.makeString(object));
            }
            case -6: 
            case 4: 
            case 5: {
                return this.getInt(this.makeString(object), n);
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return this.getBigDecimal(this.makeString(object), n);
            }
            case -1: 
            case 1: 
            case 12: {
                return object.toString();
            }
            case 91: {
                if (object instanceof java.util.Date) {
                    return object;
                }
                if (StringUtil.isBlank(this.makeString(object))) {
                    return null;
                }
                try {
                    return this.parseDate(this.makeString(object));
                }
                catch (Exception exception) {
                    throw new ConverterException(object, n, exception);
                }
            }
            case 2014: {
                if (object instanceof ZonedDateTime || object instanceof OffsetDateTime) {
                    return object;
                }
                String string = this.makeString(object);
                if (StringUtil.isBlank(string)) {
                    return null;
                }
                try {
                    Object object2 = null;
                    object2 = this.timestampFormatter.patternContainesTimeZoneInformation() ? this.parseTimestampTZ(string) : this.parseTimestamp(string);
                    return this.tzType.convertTimestampTZ(object2);
                }
                catch (Exception exception) {
                    throw new ConverterException(object, n, exception);
                }
            }
            case 93: {
                if (object instanceof java.util.Date) {
                    return object;
                }
                String string = this.makeString(object);
                if (StringUtil.isBlank(string)) {
                    return null;
                }
                try {
                    return this.parseTimestamp(string);
                }
                catch (Exception exception) {
                    throw new ConverterException(object, n, exception);
                }
            }
            case 92: {
                if (object instanceof java.util.Date) {
                    return object;
                }
                String string = this.makeString(object);
                if (StringUtil.isBlank(string)) {
                    return null;
                }
                try {
                    return this.parseTime(string);
                }
                catch (Exception exception) {
                    throw new ConverterException(object, n, exception);
                }
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                if (object instanceof String) {
                    LobFileParameterParser lobFileParameterParser = null;
                    try {
                        lobFileParameterParser = new LobFileParameterParser(object.toString());
                    }
                    catch (Exception exception) {
                        throw new ConverterException(object, n, exception);
                    }
                    LobFileParameter[] lobFileParameterArray = lobFileParameterParser.getParameters();
                    if (lobFileParameterArray == null) {
                        return null;
                    }
                    String string = lobFileParameterArray[0].getFilename();
                    if (string == null) {
                        return null;
                    }
                    return new File(string);
                }
                if (object instanceof File) {
                    return object;
                }
                if (object instanceof byte[]) {
                    return object;
                }
                return null;
            }
            case -7: 
            case 16: {
                String string = this.makeString(object);
                return this.getBoolean(string, n);
            }
        }
        return object;
    }

    public String getDatePattern() {
        return this.defaultDateFormat;
    }

    public String getTimestampPattern() {
        return this.defaultTimestampFormat;
    }

    public Time parseTime(String string) throws ParseException {
        if (this.isCurrentTime(string)) {
            return Time.valueOf(LocalTime.now());
        }
        Time time = null;
        for (String string2 : this.timeFormats) {
            try {
                this.formatter.applyPattern(string2);
                time = this.formatter.parseTime(string);
                LogMgr.logDebug(new CallerInfo(){}, "Succeeded parsing the time string [" + string + "] using the format: " + this.formatter.toPattern());
                break;
            }
            catch (Exception exception) {
                time = null;
            }
        }
        if (time != null) {
            return time;
        }
        throw new ParseException("Could not parse [" + string + "] as a time value!", 0);
    }

    public Temporal parseTimestampTZ(String string) throws ParseException, NumberFormatException {
        if (this.isCurrentTimestamp(string)) {
            return ZonedDateTime.now();
        }
        if (this.isCurrentDate(string)) {
            return ZonedDateTime.of(LocalDate.now(), LocalTime.MIDNIGHT, ZoneId.systemDefault());
        }
        this.timestampFormatter.setIllegalDateIsNull(this.illegalDateIsNull);
        Temporal temporal = null;
        if (this.defaultTimestampFormat != null) {
            try {
                if (FORMAT_MILLIS.equalsIgnoreCase(this.defaultTimestampFormat)) {
                    long l = Long.parseLong(string);
                    temporal = ZonedDateTime.ofInstant(Instant.ofEpochMilli(l), ZoneId.systemDefault());
                } else {
                    temporal = this.timestampFormatter.parseTimestampTZ(string);
                }
            }
            catch (Exception exception) {
                if (this.logWarnings) {
                    LogMgr.logWarning(new CallerInfo(){}, "Could not parse '" + string + "' as a timestamp with time zone using the format: " + this.timestampFormatter.toPattern(), null);
                }
                throw new ParseException("Could not convert [" + string + "] to a timestamp with timezone value!", 0);
            }
        }
        return temporal;
    }

    public Timestamp parseTimestamp(String string) throws ParseException, NumberFormatException {
        if (this.isCurrentTimestamp(string)) {
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            return timestamp;
        }
        if (this.isCurrentDate(string)) {
            return Timestamp.valueOf(LocalDateTime.now());
        }
        Timestamp timestamp = null;
        this.timestampFormatter.setIllegalDateIsNull(this.illegalDateIsNull);
        if (this.defaultTimestampFormat != null) {
            try {
                if (FORMAT_MILLIS.equalsIgnoreCase(this.defaultTimestampFormat)) {
                    long l = Long.parseLong(string);
                    timestamp = new Timestamp(l);
                } else {
                    timestamp = this.timestampFormatter.parseTimestamp(string);
                }
            }
            catch (Exception exception) {
                if (this.logWarnings) {
                    LogMgr.logWarning(new CallerInfo(){}, "Could not parse '" + string + "' using default format " + this.timestampFormatter.toPattern() + ". Trying to recognize the format...", null);
                }
                timestamp = null;
            }
        }
        if (timestamp == null && this.illegalDateIsNull) {
            LogMgr.logInfo(new CallerInfo(){}, "Illegal timestamp value '" + string + "' set to null");
            return null;
        }
        if (timestamp == null && this.checkBuiltInFormats) {
            for (String string2 : this.timestampFormats) {
                try {
                    this.formatter.applyPattern(string2, true);
                    timestamp = this.formatter.parseTimestamp(string);
                    LogMgr.logDebug(new CallerInfo(){}, "Succeeded parsing '" + string + "' using the format: " + string2);
                    if (!this.useFirstMatching) break;
                    this.defaultTimestampFormat = string2;
                    break;
                }
                catch (DateTimeParseException dateTimeParseException) {
                    timestamp = null;
                }
            }
        }
        if (timestamp != null) {
            return timestamp;
        }
        throw new ParseException("Could not convert [" + string + "] to a timestamp value!", 0);
    }

    public Date parseDate(String string) throws ParseException {
        CallerInfo callerInfo;
        Date date;
        block19: {
            if (this.isCurrentDate(string)) {
                return Date.valueOf(LocalDate.now());
            }
            if (this.isCurrentTimestamp(string)) {
                return new Date(System.currentTimeMillis());
            }
            date = null;
            callerInfo = new CallerInfo(){};
            this.dateFormatter.setIllegalDateIsNull(this.illegalDateIsNull);
            if (this.defaultDateFormat != null) {
                try {
                    if (FORMAT_MILLIS.equalsIgnoreCase(this.defaultTimestampFormat)) {
                        long l = Long.parseLong(string);
                        date = new Date(l);
                    } else {
                        date = this.dateFormatter.parseDate(string);
                    }
                }
                catch (Exception exception) {
                    if (this.logWarnings) {
                        LogMgr.logWarning(callerInfo, "Could not parse [" + string + "] using: " + this.dateFormatter.toPattern(), null);
                    }
                    date = null;
                }
            }
            if (date == null && this.illegalDateIsNull) {
                LogMgr.logInfo(callerInfo, "Illegal date value '" + string + "' set to null");
                return null;
            }
            if (date == null && this.defaultTimestampFormat != null) {
                try {
                    date = this.timestampFormatter.parseDate(string);
                }
                catch (DateTimeParseException dateTimeParseException) {
                    if (!this.logWarnings) break block19;
                    LogMgr.logWarning(callerInfo, "Could not parse [" + string + "] using: " + this.timestampFormatter.toPattern() + ". Trying to recognize the format...", null);
                }
            }
        }
        if (date == null && this.checkBuiltInFormats) {
            for (String string2 : this.dateFormats) {
                this.formatter.applyPattern(string2);
                date = this.formatter.parseDateQuietely(string);
                if (date == null) continue;
                if (this.useFirstMatching) {
                    this.defaultDateFormat = string2;
                }
                if (!this.logWarnings) break;
                LogMgr.logDebug(callerInfo, "Succeeded parsing [" + string + "] using the format: " + string2);
                break;
            }
            if (date == null) {
                for (String string2 : this.timestampFormats) {
                    this.formatter.applyPattern(string2, false);
                    Timestamp timestamp = this.formatter.parseTimestampQuietly(string);
                    if (timestamp == null) continue;
                    date = new Date(timestamp.getTime());
                    if (this.useFirstMatching) {
                        this.defaultDateFormat = string2;
                    }
                    if (!this.logWarnings) break;
                    LogMgr.logDebug(callerInfo, "Succeeded parsing [" + string + "] using the format: " + string2);
                    break;
                }
            }
        }
        if (date != null) {
            return date;
        }
        throw new ParseException("Could not convert [" + string + "] to a date", 0);
    }

    private boolean isCurrentTime(String string) {
        return this.isKeyword("current_time", string);
    }

    private boolean isCurrentDate(String string) {
        return this.isKeyword("current_date", string);
    }

    private boolean isCurrentTimestamp(String string) {
        return this.isKeyword("current_timestamp", string);
    }

    private boolean isKeyword(String string, String string2) {
        if (StringUtil.isEmptyString(string2)) {
            return false;
        }
        List<String> list = Settings.getInstance().getListProperty("workbench.db.keyword." + string, true);
        return list.contains(string2.toLowerCase());
    }

    private String adjustDecimalString(String string) {
        if (string == null) {
            return string;
        }
        int n = string.length();
        if (n == 0) {
            return string;
        }
        if (this.cleanupNumbers) {
            return this.cleanupNumberString(string);
        }
        if (this.decimalCharacter == '.') {
            return string;
        }
        int n2 = string.lastIndexOf(this.decimalCharacter);
        if (n2 < 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.setCharAt(n2, '.');
        return stringBuilder.toString();
    }

    private String cleanupNumberString(String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        int n2 = string.lastIndexOf(this.decimalCharacter);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (i == n2) {
                stringBuilder.append('.');
                continue;
            }
            if ("+-0123456789eE".indexOf(c) <= -1) continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private Boolean getBoolean(String string, int n) throws ConverterException {
        if (!this.booleanUserMap) {
            string = string.toLowerCase().trim();
        }
        Boolean bl = this.booleanValues.get(string);
        if (this.booleanUserMap && bl == null) {
            throw new ConverterException("Input value [" + string + "] not in the list of defined true or false literals", n, null);
        }
        return bl;
    }
}

