/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.security.Key;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.WbCipher;

public class WbAESCipher
implements WbCipher {
    private static final byte[] SALT = new byte[]{42, 10, 33, 17, 8, 52, -17, 19, 26, 65, -42, 17, -88};
    private static final byte[] IV = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private Cipher cipher;
    private IvParameterSpec ivspec;
    private SecretKeySpec secretKey;

    public WbAESCipher(String string) {
        try {
            this.cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            this.ivspec = new IvParameterSpec(IV);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
            PBEKeySpec pBEKeySpec = new PBEKeySpec(string.toCharArray(), SALT, 65536, 256);
            SecretKey secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
            this.secretKey = new SecretKeySpec(secretKey.getEncoded(), "AES");
        }
        catch (Exception exception) {
            LogMgr.logWarning(new CallerInfo(){}, "No encryption available!", exception);
        }
    }

    @Override
    public String decryptString(String string) {
        if (string == null) {
            return string;
        }
        try {
            this.cipher.init(2, (Key)this.secretKey, this.ivspec);
            byte[] byArray = Base64.getDecoder().decode(string);
            byte[] byArray2 = this.cipher.doFinal(byArray);
            return new String(byArray2, "UTF-8");
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not decrypt", exception);
            return string;
        }
    }

    @Override
    public String encryptString(String string) {
        if (string == null) {
            return null;
        }
        if (this.cipher == null) {
            return string;
        }
        try {
            this.cipher.init(1, (Key)this.secretKey, this.ivspec);
            byte[] byArray = this.cipher.doFinal(string.getBytes("UTF-8"));
            return Base64.getEncoder().encodeToString(byArray);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not encrypt", exception);
            return string;
        }
    }
}

