/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import workbench.log.CallerInfo;
import workbench.log.LogMgr;

public class WbThread
extends Thread
implements Thread.UncaughtExceptionHandler {
    public WbThread(String string) {
        super(string);
        this.setDaemon(true);
        this.setUncaughtExceptionHandler(this);
    }

    public WbThread(Runnable runnable, String string) {
        super(runnable, string);
        this.setDaemon(true);
        this.setUncaughtExceptionHandler(this);
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        LogMgr.logError(new CallerInfo(){}, "Thread + " + thread.getName() + " caused an exception", throwable);
    }

    public static void sleepSilently(long l) {
        try {
            Thread.sleep(l);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void runWithTimeout(Thread thread, long l) {
        thread.start();
        try {
            thread.join(l);
            thread.interrupt();
        }
        catch (InterruptedException interruptedException) {
            LogMgr.logWarning(new CallerInfo(){}, "Waiting was interrupted", interruptedException);
        }
    }
}

