/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib;

import java.sql.Timestamp;
import javax.json.JsonObject;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.tools.dataTypes.DataTypeUtils;
import org.gvsig.vcsgis.lib.VCSGisRepositoryDataImpl;
import org.gvsig.vcsgis.lib.repository.VCSGisRepositoryLogData;

public class VCSGisRepositoryLogDataImpl
extends VCSGisRepositoryDataImpl
implements VCSGisRepositoryLogData {
    private String tags;
    private int topologyPlan;
    private String comment;
    private Timestamp revisionDate;
    private String userCode;

    public VCSGisRepositoryLogDataImpl(JsonObject jsonData) {
        super(jsonData);
    }

    public VCSGisRepositoryLogDataImpl(Feature f) {
        super(f);
        this.userCode = f.getString("COD_USER");
        this.comment = f.getString("REV_COMMENT");
        this.topologyPlan = f.getInt("REV_TOPPLAN");
        this.tags = f.getString("REV_TAGS");
        this.revisionDate = f.getTimestamp("REV_OPERATIONDATE");
    }

    @Override
    public JsonObject toJson() {
        return this.toJsonBuilder().build();
    }

    @Override
    public JsonObjectBuilder toJsonBuilder() {
        JsonObjectBuilder builder = super.toJsonBuilder();
        builder.add("UserCode", this.getUserCode());
        builder.add("RevisionDate", (Object)this.getRevisionDate());
        builder.add("Comment", this.getComment());
        builder.add("TopologyPlan", this.getTopologyPlan());
        builder.add("Tags", this.getTags());
        return builder;
    }

    @Override
    public String toString() {
        return this.toJson().toString().replace("\n", "");
    }

    public String getUserCode() {
        return this.userCode;
    }

    public Timestamp getRevisionDate() {
        return this.revisionDate;
    }

    public String getComment() {
        return this.comment;
    }

    public int getTopologyPlan() {
        return this.topologyPlan;
    }

    public String getTags() {
        return this.tags;
    }

    @Override
    public void fromJson(JsonObject jsonData) {
        super.fromJson(jsonData);
        this.userCode = jsonData.getString("UserCode", null);
        this.comment = jsonData.getString("Comment", null);
        this.topologyPlan = jsonData.getInt("TopologyPlan", 0);
        this.tags = jsonData.getString("Tags", null);
        this.revisionDate = (Timestamp)DataTypeUtils.toTimestamp((Object)jsonData.getString("RevisionDate", null), null);
    }
}

