/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.repository.localdb;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.gvsig.vcsgis.lib.SupportError;
import org.gvsig.vcsgis.lib.VCSGisUser;
import org.gvsig.vcsgis.lib.repository.VCSGisIdentityController;
import org.gvsig.vcsgis.lib.repository.VCSGisRepositoryLocaldb;
import org.gvsig.vcsgis.lib.repository.localdb.identityControllerLocaldb.IdentityControllerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIdentityController
implements VCSGisIdentityController {
    protected static final Logger LOGGER = LoggerFactory.getLogger(IdentityControllerImpl.class);
    protected final VCSGisRepositoryLocaldb repository;

    public AbstractIdentityController(VCSGisRepositoryLocaldb repo) {
        this.repository = repo;
    }

    public int isAuthenticated(String userCode, String authenticationToken, String operation, SupportError error) {
        if (!this.repository.isAuthenticationRequired()) {
            LOGGER.debug("Authentication not required for this repository.");
            return 0;
        }
        if (StringUtils.isBlank((CharSequence)userCode)) {
            error.error(23, "User is not authenticated (invalid user code).");
            return 23;
        }
        return this.checkToken(authenticationToken, userCode, error);
    }

    public int isAuthorized(String userCode, String authenticationToken, String operation, SupportError error) {
        int n = this.isAuthenticated(userCode, authenticationToken, operation, error);
        if (n != 0) {
            return n;
        }
        if (!this.repository.isAuthorizationRequired()) {
            LOGGER.debug("Repository authorization not required.");
            return 0;
        }
        VCSGisUser user = this.getUser(authenticationToken, userCode);
        if (user == null) {
            error.error(21, "User '" + userCode + "' is not authorized (invalid user).");
            return 21;
        }
        List operations = user.getAllowedOperationsAsList();
        if (operations == null) {
            LOGGER.debug("All repository operations are allowed for user '" + user.getIdentifier() + "' (" + user.getUserCode() + ").");
            return 0;
        }
        if (!operations.contains(operation)) {
            error.error(21, "User '" + userCode + "' is not authorized to '" + operation + "'.");
            return 21;
        }
        LOGGER.debug("Repository authorization for '" + operation + "' operation is allowed for user '" + user.getIdentifier() + "' (" + user.getUserCode() + ").");
        return 0;
    }

    public Pair<String, VCSGisUser> getAuthenticationToken(String userid, String password, SupportError error) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Pair<String, VCSGisUser> getGuestAuthenticationToken() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected abstract VCSGisUser getUser(String var1, String var2);

    protected abstract int checkToken(String var1, String var2, SupportError var3);
}

